/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.Patches;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ActiveStack;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.SideStack;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.commands.ApplyWindowInfoCmd;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.openapi.wm.impl.commands.InvokeLaterCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInEditorComponentCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd;
import com.intellij.openapi.wm.impl.commands.UpdateRootPaneCmd;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowManagerImpl
extends ToolWindowManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
    private final Project myProject;
    private final WindowManagerEx myWindowManager;
    private final EventListenerList myListenerList;
    private final DesktopLayout myLayout;
    private final HashMap<String, InternalDecorator> myId2InternalDecorator;
    private final HashMap<String, FloatingDecorator> myId2FloatingDecorator;
    private final HashMap<String, StripeButton> myId2StripeButton;
    private final HashMap<String, FocusWatcher> myId2FocusWatcher;
    private final Set<String> myDumbAwareIds = Collections.synchronizedSet(CollectionFactory.newTroveSet((Object[])new String[0]));
    private final EditorComponentFocusWatcher myEditorComponentFocusWatcher;
    private final MyToolWindowPropertyChangeListener myToolWindowPropertyChangeListener;
    private final InternalDecoratorListener myInternalDecoratorListener;
    private boolean myEditorComponentActive;
    private final ActiveStack myActiveStack;
    private final SideStack mySideStack;
    private ToolWindowsPane myToolWindowsPane;
    private IdeFrameImpl myFrame;
    private DesktopLayout myLayoutToRestoreLater = null;
    @NonNls
    private static final String EDITOR_ELEMENT = "editor";
    @NonNls
    private static final String ACTIVE_ATTR_VALUE = "active";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    private final Application myApp;
    private Set<String> myRestoredToolWindowIds = new HashSet<String>();

    public ToolWindowManagerImpl(Project project, WindowManagerEx windowManagerEx, Application app) {
        this.myApp = app;
        this.myProject = project;
        this.myWindowManager = windowManagerEx;
        this.myListenerList = new EventListenerList();
        this.myLayout = new DesktopLayout();
        this.myLayout.copyFrom(windowManagerEx.getLayout());
        this.myId2InternalDecorator = new HashMap();
        this.myId2FloatingDecorator = new HashMap();
        this.myId2StripeButton = new HashMap();
        this.myId2FocusWatcher = new HashMap();
        this.myEditorComponentFocusWatcher = new EditorComponentFocusWatcher();
        this.myToolWindowPropertyChangeListener = new MyToolWindowPropertyChangeListener();
        this.myInternalDecoratorListener = new MyInternalDecoratorListener();
        this.myEditorComponentActive = false;
        this.myActiveStack = new ActiveStack();
        this.mySideStack = new SideStack();
    }

    FocusManagerImpl getFocusManagerImpl() {
        return FocusManagerImpl.getInstance();
    }

    public Project getProject() {
        return this.myProject;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        final MyUIManagerPropertyChangeListener myUIManagerPropertyChangeListener = new MyUIManagerPropertyChangeListener();
        final MyLafManagerListener myLafManagerListener = new MyLafManagerListener();
        UIManager.addPropertyChangeListener(myUIManagerPropertyChangeListener);
        LafManager.getInstance().addLafManagerListener((LafManagerListener)myLafManagerListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                UIManager.removePropertyChangeListener(myUIManagerPropertyChangeListener);
                LafManager.getInstance().removeLafManagerListener((LafManagerListener)myLafManagerListener);
            }
        });
        this.myFrame = this.myWindowManager.allocateFrame(this.myProject);
        LOG.assertTrue(this.myFrame != null);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.myToolWindowsPane = new ToolWindowsPane(this.myFrame, this);
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(this.myToolWindowsPane);
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        this.myFrame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(this.myProject));
        JComponent editorComponent = FileEditorManagerEx.getInstanceEx(this.myProject).getComponent();
        this.myEditorComponentFocusWatcher.install(editorComponent);
        this.appendSetEditorComponentCmd(editorComponent, commandsList);
        if (this.myEditorComponentActive) {
            this.activateEditorComponentImpl(commandsList, true);
        }
        this.execute(commandsList);
        final DumbService.DumbModeListener dumbModeListener = new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                for (String id : ToolWindowManagerImpl.this.getToolWindowIds()) {
                    if (ToolWindowManagerImpl.this.myDumbAwareIds.contains(id)) continue;
                    if (ToolWindowManagerImpl.this.isToolWindowVisible(id)) {
                        ToolWindowManagerImpl.this.hideToolWindow(id, true);
                    }
                    ToolWindowManagerImpl.this.getStripeButton(id).setEnabled(false);
                }
            }

            public void exitDumbMode() {
                for (String id : ToolWindowManagerImpl.this.getToolWindowIds()) {
                    ToolWindowManagerImpl.this.getStripeButton(id).setEnabled(true);
                }
            }
        };
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)dumbModeListener);
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ToolWindowManagerImpl.this.registerToolWindowsFromBeans();
                if (DumbService.getInstance((Project)ToolWindowManagerImpl.this.myProject).isDumb()) {
                    dumbModeListener.enteredDumbMode();
                }
            }
        });
    }

    private void registerToolWindowsFromBeans() {
        ToolWindowEP[] beans;
        for (ToolWindowEP bean : beans = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
            ToolWindowAnchor toolWindowAnchor;
            Condition condition = bean.getCondition();
            if (condition != null && !condition.value((Object)this.myProject)) continue;
            try {
                toolWindowAnchor = ToolWindowAnchor.fromText((String)bean.anchor);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            JLabel label = new JLabel("Initializing...", 0);
            label.setOpaque(true);
            Color treeBg = UIManager.getColor("Tree.background");
            label.setBackground(new Color(treeBg.getRed(), treeBg.getGreen(), treeBg.getBlue(), 180));
            Color treeFg = UIManager.getColor("Tree.foreground");
            label.setForeground(new Color(treeFg.getRed(), treeFg.getGreen(), treeFg.getBlue(), 180));
            ToolWindowFactory factory = bean.getToolWindowFactory();
            final ToolWindowImpl toolWindow = (ToolWindowImpl)this.registerToolWindow(bean.id, label, toolWindowAnchor, (Disposable)this.myProject, factory instanceof DumbAware);
            toolWindow.setContentFactory(factory);
            if (bean.icon != null) {
                Icon icon = IconLoader.findIcon((String)bean.icon, factory.getClass());
                if (icon == null) {
                    try {
                        icon = IconLoader.getIcon((String)bean.icon);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                toolWindow.setIcon(icon);
            }
            if (!this.getInfo(bean.id).isSplit() && bean.secondary && !this.myRestoredToolWindowIds.contains(bean.id)) {
                toolWindow.setSplitMode(bean.secondary, null);
            }
            final ActionCallback activation = toolWindow.setActivation(new ActionCallback());
            UiNotifyConnector.doWhenFirstShown((JComponent)label, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                        public void run() {
                            toolWindow.ensureContentInitialized();
                            activation.setDone();
                        }
                    });
                }
            });
        }
    }

    public void projectClosed() {
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        String[] ids = this.getToolWindowIds();
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(null);
        this.myWindowManager.releaseFrame(this.myFrame);
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        for (String id : ids) {
            this.deactivateToolWindowImpl(id, true, commandsList);
        }
        JComponent editorComponent = FileEditorManagerEx.getInstanceEx(this.myProject).getComponent();
        this.myEditorComponentFocusWatcher.deinstall(editorComponent);
        this.appendSetEditorComponentCmd(null, commandsList);
        this.execute(commandsList);
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.addToolWindowManagerListener must not be null");
        }
        this.myListenerList.add(ToolWindowManagerListener.class, l);
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.removeToolWindowManagerListener must not be null");
        }
        this.myListenerList.remove(ToolWindowManagerListener.class, l);
    }

    private void execute(ArrayList<FinalizableCommand> commandList) {
        for (FinalizableCommand each : commandList) {
            if (!each.willChangeState()) continue;
            this.fireStateChanged();
            break;
        }
        for (FinalizableCommand each : commandList) {
            each.beforeExecute(this);
        }
        this.myWindowManager.getCommandProcessor().execute(commandList, this.myProject.getDisposed());
    }

    public void activateEditorComponent() {
        this.activateEditorComponent(true);
    }

    private void activateEditorComponent(boolean forced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateEditorComponent()");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.activateEditorComponentImpl(commandList, forced);
        this.execute(commandList);
    }

    private void activateEditorComponentImpl(ArrayList<FinalizableCommand> commandList, final boolean forced) {
        final String active = this.getActiveToolWindowId();
        this.appendRequestFocusInEditorComponentCmd(commandList, forced).doWhenDone(new Runnable(){

            @Override
            public void run() {
                ArrayList postExecute = new ArrayList();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("editor activated");
                }
                ToolWindowManagerImpl.this.deactivateWindows(postExecute, null);
                ToolWindowManagerImpl.this.myActiveStack.clear();
                ToolWindowManagerImpl.this.myEditorComponentActive = true;
                ToolWindowManagerImpl.this.execute(postExecute);
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                if (forced) {
                    ToolWindowManagerImpl.this.getFocusManagerImpl().requestFocus(new FocusCommand(){

                        public ActionCallback run() {
                            ArrayList cmds = new ArrayList();
                            WindowInfoImpl toReactivate = ToolWindowManagerImpl.this.getInfo(active);
                            boolean reactivateLastActive = toReactivate != null && !ToolWindowManagerImpl.this.isToHide(toReactivate);
                            ToolWindowManagerImpl.this.deactivateWindows(cmds, reactivateLastActive ? active : null);
                            ToolWindowManagerImpl.this.execute(cmds);
                            if (reactivateLastActive) {
                                ToolWindowManagerImpl.this.activateToolWindow(active, false, true);
                            } else {
                                if (active != null) {
                                    ToolWindowManagerImpl.this.myActiveStack.remove(active, false);
                                }
                                if (!ToolWindowManagerImpl.this.myActiveStack.isEmpty()) {
                                    ToolWindowManagerImpl.this.activateToolWindow(ToolWindowManagerImpl.this.myActiveStack.peek(), false, true);
                                }
                            }
                            return new ActionCallback.Done();
                        }
                    }, false);
                }
            }
        });
    }

    private void deactivateWindows(ArrayList<FinalizableCommand> postExecute, String idToIgnore) {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            boolean shouldHide = this.isToHide(info);
            if (idToIgnore != null && idToIgnore.equals(info.getId())) continue;
            this.deactivateToolWindowImpl(info.getId(), shouldHide, postExecute);
        }
    }

    private boolean isToHide(WindowInfoImpl info) {
        return !(!info.isAutoHide() && !info.isSliding() || info.isFloating() && this.hasModalChild(info));
    }

    private void showAndActivate(String id, boolean dirtyMode, ArrayList<FinalizableCommand> commandsList, boolean autoFocusContents) {
        if (!this.getToolWindow(id).isAvailable()) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        boolean toApplyInfo = false;
        if (!info.isActive()) {
            info.setActive(true);
            toApplyInfo = true;
        }
        this.showToolWindowImpl(id, dirtyMode, commandsList);
        if (toApplyInfo) {
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.myActiveStack.push(id);
            this.myEditorComponentActive = false;
        }
        if (autoFocusContents) {
            this.appendRequestFocusInToolWindowCmd(id, commandsList, true);
        }
    }

    void activateToolWindow(String id, boolean forced, boolean autoFocusContents) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        if (DumbService.getInstance((Project)this.myProject).isDumb() && !this.myDumbAwareIds.contains(id)) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.activateToolWindowImpl(id, commandList, forced, autoFocusContents);
        this.execute(commandList);
    }

    private void activateToolWindowImpl(String id, ArrayList<FinalizableCommand> commandList, boolean forced, boolean autoFocusContents) {
        if (!this.getFocusManagerImpl().isUnforcedRequestAllowed() && !forced) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindowImpl(" + id + ")");
        }
        if (!this.getToolWindow(id).isAvailable()) {
            InternalDecorator decorator = this.getInternalDecorator(id);
            if (!decorator.hasFocus() && autoFocusContents) {
                this.appendRequestFocusInToolWindowCmd(id, commandList, forced);
            }
            return;
        }
        this.prepareForActivation(id, commandList);
        this.showAndActivate(id, false, commandList, autoFocusContents);
    }

    private void checkId(String id) {
        if (!this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalStateException("window with id=\"" + id + "\" isn't registered");
        }
    }

    private void deactivateToolWindowImpl(String id, boolean shouldHide, List<FinalizableCommand> commandsList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: deactivateToolWindowImpl(" + id + "," + shouldHide + ")");
        }
        WindowInfoImpl info = this.getInfo(id);
        if (shouldHide && info.isVisible()) {
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, false, commandsList);
            }
        }
        info.setActive(false);
        this.appendApplyWindowInfoCmd(info, commandsList);
    }

    public String[] getToolWindowIds() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        WindowInfoImpl[] infos = this.myLayout.getInfos();
        String[] ids = ArrayUtil.newStringArray((int)infos.length);
        for (int i = 0; i < infos.length; ++i) {
            ids[i] = infos[i].getId();
        }
        return ids;
    }

    public String getActiveToolWindowId() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout.getActiveId();
    }

    @Override
    public String getLastActiveToolWindowId() {
        return this.getLastActiveToolWindowId(null);
    }

    @Override
    public String getLastActiveToolWindowId(Condition<JComponent> condition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String lastActiveToolWindowId = null;
        for (int i = 0; i < this.myActiveStack.getPersistentSize(); ++i) {
            String id = this.myActiveStack.peekPersistent(i);
            ToolWindow toolWindow = this.getToolWindow(id);
            LOG.assertTrue(toolWindow != null);
            if (!toolWindow.isAvailable() || condition != null && !condition.value((Object)toolWindow.getComponent())) continue;
            lastActiveToolWindowId = id;
            break;
        }
        return lastActiveToolWindowId;
    }

    private FloatingDecorator getFloatingDecorator(String id) {
        return (FloatingDecorator)this.myId2FloatingDecorator.get((Object)id);
    }

    private InternalDecorator getInternalDecorator(String id) {
        return (InternalDecorator)this.myId2InternalDecorator.get((Object)id);
    }

    private StripeButton getStripeButton(String id) {
        return (StripeButton)this.myId2StripeButton.get((Object)id);
    }

    private WindowInfoImpl getInfo(String id) {
        return this.myLayout.getInfo(id, true);
    }

    @Override
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.getIdsOn must not be null");
        }
        return this.myLayout.getVisibleIdsOn(anchor, this);
    }

    public ToolWindow getToolWindow(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return null;
        }
        return this.getInternalDecorator(id).getToolWindow();
    }

    void showToolWindow(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: showToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.showToolWindowImpl(id, false, commandList);
        this.execute(commandList);
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.hideToolWindow must not be null");
        }
        this.hideToolWindow(id, hideSide, true);
    }

    public void hideToolWindow(String id, boolean hideSide, boolean moveFocus) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (!info.isVisible()) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        boolean wasActive = info.isActive();
        this.deactivateToolWindowImpl(id, true, commandList);
        if (hideSide || info.isFloating()) {
            String[] all;
            List<String> ids = this.myLayout.getVisibleIdsOn(info.getAnchor(), this);
            for (String each : ids) {
                this.myActiveStack.remove(each, true);
            }
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                this.mySideStack.pop(info.getAnchor());
            }
            for (String eachId : all = this.getToolWindowIds()) {
                WindowInfoImpl eachInfo = this.getInfo(eachId);
                if (!eachInfo.isVisible() || eachInfo.getAnchor() != info.getAnchor()) continue;
                this.deactivateToolWindowImpl(eachId, true, commandList);
            }
            this.activateEditorComponentImpl(commandList, true);
        } else {
            WindowInfoImpl info2 = null;
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                WindowInfoImpl storedInfo = this.mySideStack.pop(info.getAnchor());
                WindowInfoImpl currentInfo = this.getInfo(storedInfo.getId());
                LOG.assertTrue(currentInfo != null);
                if (storedInfo.getAnchor() != currentInfo.getAnchor() || storedInfo.getType() != currentInfo.getType() || storedInfo.isAutoHide() != currentInfo.isAutoHide()) continue;
                info2 = storedInfo;
                break;
            }
            if (info2 != null) {
                this.showToolWindowImpl(info2.getId(), false, commandList);
            }
            this.myActiveStack.remove(id, false);
            if (wasActive && moveFocus) {
                if (this.myActiveStack.isEmpty()) {
                    this.activateEditorComponentImpl(commandList, false);
                } else {
                    String toBeActivatedId = this.myActiveStack.pop();
                    if (toBeActivatedId != null) {
                        this.activateToolWindowImpl(toBeActivatedId, commandList, false, true);
                    }
                }
            }
        }
        this.execute(commandList);
    }

    private void showToolWindowImpl(String id, boolean dirtyMode, List<FinalizableCommand> commandsList) {
        WindowInfoImpl toBeShownInfo = this.getInfo(id);
        if (toBeShownInfo.isVisible() || !this.getToolWindow(id).isAvailable()) {
            return;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb() && !this.myDumbAwareIds.contains(id)) {
            return;
        }
        toBeShownInfo.setVisible(true);
        InternalDecorator decorator = this.getInternalDecorator(id);
        if (toBeShownInfo.isFloating()) {
            commandsList.add(new AddFloatingDecoratorCmd(decorator, toBeShownInfo));
        } else {
            WindowInfoImpl[] infos;
            for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
                if (id.equals(info.getId()) || !info.isVisible() || info.getType() != toBeShownInfo.getType() || info.getAnchor() != toBeShownInfo.getAnchor() || info.isSplit() != toBeShownInfo.isSplit()) continue;
                info.setVisible(false);
                this.appendRemoveDecoratorCmd(info.getId(), false, commandsList);
                if (info.isActive()) {
                    info.setActive(false);
                }
                this.appendApplyWindowInfoCmd(info, commandsList);
                if (!info.isDocked() || info.isAutoHide()) continue;
                this.mySideStack.push(info);
            }
            this.appendAddDecoratorCmd(decorator, toBeShownInfo, dirtyMode, commandsList);
            this.mySideStack.remove(id);
        }
        this.appendApplyWindowInfoCmd(toBeShownInfo, commandsList);
    }

    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerToolWindow(id, component, anchor, false);
    }

    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerToolWindow(id, component, anchor, parentDisposable, false);
    }

    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerDisposable(id, parentDisposable, this.registerToolWindow(id, component, anchor, canWorkInDumbMode));
    }

    private ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerToolWindow(id, component, anchor, false, false, canWorkInDumbMode);
    }

    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerToolWindow(id, null, anchor, false, canCloseContent, false);
    }

    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, boolean sideTool) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerToolWindow(id, null, anchor, sideTool, canCloseContent, false);
    }

    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        return this.registerDisposable(id, parentDisposable, this.registerToolWindow(id, null, anchor, false, canCloseContent, canWorkInDumbMode));
    }

    private ToolWindow registerToolWindow(@NotNull String id, @Nullable JComponent component, @NotNull ToolWindowAnchor anchor, boolean sideTool, boolean canCloseContent, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.registerToolWindow must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: installToolWindow(" + id + "," + component + "," + anchor + "\")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalArgumentException("window with id=\"" + id + "\" is already registered");
        }
        WindowInfoImpl info = this.myLayout.register(id, anchor, sideTool);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        info.setActive(false);
        info.setVisible(false);
        ToolWindowImpl toolWindow = new ToolWindowImpl(this, id, canCloseContent, component);
        InternalDecorator decorator = new InternalDecorator(this.myProject, info.copy(), toolWindow);
        this.myId2InternalDecorator.put((Object)id, (Object)decorator);
        decorator.addInternalDecoratorListener(this.myInternalDecoratorListener);
        toolWindow.addPropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myId2FocusWatcher.put((Object)id, (Object)new ToolWindowFocusWatcher(toolWindow));
        StripeButton button = new StripeButton(decorator, this.myToolWindowsPane);
        this.myId2StripeButton.put((Object)id, (Object)button);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendAddButtonCmd(button, info, commandsList);
        if (canWorkInDumbMode) {
            this.myDumbAwareIds.add(id);
        } else if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            button.setEnabled(false);
        }
        if (!info.isAutoHide() && (info.isDocked() || info.isFloating())) {
            if (wasActive) {
                this.activateToolWindowImpl(info.getId(), commandsList, true, true);
            } else if (wasVisible) {
                this.showToolWindowImpl(info.getId(), false, commandsList);
            }
        } else if (wasActive) {
            this.activateEditorComponentImpl(commandsList, true);
        }
        this.execute(commandsList);
        this.fireToolWindowRegistered(id);
        return toolWindow;
    }

    private ToolWindow registerDisposable(final String id, Disposable parentDisposable, ToolWindow window) {
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ToolWindowManagerImpl.this.unregisterToolWindow(id);
            }
        });
        return window;
    }

    public void unregisterToolWindow(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.unregisterToolWindow must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: unregisterToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        ToolWindowEx toolWindow = (ToolWindowEx)this.getToolWindow(id);
        this.myLayout.unregister(id);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        if (info.isVisible()) {
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, false, commandsList);
            }
        }
        this.appendRemoveButtonCmd(id, commandsList);
        this.appendApplyWindowInfoCmd(info, commandsList);
        this.execute(commandsList);
        toolWindow.removePropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myActiveStack.remove(id, true);
        this.mySideStack.remove(id);
        StripeButton button = this.getStripeButton(id);
        button.dispose();
        this.myId2StripeButton.remove((Object)id);
        this.myId2FocusWatcher.remove((Object)id);
        InternalDecorator decorator = this.getInternalDecorator(id);
        decorator.dispose();
        decorator.removeInternalDecoratorListener(this.myInternalDecoratorListener);
        this.myId2InternalDecorator.remove((Object)id);
    }

    @Override
    public DesktopLayout getLayout() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout;
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
        this.myLayoutToRestoreLater = layout;
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return this.myLayoutToRestoreLater;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        WindowInfoImpl info;
        WindowInfoImpl[] currentInfos;
        if (layout == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.setLayout must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        for (WindowInfoImpl currentInfo : currentInfos = this.myLayout.getInfos()) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !currentInfo.isVisible() || info.isVisible()) continue;
            this.deactivateToolWindowImpl(currentInfo.getId(), true, commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getAnchor() == info.getAnchor() && currentInfo.getOrder() == info.getOrder()) continue;
            this.setToolWindowAnchorImpl(currentInfo.getId(), info.getAnchor(), info.getOrder(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getType() == info.getType()) continue;
            this.setToolWindowTypeImpl(currentInfo.getId(), info.getType(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.isAutoHide() == info.isAutoHide()) continue;
            this.setToolWindowAutoHideImpl(currentInfo.getId(), info.isAutoHide(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !info.isVisible()) continue;
            this.showToolWindowImpl(currentInfo.getId(), false, commandList);
        }
        if (!this.myEditorComponentActive && this.getActiveToolWindowId() == null) {
            this.activateEditorComponentImpl(commandList, true);
        }
        this.execute(commandList);
    }

    public void invokeLater(Runnable runnable) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        commandList.add(new InvokeLaterCmd(runnable, this.myWindowManager.getCommandProcessor()));
        this.execute(commandList);
    }

    public IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.notifyByBalloon must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.notifyByBalloon must not be null");
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.notifyByBalloon must not be null");
        }
        this.notifyByBalloon(toolWindowId, type, htmlBody, null, null);
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.notifyByBalloon must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.notifyByBalloon must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.notifyByBalloon must not be null");
        }
        this.checkId(toolWindowId);
        final Stripe stripe = this.myToolWindowsPane.getStripeFor(toolWindowId);
        final ToolWindowImpl window = this.getInternalDecorator(toolWindowId).getToolWindow();
        if (!window.isAvailable()) {
            window.setPlaceholderMode(true);
            stripe.updateState();
            stripe.revalidate();
            stripe.repaint();
        }
        final ToolWindowAnchor anchor = this.getInfo(toolWindowId).getAnchor();
        final Ref position = Ref.create((Object)Balloon.Position.below);
        if (ToolWindowAnchor.TOP == anchor) {
            position.set((Object)Balloon.Position.below);
        } else if (ToolWindowAnchor.BOTTOM == anchor) {
            position.set((Object)Balloon.Position.above);
        } else if (ToolWindowAnchor.LEFT == anchor) {
            position.set((Object)Balloon.Position.atRight);
        } else if (ToolWindowAnchor.RIGHT == anchor) {
            position.set((Object)Balloon.Position.atLeft);
        }
        Icon actualIcon = icon != null ? icon : type.getDefaultIcon();
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text.replace("\n", "<br>"), actualIcon, type.getPopupBackground(), listener).createBalloon();
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                window.setPlaceholderMode(false);
                stripe.updateState();
                stripe.revalidate();
                stripe.repaint();
            }
        });
        final StripeButton button = stripe.getButtonFor(toolWindowId);
        if (button == null) {
            return;
        }
        final Runnable show = new Runnable(){

            @Override
            public void run() {
                if (button.isShowing()) {
                    Point point = new Point(button.getBounds().width / 2, button.getHeight() / 2 - 2);
                    balloon.show(new RelativePoint((Component)button, point), (Balloon.Position)position.get());
                } else {
                    Rectangle bounds = ToolWindowManagerImpl.this.myToolWindowsPane.getBounds();
                    Point target = UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)new Dimension(1, 1));
                    if (ToolWindowAnchor.TOP == anchor) {
                        target.y = 0;
                    } else if (ToolWindowAnchor.BOTTOM == anchor) {
                        target.y = bounds.height - 3;
                    } else if (ToolWindowAnchor.LEFT == anchor) {
                        target.x = 0;
                    } else if (ToolWindowAnchor.RIGHT == anchor) {
                        target.x = bounds.width;
                    }
                    balloon.show(new RelativePoint((Component)ToolWindowManagerImpl.this.myToolWindowsPane, target), (Balloon.Position)position.get());
                }
            }
        };
        if (!button.isValid()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    show.run();
                }
            });
        } else {
            show.run();
        }
    }

    public boolean isEditorComponentActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myEditorComponentActive;
    }

    ToolWindowAnchor getToolWindowAnchor(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getAnchor();
    }

    void setToolWindowAnchor(String id, ToolWindowAnchor anchor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setToolWindowAnchor(id, anchor, -1);
    }

    void setToolWindowAnchor(String id, ToolWindowAnchor anchor, int order) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchorImpl(id, anchor, order, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAnchorImpl(String id, ToolWindowAnchor anchor, int order, ArrayList<FinalizableCommand> commandsList) {
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (anchor == info.getAnchor() && order == info.getOrder()) {
            return;
        }
        if (!info.isVisible() || anchor == info.getAnchor() || info.isFloating()) {
            WindowInfoImpl[] infos;
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
        } else {
            WindowInfoImpl[] infos;
            info.setVisible(false);
            this.appendRemoveDecoratorCmd(id, false, commandsList);
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
            this.showToolWindowImpl(id, false, commandsList);
            if (info.isActive()) {
                this.appendRequestFocusInToolWindowCmd(id, commandsList, true);
            }
        }
    }

    boolean isSplitMode(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isSplit();
    }

    ToolWindowContentUiType getContentUiType(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getContentUiType();
    }

    void setSideTool(String id, boolean isSide) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    public void setContentUiType(String id, ToolWindowContentUiType type) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        info.setContentUiType(type);
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    void setSideToolAndAnchor(String id, ToolWindowAnchor anchor, int order, boolean isSide) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchor(id, anchor, order);
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    private void setSplitModeImpl(String id, boolean isSplit, ArrayList<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (isSplit == info.isSplit()) {
            return;
        }
        this.myLayout.setSplitMode(id, isSplit);
        boolean wasActive = info.isActive();
        if (wasActive) {
            this.deactivateToolWindowImpl(id, true, commandList);
        }
        for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
            this.appendApplyWindowInfoCmd(info1, commandList);
        }
        if (wasActive) {
            this.activateToolWindowImpl(id, commandList, true, true);
        }
        commandList.add(this.myToolWindowsPane.createUpdateButtonPositionCmd(id, this.myWindowManager.getCommandProcessor()));
    }

    ToolWindowType getToolWindowInternalType(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getInternalType();
    }

    ToolWindowType getToolWindowType(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getType();
    }

    private void fireToolWindowRegistered(String id) {
        ToolWindowManagerListener[] listeners;
        for (ToolWindowManagerListener listener : listeners = (ToolWindowManagerListener[])this.myListenerList.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowRegistered(id);
        }
    }

    private void fireStateChanged() {
        ToolWindowManagerListener[] listeners;
        for (ToolWindowManagerListener listener : listeners = (ToolWindowManagerListener[])this.myListenerList.getListeners(ToolWindowManagerListener.class)) {
            listener.stateChanged();
        }
    }

    boolean isToolWindowActive(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isActive();
    }

    boolean isToolWindowAutoHide(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isAutoHide();
    }

    public boolean isToolWindowFloating(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isFloating();
    }

    boolean isToolWindowVisible(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isVisible();
    }

    void setToolWindowAutoHide(String id, boolean autoHide) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAutoHideImpl(id, autoHide, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAutoHideImpl(String id, boolean autoHide, ArrayList<FinalizableCommand> commandsList) {
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.isAutoHide() == autoHide) {
            return;
        }
        info.setAutoHide(autoHide);
        this.appendApplyWindowInfoCmd(info, commandsList);
        if (info.isVisible()) {
            this.prepareForActivation(id, commandsList);
            this.showAndActivate(id, false, commandsList, true);
        }
    }

    void setToolWindowType(String id, ToolWindowType type) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowTypeImpl(id, type, commandList);
        this.execute(commandList);
    }

    private void setToolWindowTypeImpl(String id, ToolWindowType type, ArrayList<FinalizableCommand> commandsList) {
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.getType() == type) {
            return;
        }
        if (info.isVisible()) {
            boolean dirtyMode = info.isDocked() || info.isSliding();
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, dirtyMode, commandsList);
            }
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.prepareForActivation(id, commandsList);
            this.showAndActivate(id, dirtyMode, commandsList, true);
            this.appendUpdateToolWindowsPaneCmd(commandsList);
        } else {
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
        }
    }

    private void appendApplyWindowInfoCmd(WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        StripeButton button = this.getStripeButton(info.getId());
        InternalDecorator decorator = this.getInternalDecorator(info.getId());
        commandsList.add(new ApplyWindowInfoCmd(info, button, decorator, this.myWindowManager.getCommandProcessor()));
    }

    private void appendAddDecoratorCmd(InternalDecorator decorator, WindowInfoImpl info, boolean dirtyMode, List<FinalizableCommand> commandsList) {
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        FinalizableCommand command = this.myToolWindowsPane.createAddDecoratorCmd(decorator, info, dirtyMode, commandProcessor);
        commandsList.add(command);
    }

    private void appendRemoveDecoratorCmd(String id, boolean dirtyMode, List<FinalizableCommand> commandsList) {
        FinalizableCommand command = this.myToolWindowsPane.createRemoveDecoratorCmd(id, dirtyMode, this.myWindowManager.getCommandProcessor());
        commandsList.add(command);
    }

    private void appendRemoveFloatingDecoratorCmd(WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        RemoveFloatingDecoratorCmd command = new RemoveFloatingDecoratorCmd(info);
        commandsList.add(command);
    }

    private void appendAddButtonCmd(StripeButton button, WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        Comparator comparator = this.myLayout.comparator(info.getAnchor());
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        FinalizableCommand command = this.myToolWindowsPane.createAddButtonCmd(button, info, comparator, commandProcessor);
        commandsList.add(command);
    }

    private void appendRemoveButtonCmd(String id, List<FinalizableCommand> commandsList) {
        FinalizableCommand command = this.myToolWindowsPane.createRemoveButtonCmd(id, this.myWindowManager.getCommandProcessor());
        commandsList.add(command);
    }

    private ActionCallback appendRequestFocusInEditorComponentCmd(ArrayList<FinalizableCommand> commandList, boolean forced) {
        if (this.myProject.isDisposed()) {
            return new ActionCallback.Done();
        }
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        RequestFocusInEditorComponentCmd command = new RequestFocusInEditorComponentCmd(FileEditorManagerEx.getInstanceEx(this.myProject), this.getFocusManager(), commandProcessor, forced);
        commandList.add(command);
        return command.getDoneCallback();
    }

    private void appendRequestFocusInToolWindowCmd(String id, ArrayList<FinalizableCommand> commandList, boolean forced) {
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.getToolWindow(id);
        FocusWatcher focusWatcher = (FocusWatcher)this.myId2FocusWatcher.get((Object)id);
        commandList.add(new RequestFocusInToolWindowCmd(this.getFocusManager(), toolWindow, focusWatcher, this.myWindowManager.getCommandProcessor(), forced));
    }

    private void appendSetEditorComponentCmd(JComponent component, List<FinalizableCommand> commandsList) {
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        FinalizableCommand command = this.myToolWindowsPane.createSetEditorComponentCmd(component, commandProcessor);
        commandsList.add(command);
    }

    private void appendUpdateToolWindowsPaneCmd(List<FinalizableCommand> commandsList) {
        JRootPane rootPane = this.myFrame.getRootPane();
        UpdateRootPaneCmd command = new UpdateRootPaneCmd(rootPane, this.myWindowManager.getCommandProcessor());
        commandsList.add(command);
    }

    private boolean hasModalChild(WindowInfoImpl info) {
        if (!info.isVisible() || !info.isFloating()) {
            return false;
        }
        FloatingDecorator decorator = this.getFloatingDecorator(info.getId());
        LOG.assertTrue(decorator != null);
        return ToolWindowManagerImpl.isModalOrHasModalChild(decorator);
    }

    private static boolean isModalOrHasModalChild(Window window) {
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            if (dialog.isModal() && dialog.isShowing()) {
                return true;
            }
            Window[] ownedWindows = dialog.getOwnedWindows();
            for (int i = ownedWindows.length - 1; i >= 0; --i) {
                if (!ToolWindowManagerImpl.isModalOrHasModalChild(ownedWindows[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void prepareForActivation(String id, List<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        WindowInfoImpl toBeActivatedInfo = this.getInfo(id);
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            if (id.equals(info.getId())) continue;
            if (toBeActivatedInfo.isDocked() || toBeActivatedInfo.isSliding()) {
                this.deactivateToolWindowImpl(info.getId(), info.isAutoHide() || info.isSliding(), commandList);
                continue;
            }
            this.deactivateToolWindowImpl(info.getId(), info.isAutoHide() && info.isFloating() && !this.hasModalChild(info), commandList);
        }
    }

    @Override
    public void clearSideStack() {
        this.mySideStack.clear();
    }

    public void readExternal(Element element) {
        for (Object o : element.getChildren()) {
            WindowInfoImpl[] windowInfos;
            Element e = (Element)o;
            if (EDITOR_ELEMENT.equals(e.getName())) {
                this.myEditorComponentActive = Boolean.valueOf(e.getAttributeValue(ACTIVE_ATTR_VALUE));
                continue;
            }
            if (!"layout".equals(e.getName())) continue;
            this.myLayout.readExternal(e);
            for (WindowInfoImpl windowInfo : windowInfos = this.myLayout.getAllInfos()) {
                this.myRestoredToolWindowIds.add(windowInfo.getId());
            }
        }
    }

    public void writeExternal(Element element) {
        String[] ids;
        if (this.myFrame == null) {
            return;
        }
        for (String id : ids = this.getToolWindowIds()) {
            WindowInfoImpl info = this.getInfo(id);
            if (!info.isVisible()) continue;
            InternalDecorator decorator = this.getInternalDecorator(id);
            LOG.assertTrue(decorator != null);
            decorator.fireResized();
        }
        Rectangle frameBounds = this.myFrame.getBounds();
        Element frameElement = new Element(FRAME_ELEMENT);
        element.addContent(frameElement);
        frameElement.setAttribute(X_ATTR, Integer.toString(frameBounds.x));
        frameElement.setAttribute(Y_ATTR, Integer.toString(frameBounds.y));
        frameElement.setAttribute(WIDTH_ATTR, Integer.toString(frameBounds.width));
        frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(frameBounds.height));
        frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(this.myFrame.getExtendedState()));
        Element editorElement = new Element(EDITOR_ELEMENT);
        editorElement.setAttribute(ACTIVE_ATTR_VALUE, this.myEditorComponentActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        element.addContent(editorElement);
        Element layoutElement = new Element("layout");
        element.addContent(layoutElement);
        this.myLayout.writeExternal(layoutElement);
    }

    public void setDefaultState(@NotNull ToolWindowImpl toolWindow, @Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        if (toolWindow == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.setDefaultState must not be null");
        }
        WindowInfoImpl info = this.getInfo(toolWindow.getId());
        if (info.wasRead()) {
            return;
        }
        if (floatingBounds != null) {
            info.setFloatingBounds(floatingBounds);
        }
        if (anchor != null) {
            toolWindow.setAnchor(anchor, null);
        }
        if (type != null) {
            toolWindow.setType(type, null);
        }
    }

    public void setDefaultContentUiType(ToolWindowImpl toolWindow, ToolWindowContentUiType type) {
        WindowInfoImpl info = this.getInfo(toolWindow.getId());
        if (info.wasRead()) {
            return;
        }
        toolWindow.setContentUiType(type, null);
    }

    public void stretchWidth(ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchWidth(toolWindow, value);
    }

    public void stretchHeight(ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchHeight(toolWindow, value);
    }

    private void updateComponentTreeUI() {
        WindowInfoImpl[] infos;
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            if (info.isVisible()) continue;
            SwingUtilities.updateComponentTreeUI(this.getInternalDecorator(info.getId()));
        }
    }

    @NotNull
    public String getComponentName() {
        if ("ToolWindowManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/ToolWindowManagerImpl.getComponentName must not return null");
        }
        return "ToolWindowManager";
    }

    public ToolWindowsPane getToolWindowsPane() {
        return this.myToolWindowsPane;
    }

    public ActionCallback requestDefaultFocus(final boolean forced) {
        return this.getFocusManagerImpl().requestFocus(new FocusCommand(){

            public ActionCallback run() {
                return ToolWindowManagerImpl.this.processDefaultFocusRequest(forced);
            }
        }, forced);
    }

    private ActionCallback processDefaultFocusRequest(boolean forced) {
        if (ModalityState.NON_MODAL.equals(ModalityState.current())) {
            String activeId = this.getActiveToolWindowId();
            if (this.myEditorComponentActive || activeId == null || this.getToolWindow(activeId) == null) {
                this.activateEditorComponent(forced);
            } else {
                this.activateToolWindow(activeId, forced, false);
            }
        }
        return new ActionCallback.Done();
    }

    private boolean isProjectComponent(Component c) {
        Component frame = UIUtil.findUltimateParent((Component)c);
        if (frame instanceof IdeFrame) {
            return frame == this.myWindowManager.getFrame(this.myProject);
        }
        return false;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.requestFocus must not be null");
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, forced);
        if (actionCallback == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/ToolWindowManagerImpl.requestFocus must not return null");
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.requestFocus must not be null");
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(command, forced);
        if (actionCallback == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/ToolWindowManagerImpl.requestFocus must not return null");
        }
        return actionCallback;
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.getFocusTargetFor must not be null");
        }
        return IdeFocusManager.getInstance((Project)this.myProject).getFocusTargetFor(comp);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.doWhenFocusSettlesDown must not be null");
        }
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(runnable);
    }

    public Component getFocusedDescendantFor(Component comp) {
        return IdeFocusManager.getInstance((Project)this.myProject).getFocusedDescendantFor(comp);
    }

    public boolean dispatch(KeyEvent e) {
        return IdeFocusManager.getInstance((Project)this.myProject).dispatch(e);
    }

    public void suspendKeyProcessingUntil(@NotNull ActionCallback done) {
        if (done == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/ToolWindowManagerImpl.suspendKeyProcessingUntil must not be null");
        }
        IdeFocusManager.getInstance((Project)this.myProject).suspendKeyProcessingUntil(done);
    }

    public boolean isFocusBeingTransferred() {
        return IdeFocusManager.getInstance((Project)this.myProject).isFocusBeingTransferred();
    }

    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        return IdeFocusManager.getInstance((Project)this.myProject).getTimestamp(trackOnlyForcedCommands);
    }

    private final class MyLafManagerListener
    implements LafManagerListener {
        private MyLafManagerListener() {
        }

        public void lookAndFeelChanged(LafManager source) {
            ToolWindowManagerImpl.this.updateComponentTreeUI();
        }
    }

    private final class MyUIManagerPropertyChangeListener
    implements PropertyChangeListener {
        private MyUIManagerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ToolWindowManagerImpl.this.updateComponentTreeUI();
        }
    }

    private final class MyInternalDecoratorListener
    implements InternalDecoratorListener {
        private MyInternalDecoratorListener() {
        }

        @Override
        public void anchorChanged(InternalDecorator source, ToolWindowAnchor anchor) {
            ToolWindowManagerImpl.this.setToolWindowAnchor(source.getToolWindow().getId(), anchor);
        }

        @Override
        public void autoHideChanged(InternalDecorator source, boolean autoHide) {
            ToolWindowManagerImpl.this.setToolWindowAutoHide(source.getToolWindow().getId(), autoHide);
        }

        @Override
        public void hidden(InternalDecorator source) {
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), false);
        }

        @Override
        public void hiddenSide(InternalDecorator source) {
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), true);
        }

        @Override
        public void contentUiTypeChanges(InternalDecorator source, ToolWindowContentUiType type) {
            ToolWindowManagerImpl.this.setContentUiType(source.getToolWindow().getId(), type);
        }

        @Override
        public void resized(InternalDecorator source) {
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(source.getToolWindow().getId());
            if (info.isFloating()) {
                Window owner = SwingUtilities.getWindowAncestor(source);
                if (owner != null) {
                    info.setFloatingBounds(owner.getBounds());
                }
            } else if (ToolWindowAnchor.TOP == info.getAnchor() || ToolWindowAnchor.BOTTOM == info.getAnchor()) {
                info.setWeight((float)source.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight());
                float newSideWeight = (float)source.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                if (newSideWeight < 1.0f) {
                    info.setSideWeight(newSideWeight);
                }
            } else {
                info.setWeight((float)source.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth());
                float newSideWeight = (float)source.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight();
                if (newSideWeight < 1.0f) {
                    info.setSideWeight(newSideWeight);
                }
            }
        }

        @Override
        public void activated(InternalDecorator source) {
            ToolWindowManagerImpl.this.activateToolWindow(source.getToolWindow().getId(), true, true);
        }

        @Override
        public void typeChanged(InternalDecorator source, ToolWindowType type) {
            ToolWindowManagerImpl.this.setToolWindowType(source.getToolWindow().getId(), type);
        }

        @Override
        public void sideStatusChanged(InternalDecorator source, boolean isSideTool) {
            ToolWindowManagerImpl.this.setSideTool(source.getToolWindow().getId(), isSideTool);
        }
    }

    private final class MyToolWindowPropertyChangeListener
    implements PropertyChangeListener {
        private MyToolWindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ToolWindowImpl toolWindow = (ToolWindowImpl)e.getSource();
            if ("available".equals(e.getPropertyName())) {
                WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(toolWindow.getId());
                if (!toolWindow.isAvailable() && info.isVisible()) {
                    ToolWindowManagerImpl.this.hideToolWindow(toolWindow.getId(), false);
                }
            }
        }
    }

    private final class ToolWindowFocusWatcher
    extends FocusWatcher {
        private final String myId;

        private ToolWindowFocusWatcher(ToolWindowImpl toolWindow) {
            this.myId = toolWindow.getId();
            this.install(toolWindow.getComponent());
        }

        protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
            return ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor().getCommandCount() == 0 && comp != null;
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor().getCommandCount() > 0 || component == null) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(this.myId);
            ToolWindowManagerImpl.this.getFocusManagerImpl().myFocusedComponentAlaram.cancelAllRequests();
            if (!info.isActive()) {
                ToolWindowManagerImpl.this.getFocusManagerImpl().myFocusedComponentAlaram.addRequest(new EdtRunnable(){

                    public void runEdt() {
                        if (!ToolWindowManagerImpl.this.myLayout.isToolWindowRegistered(ToolWindowFocusWatcher.this.myId)) {
                            return;
                        }
                        ToolWindowManagerImpl.this.activateToolWindow(ToolWindowFocusWatcher.this.myId, false, false);
                    }
                }, 100);
            }
        }
    }

    private final class EditorComponentFocusWatcher
    extends FocusWatcher {
        private EditorComponentFocusWatcher() {
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor().getCommandCount() > 0 || component == null) {
                return;
            }
            if (ToolWindowManagerImpl.this.myEditorComponentActive) {
                return;
            }
            final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            final Component owner = mgr.getFocusOwner();
            IdeFocusManager.getInstance((Project)ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    if (mgr.getFocusOwner() == owner) {
                        ToolWindowManagerImpl.this.activateEditorComponent(false);
                    }
                }
            });
        }
    }

    private final class RemoveFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private RemoveFloatingDecoratorCmd(WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor());
            this.myFloatingDecorator = ToolWindowManagerImpl.this.getFloatingDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2FloatingDecorator.remove((Object)info.getId());
            info.setFloatingBounds(this.myFloatingDecorator.getBounds());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Patches.SPECIAL_WINPUT_METHOD_PROCESSING) {
                    this.myFloatingDecorator.remove(this.myFloatingDecorator.getRootPane());
                }
                this.myFloatingDecorator.dispose();
            }
            finally {
                this.finish();
            }
        }

        @Override
        @Nullable
        public Condition getExpireCondition() {
            return Condition.FALSE;
        }
    }

    private final class AddFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private AddFloatingDecoratorCmd(InternalDecorator decorator, WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor());
            this.myFloatingDecorator = new FloatingDecorator(ToolWindowManagerImpl.this.myFrame, info.copy(), decorator);
            ToolWindowManagerImpl.this.myId2FloatingDecorator.put((Object)info.getId(), (Object)this.myFloatingDecorator);
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                this.myFloatingDecorator.setBounds(bounds);
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                this.myFloatingDecorator.setSize(size);
                this.myFloatingDecorator.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myFloatingDecorator.show();
            }
            finally {
                this.finish();
            }
        }
    }
}

