/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.pom.Navigatable;
import java.nio.charset.Charset;
import java.text.MessageFormat;

public class ChangeEncodingUpdateGroup
extends DefaultActionGroup {
    public void update(AnActionEvent e) {
        Navigatable navigatable;
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null && files.length > 1) {
            virtualFile = null;
        }
        if (virtualFile != null && (navigatable = (Navigatable)e.getData(PlatformDataKeys.NAVIGATABLE)) instanceof OpenFileDescriptor) {
            virtualFile = ((OpenFileDescriptor)navigatable).getFile();
        }
        Pair<String, Boolean> result = ChangeEncodingUpdateGroup.update(virtualFile);
        e.getPresentation().setText((String)result.getFirst());
        e.getPresentation().setEnabled(((Boolean)result.getSecond()).booleanValue());
    }

    public static Pair<String, Boolean> update(VirtualFile virtualFile) {
        String text;
        boolean enabled;
        boolean bl = enabled = virtualFile != null && ChooseFileEncodingAction.isEnabled(virtualFile);
        if (enabled) {
            String pattern;
            Charset charset = ChooseFileEncodingAction.charsetFromContent(virtualFile);
            if (charset != null) {
                pattern = "Encoding: {0}";
                enabled = false;
            } else if (FileDocumentManager.getInstance().isFileModified(virtualFile)) {
                pattern = "Save ''{0}''-encoded file in";
            } else if (LoadTextUtil.utfCharsetWasDetectedFromBytes(virtualFile)) {
                pattern = "Encoding: {0}";
                enabled = false;
            } else {
                pattern = "Change encoding from ''{0}'' to";
            }
            if (charset == null) {
                charset = virtualFile.getCharset();
            }
            text = MessageFormat.format(pattern, charset.displayName());
        } else {
            text = "Encoding";
        }
        return Pair.create((Object)text, (Object)enabled);
    }
}

