/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GroupByPackages {
    private final Map<File, Collection<File>> myParentToChildrenMap = new HashMap<File, Collection<File>>();
    private final Collection<File> myRoots = new HashSet<File>();

    public GroupByPackages(Collection<File> fiels) {
        Iterator<File> each = fiels.iterator();
        while (each.hasNext()) {
            this.process(each.next());
        }
        this.splitRoots();
    }

    private void splitRoots() {
        for (File oldRoot : new ArrayList<File>(this.myRoots)) {
            File newRoot;
            if (oldRoot.equals(newRoot = this.splitRoot(oldRoot))) continue;
            this.replaceRoot(oldRoot, newRoot);
        }
    }

    private void replaceRoot(File oldRoot, File newRoot) {
        this.myRoots.remove(oldRoot);
        this.myRoots.add(newRoot);
    }

    private File splitRoot(File oldRoot) {
        List<File> children = this.getChildren(oldRoot);
        if (children == null) {
            return oldRoot;
        }
        if (children.size() == 1) {
            return this.splitRoot((File)children.iterator().next());
        }
        return oldRoot;
    }

    private void process(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            this.myRoots.add(file);
            return;
        }
        if (!this.myParentToChildrenMap.containsKey(parent)) {
            this.myParentToChildrenMap.put(parent, new HashSet());
        }
        this.myParentToChildrenMap.get(parent).add(file);
        this.process(parent);
    }

    public List<File> getRoots() {
        return new ArrayList<File>(this.myRoots);
    }

    public List<File> getChildren(File file) {
        Collection<File> collection = this.myParentToChildrenMap.get(file);
        if (collection == null) {
            return new ArrayList<File>();
        }
        return new ArrayList<File>(collection);
    }
}

