/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MappingsToRoots {
    private final NewMappings myMappings;
    private final Project myProject;

    public MappingsToRoots(NewMappings mappings, Project project) {
        this.myMappings = mappings;
        this.myProject = project;
    }

    public VirtualFile[] getRootsUnderVcs(AbstractVcs vcs) {
        List result = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        if (convertor != null) {
            result = convertor.convertRoots(result);
        }
        Collections.sort(result, FilePathComparator.getInstance());
        if (!vcs.allowsNestedRoots()) {
            int i = 1;
            while (i < result.size()) {
                VirtualFile previous = (VirtualFile)result.get(i - 1);
                VirtualFile current = (VirtualFile)result.get(i);
                if (ExcludedFileIndex.getInstance((Project)this.myProject).isValidAncestor(previous, current)) {
                    result.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return VfsUtil.toVirtualFileArray((Collection)result);
    }
}

