/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vcs.impl.StringLenComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VcsRootIterator {
    private final Map<String, MyRootFilter> myOtherVcsFolders;
    private ExcludedFileIndex myExcludedFileIndex;

    public VcsRootIterator(Project project, AbstractVcs vcs) {
        VirtualFile[] roots;
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myOtherVcsFolders = new HashMap<String, MyRootFilter>();
        this.myExcludedFileIndex = ExcludedFileIndex.getInstance((Project)project);
        VcsRoot[] allRoots = plVcsManager.getAllVcsRoots();
        for (VirtualFile root : roots = plVcsManager.getRootsUnderVcs(vcs)) {
            MyRootFilter rootPresentFilter = new MyRootFilter(root, vcs.getName());
            rootPresentFilter.init(allRoots);
            this.myOtherVcsFolders.put(root.getUrl(), rootPresentFilter);
        }
    }

    public boolean acceptFolderUnderVcs(VirtualFile vcsRoot, VirtualFile file) {
        String vcsUrl = vcsRoot.getUrl();
        MyRootFilter rootFilter = this.myOtherVcsFolders.get(vcsUrl);
        if (rootFilter != null && !rootFilter.accept(file)) {
            return false;
        }
        return !this.myExcludedFileIndex.isExcludedFile(file);
    }

    public static boolean iterateVcsRoot(Project project, VirtualFile root, Processor<FilePath> processor) {
        MyRootIterator rootIterator = new MyRootIterator(project, root, processor);
        return rootIterator.iterate();
    }

    private static class MyRootIterator {
        private final Processor<FilePath> myProcessor;
        private final LinkedList<VirtualFile> myQueue;
        private final MyRootFilter myRootPresentFilter;
        private final ExcludedFileIndex myExcludedFileIndex;

        private MyRootIterator(Project project, VirtualFile root, Processor<FilePath> processor) {
            this.myProcessor = processor;
            ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            AbstractVcs vcs = plVcsManager.getVcsFor(root);
            this.myRootPresentFilter = vcs == null ? null : new MyRootFilter(root, vcs.getName());
            this.myExcludedFileIndex = ExcludedFileIndex.getInstance((Project)project);
            this.myQueue = new LinkedList();
            this.myQueue.add(root);
        }

        public boolean iterate() {
            while (!this.myQueue.isEmpty()) {
                VirtualFile[] files;
                VirtualFile current = this.myQueue.removeFirst();
                if (!this.myProcessor.process((Object)new FilePathImpl(current))) {
                    return false;
                }
                if (!current.isDirectory()) continue;
                for (VirtualFile child : files = current.getChildren()) {
                    if (this.myRootPresentFilter != null && !this.myRootPresentFilter.accept(child) || this.myExcludedFileIndex.isExcludedFile(child)) continue;
                    this.myQueue.add(child);
                }
            }
            return true;
        }
    }

    private static class MyRootFilter {
        private final VirtualFile myRoot;
        private final String myVcsName;
        private final List<String> myExcludedByOtherVcss;

        private MyRootFilter(VirtualFile root, String vcsName) {
            this.myRoot = root;
            this.myVcsName = vcsName;
            this.myExcludedByOtherVcss = new LinkedList<String>();
        }

        private void init(VcsRoot[] allRoots) {
            String ourPath = this.myRoot.getUrl();
            for (VcsRoot root : allRoots) {
                String url;
                if (Comparing.equal((String)root.vcs.getName(), (String)this.myVcsName) || !(url = root.path.getUrl()).startsWith(ourPath)) continue;
                this.myExcludedByOtherVcss.add(url);
            }
            Collections.sort(this.myExcludedByOtherVcss, StringLenComparator.getDescendingInstance());
        }

        public boolean accept(VirtualFile vf) {
            String url = vf.getUrl();
            for (String excludedByOtherVcs : this.myExcludedByOtherVcss) {
                if (url.length() > excludedByOtherVcs.length()) {
                    return true;
                }
                if (!url.startsWith(excludedByOtherVcs)) continue;
                return false;
            }
            return true;
        }
    }
}

