/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesFileNameDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;

public class WolfChangesFileNameDecorator
extends ChangesFileNameDecorator {
    private final WolfTheProblemSolver myProblemSolver;

    public WolfChangesFileNameDecorator(WolfTheProblemSolver problemSolver) {
        this.myProblemSolver = problemSolver;
    }

    @Override
    public void appendFileName(ChangesBrowserNodeRenderer renderer, VirtualFile vFile, String fileName, Color color, boolean highlightProblems) {
        int style = 0;
        Color underlineColor = null;
        if (highlightProblems && vFile != null && !vFile.isDirectory() && this.myProblemSolver.isProblemFile(vFile)) {
            underlineColor = Color.red;
            style = 8;
        }
        renderer.append(fileName, new SimpleTextAttributes(style, color, underlineColor));
    }
}

