/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.ui.AlienChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.AlienLocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserExtender;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.changes.ui.MultipleChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitChangeListDialog
extends DialogWrapper
implements CheckinProjectPanel,
TypeSafeDataProvider {
    private final CommitMessage myCommitMessageArea;
    private Splitter mySplitter;
    private final JPanel myAdditionalOptionsPanel;
    private final ChangesBrowser myBrowser;
    private final ChangesBrowserExtender myBrowserExtender;
    private CommitLegendPanel myLegend;
    private final List<RefreshableOnComponent> myAdditionalComponents = new ArrayList<RefreshableOnComponent>();
    private final List<CheckinHandler> myHandlers = new ArrayList<CheckinHandler>();
    private final String myActionName;
    private final Project myProject;
    private final List<CommitExecutor> myExecutors;
    private final Alarm myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private String myLastKnownComment = "";
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    @NonNls
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION";
    private final Action[] myExecutorActions;
    private final boolean myShowVcsCommit;
    private final Map<AbstractVcs, JPanel> myPerVcsOptionsPanels = new HashMap<AbstractVcs, JPanel>();
    @Nullable
    private final AbstractVcs myVcs;
    private final boolean myIsAlien;
    private boolean myDisposed = false;
    private final JLabel myWarningLabel;
    private final Map<String, CheckinChangeListSpecificComponent> myCheckinChangeListSpecificComponents;
    private final Map<String, String> myListComments;
    private String myLastSelectedListName;
    private CommitLegendPanel.ChangeInfoCalculator myChangesInfoCalculator;
    private final MyUpdateButtonsRunnable myUpdateButtonsRunnable = new MyUpdateButtonsRunnable(this);

    private static boolean commit(Project project, List<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, String comment) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultList = manager.getDefaultChangeList();
        ArrayList<LocalChangeList> changeLists = new ArrayList<LocalChangeList>(manager.getChangeListsCopy());
        CommitChangeListDialog dialog = new CommitChangeListDialog(project, changes, initialSelection, executors, showVcsCommit, defaultList, changeLists, null, false, comment);
        dialog.show();
        return dialog.isOK();
    }

    public static void commitPaths(Project project, Collection<FilePath> paths, LocalChangeList initialSelection, @Nullable CommitExecutor executor, String comment) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        HashSet<Change> changes = new HashSet<Change>();
        for (FilePath path : paths) {
            changes.addAll(manager.getChangesIn(path));
        }
        CommitChangeListDialog.commitChanges(project, changes, initialSelection, executor, comment);
    }

    public static boolean commitChanges(Project project, Collection<Change> changes, LocalChangeList initialSelection, CommitExecutor executor, String comment) {
        if (executor == null) {
            return CommitChangeListDialog.commitChanges(project, changes, initialSelection, CommitChangeListDialog.collectExecutors(project, changes), true, comment);
        }
        return CommitChangeListDialog.commitChanges(project, changes, initialSelection, Collections.singletonList(executor), false, comment);
    }

    public static List<CommitExecutor> collectExecutors(Project project, Collection<Change> changes) {
        ArrayList<CommitExecutor> result = new ArrayList<CommitExecutor>();
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        List<AbstractVcs> vcses = CommitChangeListDialog.getAffectedVcses(project, changes);
        for (AbstractVcs vcs : vcses) {
            result.addAll(vcs.getCommitExecutors());
        }
        result.addAll(manager.getRegisteredExecutors());
        return result;
    }

    public static boolean commitChanges(Project project, Collection<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, String comment) {
        if (changes.isEmpty()) {
            Messages.showWarningDialog((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
            return false;
        }
        return CommitChangeListDialog.commit(project, new ArrayList<Change>(changes), initialSelection, executors, showVcsCommit, comment);
    }

    public static void commitAlienChanges(Project project, List<Change> changes, AbstractVcs vcs, String changelistName, String comment) {
        AlienLocalChangeList lcl = new AlienLocalChangeList(changes, changelistName);
        new CommitChangeListDialog(project, changes, null, null, true, AlienLocalChangeList.DEFAULT_ALIEN, Collections.singletonList(lcl), vcs, true, comment).show();
    }

    private CommitChangeListDialog(Project project, List<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, LocalChangeList defaultChangeList, List<LocalChangeList> changeLists, AbstractVcs singleVcs, boolean isAlien, String comment) {
        super(project, true);
        ChangesBrowser browser;
        this.myProject = project;
        this.myExecutors = executors;
        this.myShowVcsCommit = showVcsCommit;
        this.myVcs = singleVcs;
        this.myListComments = new HashMap<String, String>();
        if (!(this.myShowVcsCommit || this.myExecutors != null && this.myExecutors.size() != 0)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.myAllOfDefaultChangeListChangesIncluded = changes.containsAll(defaultChangeList.getChanges());
        this.myIsAlien = isAlien;
        if (isAlien) {
            this.myBrowser = browser = new AlienChangeListBrowser(project, changeLists, changes, (ChangeList)initialSelection, true, true, singleVcs);
            this.myBrowserExtender = browser;
        } else {
            this.myBrowser = browser = new MultipleChangeListBrowser(project, changeLists, changes, (ChangeList)initialSelection, true, true, new Runnable(){

                @Override
                public void run() {
                    CommitChangeListDialog.this.updateWarning();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    for (CheckinHandler handler : CommitChangeListDialog.this.myHandlers) {
                        handler.includedChangesChanged();
                    }
                }
            });
            this.myBrowserExtender = ((MultipleChangeListBrowser)browser).getExtender();
        }
        this.myBrowserExtender.addToolbarActions(this);
        this.myBrowserExtender.addSelectedListChangeListener(new SelectedListChangeListener(){

            @Override
            public void selectedListChanged() {
                CommitChangeListDialog.this.updateOnListSelection();
            }
        });
        this.myBrowser.setDiffExtendUIFactory(new ShowDiffAction.DiffExtendUIFactory(){

            @Override
            public List<? extends AnAction> createActions(Change change) {
                return CommitChangeListDialog.this.myBrowser.createDiffActions(change);
            }

            @Override
            @Nullable
            public JComponent createBottomComponent() {
                return new DiffCommitMessageEditor(CommitChangeListDialog.this);
            }
        });
        this.myCommitMessageArea = new CommitMessage();
        this.myCommitMessageArea.init();
        if (comment != null) {
            this.setCommitMessage(comment);
            this.myLastKnownComment = comment;
            this.myLastSelectedListName = initialSelection == null ? this.myBrowser.getSelectedChangeList().getName() : initialSelection.getName();
        } else {
            this.setCommitMessage(VcsConfiguration.getInstance((Project)project).LAST_COMMIT_MESSAGE);
            this.updateComment();
            String messageFromVcs = this.getInitialMessageFromVcs();
            if (messageFromVcs != null) {
                this.myCommitMessageArea.setText(messageFromVcs);
            }
        }
        this.myActionName = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
        this.myAdditionalOptionsPanel = new JPanel();
        this.myAdditionalOptionsPanel.setLayout(new BorderLayout());
        Box optionsBox = Box.createVerticalBox();
        boolean hasVcsOptions = false;
        Box vcsCommitOptions = Box.createVerticalBox();
        List<AbstractVcs> vcses = this.getAffectedVcses();
        this.myCheckinChangeListSpecificComponents = new HashMap<String, CheckinChangeListSpecificComponent>();
        for (AbstractVcs vcs : vcses) {
            RefreshableOnComponent options;
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (checkinEnvironment == null || (options = checkinEnvironment.createAdditionalOptionsPanel((CheckinProjectPanel)this)) == null) continue;
            JPanel vcsOptions = new JPanel(new BorderLayout());
            vcsOptions.add((Component)options.getComponent(), "Center");
            vcsOptions.add((Component)SeparatorFactory.createSeparator((String)vcs.getDisplayName(), null), "North");
            vcsCommitOptions.add(vcsOptions);
            this.myPerVcsOptionsPanels.put(vcs, vcsOptions);
            this.myAdditionalComponents.add(options);
            if (options instanceof CheckinChangeListSpecificComponent) {
                this.myCheckinChangeListSpecificComponents.put(vcs.getName(), (CheckinChangeListSpecificComponent)options);
            }
            hasVcsOptions = true;
        }
        if (hasVcsOptions) {
            vcsCommitOptions.add(Box.createVerticalGlue());
            optionsBox.add(vcsCommitOptions);
        }
        boolean beforeVisible = false;
        boolean afterVisible = false;
        Box beforeBox = Box.createVerticalBox();
        Box afterBox = Box.createVerticalBox();
        List handlerFactories = ProjectLevelVcsManager.getInstance((Project)project).getRegisteredCheckinHandlerFactories();
        for (CheckinHandlerFactory factory : handlerFactories) {
            RefreshableOnComponent afterPanel;
            CheckinHandler handler = factory.createHandler((CheckinProjectPanel)this);
            this.myHandlers.add(handler);
            RefreshableOnComponent beforePanel = handler.getBeforeCheckinConfigurationPanel();
            if (beforePanel != null) {
                beforeBox.add(beforePanel.getComponent());
                beforeVisible = true;
                this.myAdditionalComponents.add(beforePanel);
            }
            if ((afterPanel = handler.getAfterCheckinConfigurationPanel(this.getDisposable())) == null) continue;
            afterBox.add(afterPanel.getComponent());
            afterVisible = true;
            this.myAdditionalComponents.add(afterPanel);
        }
        String actionName = this.getCommitActionName();
        String borderTitleName = actionName.replace("_", "");
        if (beforeVisible) {
            beforeBox.add(Box.createVerticalGlue());
            beforeBox.add((Component)SeparatorFactory.createSeparator((String)VcsBundle.message((String)"border.standard.checkin.options.group", (Object[])new Object[]{borderTitleName}), null), 0);
            optionsBox.add(beforeBox);
        }
        if (afterVisible) {
            afterBox.add(Box.createVerticalGlue());
            afterBox.add((Component)SeparatorFactory.createSeparator((String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])new Object[]{borderTitleName}), null), 0);
            optionsBox.add(afterBox);
        }
        if (hasVcsOptions || beforeVisible || afterVisible) {
            optionsBox.add(Box.createVerticalGlue());
            this.myAdditionalOptionsPanel.add((Component)optionsBox, "North");
        }
        this.setOKButtonText(actionName);
        if (this.myShowVcsCommit) {
            this.setTitle(this.myActionName);
        } else {
            this.setTitle(CommitChangeListDialog.trimEllipsis(this.myExecutors.get(0).getActionText()));
        }
        this.restoreState();
        if (this.myExecutors != null) {
            this.myExecutorActions = new Action[this.myExecutors.size()];
            for (int i = 0; i < this.myExecutors.size(); ++i) {
                CommitExecutor commitExecutor = this.myExecutors.get(i);
                this.myExecutorActions[i] = new CommitExecutorAction(commitExecutor, i == 0 && !this.myShowVcsCommit);
            }
        } else {
            this.myExecutorActions = null;
        }
        this.myWarningLabel = new JLabel();
        this.myWarningLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.myWarningLabel.setForeground(Color.red);
        this.updateWarning();
        this.init();
        this.updateButtons();
        this.updateVcsOptionsVisibility();
        this.updateOnListSelection();
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions(EditChangelistSupport.EP_NAME, (AreaInstance)project)) {
            support.installSearch(this.myCommitMessageArea.getTextField(), this.myCommitMessageArea.getTextField());
        }
    }

    private void updateOnListSelection() {
        this.updateComment();
        this.updateVcsOptionsVisibility();
        for (CheckinChangeListSpecificComponent component : this.myCheckinChangeListSpecificComponents.values()) {
            component.onChangeListSelected((LocalChangeList)this.myBrowser.getSelectedChangeList());
        }
    }

    private void updateWarning() {
        if (this.myWarningLabel != null) {
            String[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)this.myProject)).getUpdateException();
            if (updateException != null && ((messages = updateException.getMessages()) != null || messages.length > 0)) {
                String message = messages[0];
                this.myWarningLabel.setText("Warning: not all local changes may be shown due to an error: " + message);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    private void updateVcsOptionsVisibility() {
        List<AbstractVcs> affectedVcses = CommitChangeListDialog.getAffectedVcses(this.myProject, this.myBrowser.getSelectedChangeList().getChanges());
        for (Map.Entry<AbstractVcs, JPanel> entry : this.myPerVcsOptionsPanels.entrySet()) {
            entry.getValue().setVisible(affectedVcses.contains(entry.getKey()));
        }
    }

    protected Action[] createActions() {
        Action[] result;
        int executorsSize;
        int n = executorsSize = this.myExecutors == null ? 0 : this.myExecutors.size();
        if (this.myShowVcsCommit) {
            result = new Action[2 + executorsSize];
            result[0] = this.getOKAction();
            if (this.myExecutors != null) {
                System.arraycopy(this.myExecutorActions, 0, result, 1, this.myExecutorActions.length);
            }
        } else {
            result = new Action[1 + executorsSize];
            if (this.myExecutors != null) {
                System.arraycopy(this.myExecutorActions, 0, result, 0, this.myExecutorActions.length);
            }
        }
        result[result.length - 1] = this.getCancelAction();
        return result;
    }

    private void execute(final CommitExecutor commitExecutor) {
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        final CommitSession session = commitExecutor.createCommitSession();
        if (session == CommitSession.VCS_COMMIT) {
            this.doOKAction();
            return;
        }
        boolean isOK = true;
        if (SessionDialog.createConfigurationUI(session, this.getIncludedChanges(), this.getCommitMessage()) != null) {
            SessionDialog sessionDialog = new SessionDialog(commitExecutor.getActionText(), this.getProject(), session, this.getIncludedChanges(), this.getCommitMessage());
            sessionDialog.show();
            isOK = sessionDialog.isOK();
        }
        if (isOK) {
            final DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
            this.runBeforeCommitHandlers(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                            @Override
                            public void run() {
                                session.execute((Collection)CommitChangeListDialog.this.getIncludedChanges(), CommitChangeListDialog.this.getCommitMessage());
                            }
                        }, commitExecutor.getActionText(), true, CommitChangeListDialog.this.getProject());
                        if (completed) {
                            for (CheckinHandler handler : CommitChangeListDialog.this.myHandlers) {
                                handler.checkinSuccessful();
                            }
                            defaultListCleaner.clean();
                            CommitChangeListDialog.this.close(0);
                        } else {
                            session.executionCanceled();
                        }
                    }
                    catch (Throwable e) {
                        Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])new Object[]{commitExecutor.getActionText(), e.getLocalizedMessage()}), (String)commitExecutor.getActionText());
                        for (CheckinHandler handler : CommitChangeListDialog.this.myHandlers) {
                            handler.checkinFailed(Arrays.asList(new VcsException(e)));
                        }
                    }
                }
            }, commitExecutor);
        } else {
            session.executionCanceled();
        }
    }

    @Nullable
    private String getInitialMessageFromVcs() {
        List<Change> list = this.getIncludedChanges();
        final Ref result = new Ref();
        ChangesUtil.processChangesByVcs((Project)this.myProject, list, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(){

            public void process(AbstractVcs vcs, List<Change> items) {
                List paths;
                String defaultMessage;
                CheckinEnvironment checkinEnvironment;
                if (result.isNull() && (checkinEnvironment = vcs.getCheckinEnvironment()) != null && (defaultMessage = checkinEnvironment.getDefaultMessageFor((paths = ChangesUtil.getPaths(items)).toArray(new FilePath[paths.size()]))) != null) {
                    result.set((Object)defaultMessage);
                }
            }
        });
        return (String)result.get();
    }

    private void saveCommentIntoChangeList() {
        if (this.myLastSelectedListName != null) {
            String actualCommentText = this.myCommitMessageArea.getComment();
            String saved = this.myListComments.get(this.myLastSelectedListName);
            if (!Comparing.equal((String)saved, (String)actualCommentText)) {
                this.myListComments.put(this.myLastSelectedListName, actualCommentText);
            }
        }
    }

    private boolean isDefaultList(LocalChangeList list) {
        return VcsBundle.message((String)"changes.default.changlist.name", (Object[])new Object[0]).equals(list.getName());
    }

    private void updateComment() {
        LocalChangeList list = (LocalChangeList)this.myBrowser.getSelectedChangeList();
        if (list == null || list.getName().equals(this.myLastSelectedListName)) {
            return;
        }
        if (this.myLastSelectedListName != null) {
            this.saveCommentIntoChangeList();
        }
        this.myLastSelectedListName = list.getName();
        String listComment = list.getComment();
        if (StringUtil.isEmptyOrSpaces((String)listComment)) {
            String listTitle = list.getName();
            listComment = !this.isDefaultList(list) ? listTitle : this.myLastKnownComment;
        }
        this.myCommitMessageArea.setText(listComment);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myBrowser.dispose();
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.myOKButtonUpdateAlarm);
        this.myUpdateButtonsRunnable.cancel();
        super.dispose();
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, String.valueOf(this.mySplitter.getProportion()));
    }

    public String getCommitActionName() {
        String name = null;
        for (AbstractVcs vcs : this.getAffectedVcses()) {
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (name == null && checkinEnvironment != null) {
                name = checkinEnvironment.getCheckinOperationName();
                continue;
            }
            name = VcsBundle.message((String)"commit.dialog.default.commit.operation.name", (Object[])new Object[0]);
        }
        return name != null ? name : VcsBundle.message((String)"commit.dialog.default.commit.operation.name", (Object[])new Object[0]);
    }

    private boolean checkComment() {
        if (VcsConfiguration.getInstance((Project)this.myProject).FORCE_NON_EMPTY_COMMENT && this.getCommitMessage().length() == 0) {
            int requestForCheckin = Messages.showYesNoDialog((String)VcsBundle.message((String)"confirmation.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"confirmation.title.check.in.with.empty.comment", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return requestForCheckin == 0;
        }
        return true;
    }

    private void stopUpdate() {
        this.myDisposed = true;
        this.myUpdateButtonsRunnable.cancel();
    }

    private void restartUpdate() {
        this.myDisposed = false;
        this.myUpdateButtonsRunnable.restart(this);
    }

    private void runBeforeCommitHandlers(final Runnable okAction, final CommitExecutor executor) {
        Runnable proceedRunnable = new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                for (CheckinHandler handler : CommitChangeListDialog.this.myHandlers) {
                    CheckinHandler.ReturnResult result = handler.beforeCheckin(executor);
                    if (result == CheckinHandler.ReturnResult.COMMIT) continue;
                    if (result == CheckinHandler.ReturnResult.CANCEL) {
                        CommitChangeListDialog.this.restartUpdate();
                        return;
                    }
                    if (result != CheckinHandler.ReturnResult.CLOSE_WINDOW) continue;
                    ChangeList changeList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
                    CommitHelper.moveToFailedList(changeList, CommitChangeListDialog.this.getCommitMessage(), CommitChangeListDialog.this.getIncludedChanges(), VcsBundle.message((String)"commit.dialog.rejected.commit.template", (Object[])new Object[]{changeList.getName()}), CommitChangeListDialog.this.myProject);
                    CommitChangeListDialog.this.doCancelAction();
                    return;
                }
                okAction.run();
            }
        };
        this.stopUpdate();
        for (CheckinHandler handler : this.myHandlers) {
            if (!(handler instanceof CheckinMetaHandler)) continue;
            ((CheckinMetaHandler)handler).runCheckinHandlers(proceedRunnable);
            return;
        }
        proceedRunnable.run();
    }

    protected void doOKAction() {
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        final DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
        this.ensureDataIsActual(new Runnable(){

            @Override
            public void run() {
                try {
                    CommitChangeListDialog.this.runBeforeCommitHandlers(new Runnable(){

                        @Override
                        public void run() {
                            CommitChangeListDialog.super.doOKAction();
                            CommitChangeListDialog.this.doCommit();
                        }
                    }, null);
                    defaultListCleaner.clean();
                }
                catch (InputException ex) {
                    ex.show();
                }
            }
        });
    }

    private boolean saveDialogState() {
        if (!this.checkComment()) {
            return false;
        }
        this.saveCommentIntoChangeList();
        VcsConfiguration.getInstance((Project)this.myProject).saveCommitMessage(this.getCommitMessage());
        try {
            this.saveState();
        }
        catch (InputException ex) {
            ex.show();
            return false;
        }
        return true;
    }

    private void saveComments(boolean isOk) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        if (isOk) {
            int selectedSize = this.getIncludedChanges().size();
            ChangeList selectedList = this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            if (totalSize > selectedSize) {
                this.myListComments.remove(this.myLastSelectedListName);
            }
        }
        for (Map.Entry<String, String> entry : this.myListComments.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            clManager.editComment(name, value);
        }
    }

    public void doCancelAction() {
        for (CheckinChangeListSpecificComponent component : this.myCheckinChangeListSpecificComponents.values()) {
            component.saveState();
        }
        this.saveCommentIntoChangeList();
        this.saveComments(false);
        super.doCancelAction();
    }

    private Map<String, Object> getAdditionalDataForSubmit() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, CheckinChangeListSpecificComponent> entry : this.myCheckinChangeListSpecificComponents.entrySet()) {
            Object data = entry.getValue().getDataForCommit();
            if (data == null) continue;
            result.put(entry.getKey(), data);
        }
        return result;
    }

    private void doCommit() {
        CommitHelper helper = new CommitHelper(this.myProject, this.myBrowser.getSelectedChangeList(), this.getIncludedChanges(), this.myActionName, this.getCommitMessage(), this.myHandlers, this.myAllOfDefaultChangeListChangesIncluded, false, this.getAdditionalDataForSubmit());
        if (this.myIsAlien) {
            helper.doAlienCommit(this.myVcs);
        } else {
            helper.doCommit();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel rootPane = new JPanel(new BorderLayout());
        this.mySplitter = new Splitter(true);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)this.myBrowser);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.mySplitter.setProportion(CommitChangeListDialog.calcSplitterProportion());
        this.mySplitter.setDividerWidth(3);
        rootPane.add((Component)this.mySplitter, "Center");
        JPanel browserHeader = this.myBrowser.getHeaderPanel();
        this.myBrowser.remove(browserHeader);
        rootPane.add((Component)browserHeader, "North");
        JPanel infoPanel = new JPanel(new BorderLayout());
        this.myChangesInfoCalculator = new CommitLegendPanel.ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        infoPanel.add((Component)this.myLegend.getComponent(), "North");
        infoPanel.add((Component)this.myAdditionalOptionsPanel, "Center");
        rootPane.add((Component)infoPanel, "East");
        infoPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)0));
        rootPane.add((Component)this.myWarningLabel, "South");
        return rootPane;
    }

    private static float calcSplitterProportion() {
        try {
            String s = PropertiesComponent.getInstance().getValue(SPLITTER_PROPORTION_OPTION);
            return s != null ? Float.valueOf(s).floatValue() : 0.5f;
        }
        catch (NumberFormatException e) {
            return 0.5f;
        }
    }

    public List<AbstractVcs> getAffectedVcses() {
        if (!this.myShowVcsCommit) {
            return Collections.emptyList();
        }
        return this.myBrowserExtender.getAffectedVcses();
    }

    private static List<AbstractVcs> getAffectedVcses(Project project, Collection<Change> changes) {
        HashSet<AbstractVcs> result = new HashSet<AbstractVcs>();
        for (Change change : changes) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project);
            if (vcs == null) continue;
            result.add(vcs);
        }
        return new ArrayList<AbstractVcs>(result);
    }

    public Collection<VirtualFile> getRoots() {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (Change change : this.myBrowser.getCurrentDisplayedChanges()) {
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            VirtualFile root = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootFor(filePath);
            if (root == null) continue;
            result.add(root);
        }
        return result;
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty();
    }

    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Change change : this.getIncludedChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            VirtualFile vFile = path.getVirtualFile();
            if (vFile == null) continue;
            result.add(vFile);
        }
        return result;
    }

    public Collection<Change> getSelectedChanges() {
        return new ArrayList<Change>(this.getIncludedChanges());
    }

    public Collection<File> getFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (Change change : this.getIncludedChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            File file = path.getIOFile();
            result.add(file);
        }
        return result;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setCommitMessage(String currentDescription) {
        this.setCommitMessageText(currentDescription);
        this.myCommitMessageArea.requestFocusInMessage();
    }

    public Object getContextInfo(Object object) {
        return null;
    }

    public void setWarning(String s) {
    }

    private void setCommitMessageText(String currentDescription) {
        this.myLastKnownComment = currentDescription;
        this.myCommitMessageArea.setText(currentDescription);
    }

    public String getCommitMessage() {
        return this.myCommitMessageArea.getComment();
    }

    public void refresh() {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                CommitChangeListDialog.this.myBrowser.rebuildList();
                for (RefreshableOnComponent component : CommitChangeListDialog.this.myAdditionalComponents) {
                    component.refresh();
                }
            }
        }, InvokeAfterUpdateMode.SILENT, "commit dialog", ModalityState.current());
    }

    public void saveState() {
        for (RefreshableOnComponent component : this.myAdditionalComponents) {
            component.saveState();
        }
    }

    public void restoreState() {
        for (RefreshableOnComponent component : this.myAdditionalComponents) {
            component.restoreState();
        }
    }

    private void updateButtons() {
        if (this.myDisposed) {
            return;
        }
        this.setOKActionEnabled(this.hasDiffs());
        if (this.myExecutorActions != null) {
            for (Action executorAction : this.myExecutorActions) {
                executorAction.setEnabled(this.hasDiffs());
            }
        }
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest((Runnable)this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent((Component)this.myBrowser));
    }

    private void updateLegend() {
        if (this.myDisposed) {
            return;
        }
        this.myChangesInfoCalculator.update(this.myBrowser.getCurrentDisplayedChanges(), this.myBrowserExtender.getCurrentIncludedChanges());
        this.myLegend.update();
    }

    @NotNull
    private List<Change> getIncludedChanges() {
        List<Change> list = this.myBrowserExtender.getCurrentIncludedChanges();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog.getIncludedChanges must not return null");
        }
        return list;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "CommitChangelistDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getTextField();
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key == CheckinProjectPanel.PANEL_KEY) {
            sink.put(CheckinProjectPanel.PANEL_KEY, (Object)this);
        } else {
            this.myBrowser.calcData(key, sink);
        }
    }

    static String trimEllipsis(String title) {
        if (title.endsWith("...")) {
            return title.substring(0, title.length() - 3);
        }
        return title;
    }

    private void ensureDataIsActual(Runnable runnable) {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(runnable, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing changelists...", ModalityState.current());
    }

    private static class DiffCommitMessageEditor
    extends JPanel
    implements Disposable {
        private CommitChangeListDialog myCommitDialog;
        private final JTextArea myArea = new JTextArea();

        public DiffCommitMessageEditor(CommitChangeListDialog dialog) {
            super(new BorderLayout());
            this.myArea.setText(dialog.getCommitMessage());
            this.myArea.setLineWrap(true);
            this.myArea.setWrapStyleWord(true);
            JScrollPane scrollPane = new JScrollPane(this.myArea);
            this.setBorder(IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"diff.commit.message.title", (Object[])new Object[0])));
            this.add((Component)scrollPane, "Center");
            this.myCommitDialog = dialog;
        }

        public void dispose() {
            if (this.myCommitDialog != null) {
                this.myCommitDialog.setCommitMessageText(this.myArea.getText());
                this.myCommitDialog = null;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 120);
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        private final CommitExecutor myCommitExecutor;

        public CommitExecutorAction(CommitExecutor commitExecutor, boolean isDefault) {
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
            if (isDefault) {
                this.putValue("DefaultAction", Boolean.TRUE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommitChangeListDialog.this.ensureDataIsActual(new Runnable(){

                @Override
                public void run() {
                    CommitChangeListDialog.this.execute(CommitExecutorAction.this.myCommitExecutor);
                }
            });
        }
    }

    private class DefaultListCleaner {
        private final boolean myToClean;

        private DefaultListCleaner() {
            int selectedSize = CommitChangeListDialog.this.getIncludedChanges().size();
            ChangeList selectedList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            this.myToClean = totalSize == selectedSize && CommitChangeListDialog.this.isDefaultList((LocalChangeList)selectedList);
        }

        void clean() {
            if (this.myToClean) {
                ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitChangeListDialog.this.myProject);
                clManager.editComment(CommitChangeListDialog.this.myLastSelectedListName, "");
            }
        }
    }

    private static class MyUpdateButtonsRunnable
    implements Runnable {
        private CommitChangeListDialog myDialog;

        private MyUpdateButtonsRunnable(CommitChangeListDialog dialog) {
            this.myDialog = dialog;
        }

        public void cancel() {
            this.myDialog = null;
        }

        @Override
        public void run() {
            if (this.myDialog != null) {
                this.myDialog.updateButtons();
                this.myDialog.updateLegend();
            }
        }

        public void restart(CommitChangeListDialog dialog) {
            this.myDialog = dialog;
            this.run();
        }
    }
}

