/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeCopyProvider;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends Tree
implements TypeSafeDataProvider,
AdvancedDnDSource {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ui.ChangesListView");
    private DropTarget myDropTarget;
    private DnDManager myDndManager;
    private ChangeListOwner myDragOwner;
    private final Project myProject;
    private TreeState myTreeState;
    private boolean myShowFlatten = false;
    private final CopyProvider myCopyProvider;
    @NonNls
    public static final String HELP_ID_KEY = "helpId";
    @NonNls
    public static final String ourHelpId = "ideaInterface.changes";
    @NonNls
    public static final DataKey<List<VirtualFile>> UNVERSIONED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<String> HELP_ID_DATA_KEY = DataKey.create((String)"helpId");
    private ActionGroup myMenuGroup;

    public ChangesListView(Project project) {
        this.myProject = project;
        this.getModel().setRoot(ChangesBrowserNode.create(this.myProject, "root"));
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        new TreeSpeedSearch(this, (Convertor<TreePath, String>)new NodeToTextConvertor());
        SmartExpander.installOn((JTree)((Object)this));
        this.myCopyProvider = new TreeCopyProvider((JTree)((Object)this));
        new TreeLinkMouseListener(new ChangesBrowserNodeRenderer(this.myProject, false, false)).install((JComponent)((Object)this));
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void installDndSupport(ChangeListOwner owner) {
        this.myDragOwner = owner;
        this.myDropTarget = new DropTarget();
        this.myDndManager = DnDManager.getInstance();
        this.myDndManager.registerSource((AdvancedDnDSource)this);
        this.myDndManager.registerTarget((DnDTarget)this.myDropTarget, (JComponent)((Object)this));
    }

    public void dispose() {
        if (this.myDropTarget != null) {
            this.myDndManager.unregisterSource((AdvancedDnDSource)this);
            this.myDndManager.unregisterTarget((DnDTarget)this.myDropTarget, (JComponent)((Object)this));
            this.myDropTarget = null;
            this.myDndManager = null;
            this.myDragOwner = null;
        }
    }

    private void storeState() {
        this.myTreeState = TreeState.createOn((JTree)((Object)this), (DefaultMutableTreeNode)((ChangesBrowserNode)this.getModel().getRoot()));
    }

    private void restoreState() {
        this.myTreeState.applyTo((JTree)((Object)this), (DefaultMutableTreeNode)((ChangesBrowserNode)this.getModel().getRoot()));
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void setShowFlatten(boolean showFlatten) {
        this.myShowFlatten = showFlatten;
    }

    public void updateModel(List<? extends ChangeList> changeLists, Trinity<List<VirtualFile>, Integer, Integer> unversionedFiles, List<LocallyDeletedChange> locallyDeletedFiles, List<VirtualFile> modifiedWithoutEditing, MultiMap<String, VirtualFile> switchedFiles, @Nullable Map<VirtualFile, String> switchedRoots, @Nullable List<VirtualFile> ignoredFiles, List<VirtualFile> lockedFolders, @Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        this.storeState();
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.isShowFlatten());
        DefaultTreeModel model = builder.buildModel(changeLists, unversionedFiles, locallyDeletedFiles, modifiedWithoutEditing, switchedFiles, switchedRoots, ignoredFiles, lockedFolders, logicallyLockedFiles);
        this.setModel(model);
        this.setCellRenderer((TreeCellRenderer)((Object)new ChangesBrowserNodeRenderer(this.myProject, this.isShowFlatten(), true)));
        this.expandPath(new TreePath(((ChangesBrowserNode)model.getRoot()).getPath()));
        this.restoreState();
    }

    public void calcData(DataKey key, DataSink sink) {
        ChangesBrowserNode firstNode;
        TreePath selectionPath;
        if (key == VcsDataKeys.CHANGES) {
            sink.put(VcsDataKeys.CHANGES, (Object)this.getSelectedChanges());
        } else if (key == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)this.getLeadSelection());
        } else if (key == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, (Object)this.getSelectedChangeLists());
        } else if (key == PlatformDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(PlatformDataKeys.VIRTUAL_FILE_ARRAY, (Object)this.getSelectedFiles());
        } else if (key == PlatformDataKeys.NAVIGATABLE) {
            VirtualFile[] files = this.getSelectedFiles();
            if (files.length == 1 && !files[0].isDirectory()) {
                sink.put(PlatformDataKeys.NAVIGATABLE, (Object)new OpenFileDescriptor(this.myProject, files[0], 0));
            }
        } else if (key == PlatformDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(PlatformDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, (VirtualFile[])this.getSelectedFiles()));
        } else if (key == PlatformDataKeys.DELETE_ELEMENT_PROVIDER) {
            TreePath[] paths = this.getSelectionPaths();
            if (paths != null) {
                for (TreePath path : paths) {
                    ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof ChangeList) continue;
                    sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new VirtualFileDeleteProvider());
                    break;
                }
            }
        } else if (key == PlatformDataKeys.COPY_PROVIDER) {
            sink.put(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
        } else if (key == UNVERSIONED_FILES_DATA_KEY) {
            sink.put(UNVERSIONED_FILES_DATA_KEY, this.getSelectedUnversionedFiles());
        } else if (key == VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY) {
            sink.put(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY, this.getSelectedModifiedWithoutEditing());
        } else if (key == MISSING_FILES_DATA_KEY) {
            sink.put(MISSING_FILES_DATA_KEY, this.getSelectedMissingFiles());
        } else if (key == HELP_ID_DATA_KEY) {
            sink.put(HELP_ID_DATA_KEY, (Object)ourHelpId);
        } else if (key == VcsDataKeys.CHANGES_IN_LIST_KEY && (selectionPath = this.getSelectionPath()) != null && selectionPath.getPathCount() > 1 && (firstNode = (ChangesBrowserNode)selectionPath.getPathComponent(1)) instanceof ChangesBrowserChangeListNode) {
            List<Change> list = firstNode.getAllChangesUnder();
            sink.put(VcsDataKeys.CHANGES_IN_LIST_KEY, list);
        }
    }

    private List<VirtualFile> getSelectedUnversionedFiles() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    private List<VirtualFile> getSelectedModifiedWithoutEditing() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    private List<VirtualFile> getSelectedIgnoredFiles() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.IGNORED_FILES_TAG);
    }

    private List<VirtualFile> getSelectedVirtualFiles(Object tag) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path.getPathCount() <= 1) continue;
                ChangesBrowserNode firstNode = (ChangesBrowserNode)path.getPathComponent(1);
                if (tag != null && firstNode.getUserObject() != tag) continue;
                ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
                files.addAll(node.getAllFilesUnder());
            }
        }
        return new ArrayList<VirtualFile>(files);
    }

    private List<FilePath> getSelectedMissingFiles() {
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
                files.addAll(node.getAllFilePathsUnder());
            }
        }
        return files;
    }

    protected VirtualFile[] getSelectedFiles() {
        Change[] changes = this.getSelectedChanges();
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (Change change : changes) {
            VirtualFile file;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || (file = afterRevision.getFile().getVirtualFile()) == null || !file.isValid()) continue;
            files.add(file);
        }
        files.addAll(this.getSelectedVirtualFiles(null));
        return VfsUtil.toVirtualFileArray(files);
    }

    private Change[] getLeadSelection() {
        LinkedHashSet changes = new LinkedHashSet();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return new Change[0];
        }
        for (TreePath path : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
            if (!(node instanceof ChangesBrowserChangeNode)) continue;
            changes.add(((ChangesBrowserChangeNode)node).getUserObject());
        }
        return changes.toArray(new Change[changes.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Change[] getSelectedChanges() {
        List<VirtualFile> selectedModifiedWithoutEditing;
        Change[] changeArray;
        LinkedHashSet<Change> changes = new LinkedHashSet<Change>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            changeArray = new Change[]{};
            if (changeArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesListView.getSelectedChanges must not return null");
            return changeArray;
        }
        for (TreePath path : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
            changes.addAll(node.getAllChangesUnder());
        }
        if (changes.size() == 0 && (selectedModifiedWithoutEditing = this.getSelectedModifiedWithoutEditing()) != null && selectedModifiedWithoutEditing.size() > 0) {
            for (VirtualFile file : selectedModifiedWithoutEditing) {
                AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
                DiffProvider diffProvider = vcs == null ? null : vcs.getDiffProvider();
                if (diffProvider == null) continue;
                VcsCurrentRevisionProxy beforeRevision = new VcsCurrentRevisionProxy(diffProvider, file);
                CurrentContentRevision afterRevision = new CurrentContentRevision((FilePath)new FilePathImpl(file));
                changes.add(new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision, FileStatus.HIJACKED));
            }
        }
        if ((changeArray = changes.toArray(new Change[changes.size()])) != null) return changeArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesListView.getSelectedChanges must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ChangeList[] getSelectedChangeLists() {
        ChangeList[] changeListArray;
        HashSet<ChangeList> lists = new HashSet<ChangeList>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            changeListArray = new ChangeList[]{};
            if (changeListArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesListView.getSelectedChangeLists must not return null");
            return changeListArray;
        }
        for (TreePath path : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof ChangeList)) continue;
            lists.add((ChangeList)userObject);
        }
        changeListArray = lists.toArray(new ChangeList[lists.size()]);
        if (changeListArray != null) return changeListArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesListView.getSelectedChangeLists must not return null");
    }

    public void setMenuActions(ActionGroup menuGroup) {
        this.myMenuGroup = menuGroup;
        this.updateMenu();
        this.editSourceRegistration();
    }

    protected void editSourceRegistration() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
    }

    private void updateMenu() {
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)this.myMenuGroup, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
    }

    public void updateUI() {
        super.updateUI();
        if (this.myMenuGroup != null) {
            this.updateMenu();
        }
    }

    private boolean fitsInBounds(Rectangle rect) {
        Container scrollPane;
        Container container = this.getParent();
        if (container instanceof JViewport && (scrollPane = container.getParent()) instanceof JScrollPane) {
            Rectangle rectangle = SwingUtilities.convertRectangle((Component)((Object)this), rect, scrollPane.getParent());
            return scrollPane.getBounds().contains(rectangle);
        }
        return true;
    }

    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
        return action == DnDAction.MOVE && (this.getSelectedChanges().length > 0 || this.getSelectedUnversionedFiles().size() > 0 || this.getSelectedIgnoredFiles().size() > 0);
    }

    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
        return new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)((Object)this), this.getSelectedChanges(), this.getSelectedUnversionedFiles(), this.getSelectedIgnoredFiles()));
    }

    @Nullable
    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
        Image image = DragImageFactory.createImage((JTree)((Object)this));
        return new Pair((Object)image, (Object)new Point(-image.getWidth(null), -image.getHeight(null)));
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int gestureModifiers) {
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ui/ChangesListView.getComponent must not return null");
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path != null) {
                this.setSelectionPath(path);
                e.consume();
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    private static class NodeToTextConvertor
    implements Convertor<TreePath, String> {
        private NodeToTextConvertor() {
        }

        public String convert(TreePath path) {
            ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
            return node.getTextPresentation();
        }
    }

    public class DropTarget
    implements DnDTarget {
        public boolean update(DnDEvent aEvent) {
            aEvent.hideHighlighter();
            aEvent.setDropPossible(false, "");
            Object attached = aEvent.getAttachedObject();
            if (!(attached instanceof ChangeListDragBean)) {
                return false;
            }
            ChangeListDragBean dragBean = (ChangeListDragBean)attached;
            if (dragBean.getSourceComponent() != ChangesListView.this) {
                return false;
            }
            dragBean.setTargetNode(null);
            RelativePoint dropPoint = aEvent.getRelativePoint();
            Point onTree = dropPoint.getPoint((Component)((Object)ChangesListView.this));
            TreePath dropPath = ChangesListView.this.getPathForLocation(onTree.x, onTree.y);
            if (dropPath == null) {
                return false;
            }
            ChangesBrowserNode dropNode = (ChangesBrowserNode)dropPath.getLastPathComponent();
            while (!((ChangesBrowserNode)dropNode.getParent()).isRoot()) {
                dropNode = (ChangesBrowserNode)dropNode.getParent();
            }
            if (!dropNode.canAcceptDrop(dragBean)) {
                return false;
            }
            Rectangle tableCellRect = ChangesListView.this.getPathBounds(new TreePath(dropNode.getPath()));
            if (ChangesListView.this.fitsInBounds(tableCellRect)) {
                aEvent.setHighlighting(new RelativeRectangle((Component)((Object)ChangesListView.this), tableCellRect), 1);
            }
            aEvent.setDropPossible(true, null);
            dragBean.setTargetNode(dropNode);
            return false;
        }

        public void drop(DnDEvent aEvent) {
            Object attached = aEvent.getAttachedObject();
            if (!(attached instanceof ChangeListDragBean)) {
                return;
            }
            ChangeListDragBean dragBean = (ChangeListDragBean)attached;
            ChangesBrowserNode changesBrowserNode = dragBean.getTargetNode();
            if (changesBrowserNode != null) {
                changesBrowserNode.acceptDrop(ChangesListView.this.myDragOwner, dragBean);
            }
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }

    private static class DragImageFactory {
        private DragImageFactory() {
        }

        private static void drawSelection(JTable table, int column, Graphics g, int width) {
            int y = 0;
            int[] rows = table.getSelectedRows();
            int height = table.getRowHeight();
            for (int row : rows) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component component = renderer.getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column);
                g.translate(0, y);
                component.setBounds(0, 0, width, height);
                boolean wasOpaque = false;
                if (component instanceof JComponent) {
                    JComponent j = (JComponent)component;
                    if (j.isOpaque()) {
                        wasOpaque = true;
                    }
                    j.setOpaque(false);
                }
                component.paint(g);
                if (wasOpaque) {
                    ((JComponent)component).setOpaque(true);
                }
                g.translate(0, -(y += height));
            }
        }

        private static void drawSelection(JTree tree, Graphics g, int width) {
            int y = 0;
            int[] rows = tree.getSelectionRows();
            int height = tree.getRowHeight();
            for (int row : rows) {
                TreeCellRenderer renderer = tree.getCellRenderer();
                Object value = tree.getPathForRow(row).getLastPathComponent();
                if (value == null) continue;
                Component component = renderer.getTreeCellRendererComponent(tree, value, false, false, false, row, false);
                if (component.getFont() == null) {
                    component.setFont(tree.getFont());
                }
                g.translate(0, y);
                component.setBounds(0, 0, width, height);
                boolean wasOpaque = false;
                if (component instanceof JComponent) {
                    JComponent j = (JComponent)component;
                    if (j.isOpaque()) {
                        wasOpaque = true;
                    }
                    j.setOpaque(false);
                }
                component.paint(g);
                if (wasOpaque) {
                    ((JComponent)component).setOpaque(true);
                }
                g.translate(0, -(y += height));
            }
        }

        public static Image createImage(JTable table, int column) {
            int height = Math.max(20, Math.min(100, table.getSelectedRowCount() * table.getRowHeight()));
            int width = table.getColumnModel().getColumn(column).getWidth();
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            DragImageFactory.drawSelection(table, column, g2, width);
            return image;
        }

        public static Image createImage(JTree tree) {
            TreeSelectionModel model = tree.getSelectionModel();
            TreePath[] paths = model.getSelectionPaths();
            int count = 0;
            ArrayList<ChangesBrowserNode> nodes = new ArrayList<ChangesBrowserNode>();
            for (TreePath path : paths) {
                ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
                if (node.isLeaf()) continue;
                nodes.add(node);
                count += node.getCount();
            }
            for (TreePath path : paths) {
                ChangesBrowserNode element = (ChangesBrowserNode)path.getLastPathComponent();
                boolean child = false;
                for (ChangesBrowserNode node : nodes) {
                    if (!node.isNodeChild(element)) continue;
                    child = true;
                    break;
                }
                if (!child) {
                    if (!element.isLeaf()) continue;
                    ++count;
                    continue;
                }
                if (element.isLeaf()) continue;
                count -= element.getCount();
            }
            JLabel label = new JLabel(VcsBundle.message((String)"changes.view.dnd.label", (Object[])new Object[]{count}));
            label.setOpaque(true);
            label.setForeground(tree.getForeground());
            label.setBackground(tree.getBackground());
            label.setFont(tree.getFont());
            label.setSize(label.getPreferredSize());
            BufferedImage image = new BufferedImage(label.getWidth(), label.getHeight(), 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            label.paint(g2);
            g2.dispose();
            return image;
        }
    }
}

