/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.pending;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.MockAbstractVcs;
import com.intellij.openapi.vcs.changes.committed.MockDelayingChangeProvider;
import com.intellij.openapi.vcs.changes.pending.TimeoutWaiter;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;

public class DuringChangeListManagerUpdateTestScheme {
    private final MockDelayingChangeProvider myChangeProvider;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final ChangeListManager myClManager;

    public DuringChangeListManagerUpdateTestScheme(Project project, String tmpDirPath) {
        MockAbstractVcs vcs = new MockAbstractVcs(project);
        this.myChangeProvider = new MockDelayingChangeProvider();
        vcs.setChangeProvider(this.myChangeProvider);
        File mockVcsRoot = new File(tmpDirPath, "mock");
        mockVcsRoot.mkdir();
        ProjectLevelVcsManagerImpl projectLevelVcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project);
        projectLevelVcsManager.registerVcs(vcs);
        projectLevelVcsManager.setDirectoryMapping(mockVcsRoot.getAbsolutePath(), vcs.getName());
        AbstractVcs vcsFound = projectLevelVcsManager.findVcsByName(vcs.getName());
        assert (projectLevelVcsManager.getRootsUnderVcs(vcsFound).length == 1) : "size: " + projectLevelVcsManager.getRootsUnderVcs(vcsFound).length;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        this.myClManager = ChangeListManager.getInstance((Project)project);
    }

    public void doTest(Runnable runnable) {
        TimeoutWaiter waiter = new TimeoutWaiter();
        DuringUpdateTest test = new DuringUpdateTest(waiter, runnable);
        this.myChangeProvider.setTest(test);
        waiter.setControlled(test);
        System.out.println("Starting delayed update..");
        this.myDirtyScopeManager.markEverythingDirty();
        this.myClManager.ensureUpToDate(false);
        System.out.println("Starting timeout..");
        waiter.startTimeout();
        System.out.println("Timeout waiter completed.");
        if (test.getException() != null) {
            test.getException().printStackTrace();
        }
        assert (test.get().booleanValue()) : test.getException() == null ? null : test.getException().getMessage();
    }

    public static void checkFilesAreInList(VirtualFile[] files, String listName, ChangeListManager manager) {
        System.out.println("Checking files for list: " + listName);
        assert (manager.findChangeList(listName) != null);
        LocalChangeList list = manager.findChangeList(listName);
        Collection changes = list.getChanges();
        assert (changes.size() == files.length) : "size: " + changes.size() + " " + DuringChangeListManagerUpdateTestScheme.debugRealListContent(list);
        for (Change change : changes) {
            VirtualFile vf = change.getAfterRevision().getFile().getVirtualFile();
            boolean found = false;
            for (VirtualFile file : files) {
                if (!file.equals(vf)) continue;
                found = true;
                break;
            }
            assert (found) : DuringChangeListManagerUpdateTestScheme.debugRealListContent(list);
        }
    }

    public static void checkDeletedFilesAreInList(VirtualFile[] files, String listName, ChangeListManager manager) {
        System.out.println("Checking files for list: " + listName);
        assert (manager.findChangeList(listName) != null);
        LocalChangeList list = manager.findChangeList(listName);
        Collection changes = list.getChanges();
        assert (changes.size() == files.length) : DuringChangeListManagerUpdateTestScheme.debugRealListContent(list);
        for (Change change : changes) {
            File vf = change.getBeforeRevision().getFile().getIOFile();
            boolean found = false;
            for (VirtualFile vfile : files) {
                File file = new File(vfile.getPath());
                if (!file.equals(vf)) continue;
                found = true;
                break;
            }
            assert (found) : DuringChangeListManagerUpdateTestScheme.debugRealListContent(list);
        }
    }

    private static String debugRealListContent(LocalChangeList list) {
        StringBuilder sb = new StringBuilder(list.getName() + ": ");
        Collection changeCollection = list.getChanges();
        for (Change change : changeCollection) {
            sb.append(change.toString()).append(' ');
        }
        return sb.toString();
    }

    private class DuringUpdateTest
    implements Runnable,
    Getter<Boolean> {
        private boolean myDone;
        private final TimeoutWaiter myWaiter;
        private final Runnable myRunnable;
        private Exception myException;

        protected DuringUpdateTest(TimeoutWaiter waiter, Runnable runnable) {
            this.myWaiter = waiter;
            this.myRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("DuringUpdateTest: before test execution");
            try {
                this.myRunnable.run();
            }
            catch (Exception e) {
                this.myException = e;
            }
            System.out.println("DuringUpdateTest: setting done");
            this.myDone = this.myException == null;
            DuringChangeListManagerUpdateTestScheme.this.myChangeProvider.setTest(null);
            DuringChangeListManagerUpdateTestScheme.this.myChangeProvider.unlock();
            TimeoutWaiter timeoutWaiter = this.myWaiter;
            synchronized (timeoutWaiter) {
                this.myWaiter.notifyAll();
            }
        }

        public Exception getException() {
            return this.myException;
        }

        public Boolean get() {
            return this.myDone;
        }
    }
}

