/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;

public class MergedDiffRequestPresentable
implements DiffRequestPresentable {
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myAfterTitle;
    private final ApplyPatchForBaseRevisionTexts myTexts;

    public MergedDiffRequestPresentable(Project project, ApplyPatchForBaseRevisionTexts texts, VirtualFile file, String afterTitle) {
        this.myTexts = texts;
        this.myProject = project;
        this.myFile = file;
        this.myAfterTitle = afterTitle;
    }

    @Override
    public DiffRequestPresentable.MyResult step() {
        MergeRequest request = DiffRequestFactory.getInstance().create3WayDiffRequest(((Object)this.myTexts.getLocal()).toString(), this.myTexts.getPatched(), ((Object)this.myTexts.getBase()).toString(), this.myProject, null);
        request.setWindowTitle(VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{this.myFile.getPresentableUrl()}));
        request.setVersionTitles(new String[]{"Current Version", "Base Version", this.myAfterTitle});
        return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.useRequest);
    }

    @Override
    public boolean haveStuff() {
        return true;
    }

    @Override
    public List<? extends AnAction> createActions(ShowDiffAction.DiffExtendUIFactory uiFactory) {
        return Collections.emptyList();
    }
}

