/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;

public class AddList
implements ChangeListCommand {
    private final String myName;
    private final String myComment;
    private LocalChangeList myNewListCopy;

    public AddList(String name, String comment) {
        this.myName = name;
        this.myComment = comment;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        if (!worker.findListByName(this.myName)) {
            this.myNewListCopy = worker.addChangeList(this.myName, this.myComment);
        } else {
            worker.editComment(this.myName, this.myComment);
            this.myNewListCopy = worker.getCopyByName(this.myName);
        }
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        ((ChangeListListener)dispatcher.getMulticaster()).changeListAdded((ChangeList)this.myNewListCopy);
    }

    public LocalChangeList getNewListCopy() {
        return this.myNewListCopy;
    }
}

