/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.MoveChangesDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesCommitExecutor;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;

public enum ChangelistConflictResolution {
    SHELVE{

        @Override
        public boolean resolveConflict(Project project, Collection<Change> changes) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project).getChangeList(changes.iterator().next());
            return CommitChangeListDialog.commitChanges(project, changes, changeList, new ShelveChangesCommitExecutor(project), null);
        }
    }
    ,
    MOVE{

        @Override
        public boolean resolveConflict(Project project, Collection<Change> changes) {
            ChangeListManagerImpl manager = ChangelistConflictResolution.getManager(project);
            HashSet<ChangeList> changeLists = new HashSet<ChangeList>();
            for (Change change : changes) {
                LocalChangeList list = manager.getChangeList(change);
                if (list == null) continue;
                changeLists.add((ChangeList)list);
            }
            if (changeLists.isEmpty()) {
                Messages.showInfoMessage((Project)project, (String)"The conflict seems to be resolved", (String)"No Conflict Found");
                return true;
            }
            MoveChangesDialog dialog = new MoveChangesDialog(project, changes, changeLists, "Move Changes to Active Changelist");
            dialog.show();
            if (dialog.isOK()) {
                manager.moveChangesTo(manager.getDefaultChangeList(), dialog.getIncludedChanges().toArray(new Change[changes.size()]));
                return true;
            }
            return false;
        }
    }
    ,
    SWITCH{

        @Override
        public boolean resolveConflict(Project project, Collection<Change> changes) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project).getChangeList(changes.iterator().next());
            assert (changeList != null);
            ChangelistConflictResolution.getManager(project).setDefaultChangeList(changeList);
            return true;
        }
    }
    ,
    IGNORE{

        @Override
        public boolean resolveConflict(Project project, Collection<Change> changes) {
            ChangeListManagerImpl manager = ChangelistConflictResolution.getManager(project);
            for (Change change : changes) {
                VirtualFile file = change.getVirtualFile();
                if (file == null) continue;
                manager.getConflictTracker().ignoreConflict(file, true);
            }
            return true;
        }
    };


    public abstract boolean resolveConflict(Project var1, Collection<Change> var2);

    private static ChangeListManagerImpl getManager(Project project) {
        return (ChangeListManagerImpl)ChangeListManager.getInstance((Project)project);
    }
}

