/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import java.util.Arrays;

public class RollbackDialogAction
extends AnAction
implements DumbAware {
    public RollbackDialogAction() {
        super(VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.rollback.description", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/rollback.png"));
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final ChangesBrowser browser = (ChangesBrowser)e.getData(ChangesBrowser.DATA_KEY);
        RollbackChangesDialog.rollbackChanges(project, Arrays.asList(changes), true, new Runnable(){

            @Override
            public void run() {
                if (browser != null) {
                    browser.rebuildList();
                }
            }
        });
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        e.getPresentation().setEnabled(changes != null);
    }
}

