/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDeletionAction;
import com.intellij.openapi.vcs.changes.actions.SelectedFilesHelper;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class RollbackAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        VirtualFile[] files;
        boolean isEnabled = RollbackAction.isEnabled(e);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 0);
        e.getPresentation().setEnabled(isEnabled);
        if (isEnabled && (files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            for (VirtualFile file : files) {
                RollbackEnvironment rollbackEnvironment;
                AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
                if (vcs == null || (rollbackEnvironment = vcs.getRollbackEnvironment()) == null) continue;
                e.getPresentation().setText(rollbackEnvironment.getRollbackOperationName());
            }
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            return false;
        }
        if (RollbackAction.hasChanges(project, e)) {
            return true;
        }
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (missingFiles != null && !missingFiles.isEmpty()) {
            return true;
        }
        List<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e);
        return modifiedWithoutEditing != null && !modifiedWithoutEditing.isEmpty();
    }

    private static boolean hasChanges(Project project, AnActionEvent e) {
        ChangesCheckHelper helper = new ChangesCheckHelper(project, e);
        if (helper.isChangesSet()) {
            Change[] changes = helper.getChanges();
            return changes != null && changes.length > 0;
        }
        return SelectedFilesHelper.hasChangedSelectedFiles(project, e);
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (missingFiles != null && !missingFiles.isEmpty()) {
            new RollbackDeletionAction().actionPerformed(e);
        } else {
            List<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e);
            if (modifiedWithoutEditing != null && !modifiedWithoutEditing.isEmpty()) {
                RollbackAction.rollbackModifiedWithoutEditing(project, modifiedWithoutEditing);
            } else {
                Change[] changes = RollbackAction.getChanges(project, e);
                if (changes != null) {
                    RollbackChangesDialog.rollbackChanges(project, Arrays.asList(changes));
                }
            }
        }
    }

    @Nullable
    private static Change[] getChanges(Project project, AnActionEvent e) {
        ChangesCheckHelper helper = new ChangesCheckHelper(project, e);
        if (helper.isChangesSet()) {
            return helper.getChanges();
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null && virtualFiles.length > 0) {
            ArrayList result = new ArrayList();
            for (VirtualFile file : virtualFiles) {
                result.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(file));
            }
            return result.toArray(new Change[result.size()]);
        }
        return null;
    }

    @Nullable
    private static List<VirtualFile> getModifiedWithoutEditing(AnActionEvent e) {
        List modifiedWithoutEditing = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        if (modifiedWithoutEditing != null && modifiedWithoutEditing.size() > 0) {
            return modifiedWithoutEditing;
        }
        return null;
    }

    private static void rollbackModifiedWithoutEditing(final Project project, final List<VirtualFile> modifiedWithoutEditing) {
        String message = modifiedWithoutEditing.size() == 1 ? VcsBundle.message((String)"rollback.modified.without.editing.confirm.single", (Object[])new Object[]{modifiedWithoutEditing.get(0).getPresentableUrl()}) : VcsBundle.message((String)"rollback.modified.without.editing.confirm.multiple", (Object[])new Object[]{modifiedWithoutEditing.size()});
        int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.action.rollback.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        final ArrayList exceptions = new ArrayList();
        final ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                final ProgressIndicator indicator = progressManager.getProgressIndicator();
                try {
                    ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)modifiedWithoutEditing, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<VirtualFile>(){

                        public void process(AbstractVcs vcs, List<VirtualFile> items) {
                            RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
                            if (rollbackEnvironment != null) {
                                if (indicator != null) {
                                    indicator.setText(vcs.getDisplayName() + ": performing rollback...");
                                    indicator.setIndeterminate(false);
                                }
                                rollbackEnvironment.rollbackModifiedWithoutCheckout(items, exceptions, (RollbackProgressListener)new RollbackProgressModifier(items.size(), indicator));
                                if (indicator != null) {
                                    indicator.setText2("");
                                }
                            }
                        }
                    });
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                if (!exceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"rollback.modified.without.checkout.error.tab", (Object[])new Object[0]));
                }
                VirtualFileManager.getInstance().refresh(true, new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile virtualFile : modifiedWithoutEditing) {
                            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(virtualFile);
                        }
                    }
                });
            }
        };
        progressManager.runProcessWithProgressSynchronously(action, VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]), true, project);
    }

    private static class ChangesCheckHelper {
        private Change[] myChanges;
        private boolean myChangesSet;

        public ChangesCheckHelper(Project project, AnActionEvent e) {
            VirtualFile[] files;
            Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
            if (changes == null && (files = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
                ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
                LinkedList changesList = new LinkedList();
                for (VirtualFile vf : files) {
                    changesList.addAll(clManager.getChangesIn(vf));
                }
                if (!changesList.isEmpty()) {
                    changes = changesList.toArray(new Change[changesList.size()]);
                }
            }
            boolean bl = this.myChangesSet = changes != null && changes.length > 0;
            if (this.myChangesSet && ChangesUtil.allChangesInOneList((Project)project, (Change[])changes)) {
                this.myChanges = changes;
            }
        }

        public boolean isChangesSet() {
            return this.myChangesSet;
        }

        public Change[] getChanges() {
            return this.myChanges;
        }
    }
}

