/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestPresentable
implements DiffRequestPresentable {
    private final Project myProject;
    private final Change myChange;

    public ChangeDiffRequestPresentable(Project project, Change change) {
        this.myChange = change;
        this.myProject = project;
    }

    @Override
    public DiffRequestPresentable.MyResult step() {
        SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
        return new DiffRequestPresentable.MyResult((DiffRequest)request, this.getRequestForChange(request));
    }

    @Nullable
    private DiffPresentationReturnValue getRequestForChange(SimpleDiffRequest request) {
        if (!this.canShowChange()) {
            return DiffPresentationReturnValue.removeFromList;
        }
        if (!this.loadCurrentContents(request, this.myChange)) {
            return DiffPresentationReturnValue.quit;
        }
        return DiffPresentationReturnValue.useRequest;
    }

    @Override
    public boolean haveStuff() {
        return ChangeDiffRequestPresentable.checkContentsAvailable(this.myChange.getBeforeRevision(), this.myChange.getAfterRevision());
    }

    @Override
    public List<? extends AnAction> createActions(ShowDiffAction.DiffExtendUIFactory uiFactory) {
        return uiFactory.createActions(this.myChange);
    }

    private boolean loadCurrentContents(final SimpleDiffRequest request, Change change) {
        String afterRevisionTitle;
        String afterPath;
        final ContentRevision bRev = change.getBeforeRevision();
        final ContentRevision aRev = change.getAfterRevision();
        String beforePath = bRev != null ? bRev.getFile().getPath() : null;
        String string = afterPath = aRev != null ? aRev.getFile().getPath() : null;
        String title = beforePath != null && afterPath != null && !beforePath.equals(afterPath) ? beforePath + " -> " + afterPath : (beforePath != null ? beforePath : (afterPath != null ? afterPath : VcsBundle.message((String)"diff.unknown.path.title", (Object[])new Object[0])));
        request.setWindowTitle(title);
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                request.setContents(ChangeDiffRequestPresentable.this.createContent(bRev), ChangeDiffRequestPresentable.this.createContent(aRev));
            }
        }, VcsBundle.message((String)"progress.loading.diff.revisions", (Object[])new Object[0]), true, this.myProject);
        if (!result) {
            return false;
        }
        String beforeRevisionTitle = bRev != null ? bRev.getRevisionNumber().asString() : "";
        String string2 = afterRevisionTitle = aRev != null ? aRev.getRevisionNumber().asString() : "";
        if (beforeRevisionTitle == null || beforeRevisionTitle.length() == 0) {
            beforeRevisionTitle = "Base version";
        }
        if (afterRevisionTitle == null || afterRevisionTitle.length() == 0) {
            afterRevisionTitle = "Your version";
        }
        request.setContentTitles(beforeRevisionTitle, afterRevisionTitle);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private DiffContent createContent(ContentRevision revision) {
        String revisionContent;
        Object object;
        ProgressManager.checkCanceled();
        if (revision == null) {
            object = new SimpleContent("");
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable.createContent must not return null");
            return object;
        }
        if (revision instanceof CurrentContentRevision) {
            CurrentContentRevision current = (CurrentContentRevision)revision;
            VirtualFile vFile = current.getVirtualFile();
            object = vFile != null ? new FileContent(this.myProject, vFile) : new SimpleContent("");
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable.createContent must not return null");
            return object;
        }
        try {
            revisionContent = revision.getContent();
        }
        catch (VcsException ex) {
            revisionContent = null;
        }
        SimpleContent content = revisionContent == null ? new SimpleContent("") : new SimpleContent(revisionContent, revision.getFile().getFileType());
        VirtualFile vFile = revision.getFile().getVirtualFile();
        if (vFile != null) {
            content.setCharset(vFile.getCharset());
            content.setBOM(vFile.getBOM());
        }
        content.setReadOnly(true);
        object = content;
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/actions/ChangeDiffRequestPresentable.createContent must not return null");
    }

    private boolean canShowChange() {
        ContentRevision bRev = this.myChange.getBeforeRevision();
        ContentRevision aRev = this.myChange.getAfterRevision();
        if (bRev != null && (bRev.getFile().getFileType().isBinary() || bRev.getFile().isDirectory()) || aRev != null && (aRev.getFile().getFileType().isBinary() || aRev.getFile().isDirectory())) {
            if (bRev != null && bRev.getFile().getFileType() == FileTypes.UNKNOWN && !bRev.getFile().isDirectory()) {
                if (!ChangeDiffRequestPresentable.checkContentsAvailable(bRev, aRev)) {
                    return false;
                }
                if (!ChangeDiffRequestPresentable.checkAssociate(this.myProject, bRev.getFile())) {
                    return false;
                }
            } else if (aRev != null && aRev.getFile().getFileType() == FileTypes.UNKNOWN && !aRev.getFile().isDirectory()) {
                if (!ChangeDiffRequestPresentable.checkContentsAvailable(bRev, aRev)) {
                    return false;
                }
                if (!ChangeDiffRequestPresentable.checkAssociate(this.myProject, aRev.getFile())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean checkContentsAvailable(@Nullable ContentRevision bRev, @Nullable ContentRevision aRev) {
        String bContents = null;
        if (bRev != null) {
            try {
                bContents = bRev.getContent();
            }
            catch (VcsException e) {
                // empty catch block
            }
        }
        String aContents = null;
        if (aRev != null) {
            try {
                aContents = aRev.getContent();
            }
            catch (VcsException e) {
                // empty catch block
            }
        }
        return bContents != null || aContents != null;
    }

    private static boolean checkAssociate(Project project, FilePath file) {
        int rc = Messages.showDialog((Project)project, (String)VcsBundle.message((String)"diff.unknown.file.type.prompt", (Object[])new Object[]{file.getName()}), (String)VcsBundle.message((String)"diff.unknown.file.type.title", (Object[])new Object[0]), (String[])new String[]{VcsBundle.message((String)"diff.unknown.file.type.associate", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            FileType fileType = FileTypeChooser.associateFileType(file.getName());
            return fileType != null && !fileType.isBinary();
        }
        return false;
    }
}

