/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.AppTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoListener;
import com.intellij.openapi.fileEditor.VetoDocumentReloadException;
import com.intellij.openapi.fileEditor.VetoDocumentSavingException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VetoSavingCommittingDocumentsAdapter
implements ApplicationComponent,
FileDocumentSynchronizationVetoListener {
    private static final Object SAVE_DENIED = new Object();
    private final FileDocumentManager myFileDocumentManager;

    public VetoSavingCommittingDocumentsAdapter(FileDocumentManager fileDocumentManager) {
        this.myFileDocumentManager = fileDocumentManager;
    }

    public void beforeDocumentSaving(Document document) throws VetoDocumentSavingException {
        boolean allowSave;
        Object beingCommitted = document.getUserData(ChangeListManagerImpl.DOCUMENT_BEING_COMMITTED_KEY);
        if (beingCommitted == SAVE_DENIED) {
            throw new VetoDocumentSavingException();
        }
        if (beingCommitted instanceof Project && !(allowSave = this.showAllowSaveDialog((Project)beingCommitted, Collections.singletonList(document)))) {
            throw new VetoDocumentSavingException();
        }
    }

    public void beforeFileContentReload(VirtualFile file, Document document) throws VetoDocumentReloadException {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("VetoSavingComittingDocumentsAdapter" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/VetoSavingCommittingDocumentsAdapter.getComponentName must not return null");
        }
        return "VetoSavingComittingDocumentsAdapter";
    }

    public void initComponent() {
        this.myFileDocumentManager.addFileDocumentSynchronizationVetoer((FileDocumentSynchronizationVetoListener)this);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void beforeAllDocumentsSaving() {
                ArrayList<Document> documentsToWarn = new ArrayList<Document>();
                Document[] unsavedDocuments = VetoSavingCommittingDocumentsAdapter.this.myFileDocumentManager.getUnsavedDocuments();
                Project commitOwnerProject = null;
                for (Document unsavedDocument : unsavedDocuments) {
                    Object data = unsavedDocument.getUserData(ChangeListManagerImpl.DOCUMENT_BEING_COMMITTED_KEY);
                    if (!(data instanceof Project)) continue;
                    commitOwnerProject = (Project)data;
                    documentsToWarn.add(unsavedDocument);
                }
                if (!documentsToWarn.isEmpty()) {
                    boolean allowSave = VetoSavingCommittingDocumentsAdapter.this.showAllowSaveDialog(commitOwnerProject, documentsToWarn);
                    for (Document document : documentsToWarn) {
                        document.putUserData(ChangeListManagerImpl.DOCUMENT_BEING_COMMITTED_KEY, allowSave ? null : SAVE_DENIED);
                    }
                }
            }
        });
    }

    public void disposeComponent() {
        this.myFileDocumentManager.removeFileDocumentSynchronizationVetoer((FileDocumentSynchronizationVetoListener)this);
    }

    private boolean showAllowSaveDialog(Project project, List<Document> documentsToWarn) {
        StringBuilder messageBuilder = new StringBuilder("The following " + (documentsToWarn.size() == 1 ? "file is" : "files are") + " currently being committed to the VCS. " + "Saving now could cause inconsistent data to be committed.\n");
        for (Document document : documentsToWarn) {
            VirtualFile file = this.myFileDocumentManager.getFile(document);
            messageBuilder.append(FileUtil.toSystemDependentName((String)file.getPath())).append("\n");
        }
        messageBuilder.append("Save the ").append(documentsToWarn.size() == 1 ? "file" : "files").append(" now?");
        int rc = Messages.showDialog((Project)project, (String)messageBuilder.toString(), (String)"Save Files During Commit", (String[])new String[]{"Save Now", "Postpone Save"}, (int)0, (Icon)Messages.getQuestionIcon());
        return rc == 0;
    }
}

