/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.actions.DeleteUnversionedFilesAction;
import com.intellij.openapi.vcs.changes.actions.IgnoreUnversionedAction;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.Icons;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class UnversionedViewDialog
extends DialogWrapper {
    private JPanel myPanel;
    private final ChangesListView myView;
    private final ChangeListManager myChangeListManager;
    private boolean myInRefresh;
    private final Project myProject;
    private boolean myFlattenState;

    public UnversionedViewDialog(Project project) {
        super(project, true);
        this.setTitle("Unversioned files");
        this.myProject = project;
        final Runnable closer = new Runnable(){

            @Override
            public void run() {
                UnversionedViewDialog.this.close(0);
            }
        };
        this.myView = new ChangesListView(project){

            @Override
            public void calcData(DataKey key, DataSink sink) {
                super.calcData(key, sink);
                if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.is(key.getName())) {
                    sink.put(key, Arrays.asList(this.getSelectedFiles()));
                }
            }

            @Override
            protected void editSourceRegistration() {
                EditSourceOnDoubleClickHandler.install((JTree)((Object)this), (Runnable)closer);
                EditSourceOnEnterKeyHandler.install((JComponent)((Object)this), (Runnable)closer);
            }
        };
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.createPanel();
        this.setOKButtonText("Close");
        this.init();
        this.initData(((ChangeListManagerImpl)this.myChangeListManager).getUnversionedFiles());
        this.myView.setMinimumSize(new Dimension(100, 100));
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }

    private void initData(List<VirtualFile> files) {
        TreeState state = TreeState.createOn((JTree)((Object)this.myView), (DefaultMutableTreeNode)((ChangesBrowserNode)this.myView.getModel().getRoot()));
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.myFlattenState);
        DefaultTreeModel model = builder.buildModelFromFiles(files);
        this.myView.setModel(model);
        this.myView.setCellRenderer((TreeCellRenderer)((Object)new ChangesBrowserNodeRenderer(this.myProject, this.myFlattenState, true)));
        this.myView.expandPath(new TreePath(((ChangesBrowserNode)model.getRoot()).getPath()));
        state.applyTo((JTree)((Object)this.myView));
    }

    private void createPanel() {
        this.myPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        LinkedList<Object> actions = new LinkedList<Object>();
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        AnAction expandAction = cam.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this.myView));
        actions.add(expandAction);
        AnAction collapseAction = cam.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this.myView));
        actions.add(collapseAction);
        actions.add((Object)new ToggleShowFlattenAction());
        actions.add((Object)new MoveChangesToAnotherListAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                super.actionPerformed(e);
                UnversionedViewDialog.this.refreshView();
            }
        });
        for (AnAction anAction : actions) {
            group.add(anAction);
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UNVERSIONED_DIALOG", (ActionGroup)group, false);
        this.myPanel.add((Component)actionToolbar.getComponent(), "West");
        this.myPanel.add((Component)new JScrollPane((Component)((Object)this.myView)), "Center");
        DeleteUnversionedFilesAction deleteUnversionedFilesAction = new DeleteUnversionedFilesAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                super.actionPerformed(e);
                UnversionedViewDialog.this.refreshView();
            }
        };
        actions.add((Object)deleteUnversionedFilesAction);
        deleteUnversionedFilesAction.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)((Object)this.myView));
        actions.add((Object)new ScheduleForAdditionAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                super.actionPerformed(e);
                UnversionedViewDialog.this.refreshView();
            }
        });
        actions.add((Object)new IgnoreUnversionedAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                super.actionPerformed(e);
                UnversionedViewDialog.this.refreshView();
            }
        });
        DefaultActionGroup secondGroup = new DefaultActionGroup();
        for (AnAction anAction : actions) {
            secondGroup.add(anAction);
        }
        this.myView.setMenuActions((ActionGroup)secondGroup);
        this.myView.setShowFlatten(false);
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.UnversionedViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void refreshView() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myInRefresh) {
            return;
        }
        this.myInRefresh = true;
        this.myChangeListManager.invokeAfterUpdate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    UnversionedViewDialog.this.initData(((ChangeListManagerImpl)UnversionedViewDialog.this.myChangeListManager).getUnversionedFiles());
                }
                finally {
                    UnversionedViewDialog.this.myInRefresh = false;
                }
            }
        }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE, "", ModalityState.current());
    }

    public class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), Icons.DIRECTORY_CLOSED_ICON);
            UnversionedViewDialog.this.myFlattenState = false;
        }

        public boolean isSelected(AnActionEvent e) {
            return !UnversionedViewDialog.this.myFlattenState;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            UnversionedViewDialog.this.myFlattenState = !state;
            UnversionedViewDialog.this.myView.setShowFlatten(UnversionedViewDialog.this.myFlattenState);
            UnversionedViewDialog.this.refreshView();
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)UnversionedViewDialog.this.myView));
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)UnversionedViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)UnversionedViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return true;
        }
    }
}

