/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.lifecycle.ControlledAlarmFactory;
import com.intellij.lifecycle.SlowlyClosingAlarm;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ControlledCycle
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ControlledCycle");
    private final Alarm mySimpleAlarm;
    private final SlowlyClosingAlarm myControlledAlarm;
    private static final int ourRefreshInterval = 10000;
    private final int myRefreshInterval;
    private final Runnable myRunnable;
    private final AtomicBoolean myActive;

    public ControlledCycle(Project project, MyCallback callback, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/changes/ControlledCycle.<init> must not be null");
        }
        this(project, callback, name, -1);
    }

    public ControlledCycle(Project project, final MyCallback callback, @NotNull String name, int refreshInterval) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/changes/ControlledCycle.<init> must not be null");
        }
        this.myRefreshInterval = refreshInterval <= 0 ? 10000 : refreshInterval;
        this.myActive = new AtomicBoolean(false);
        this.myRunnable = new Runnable(){
            boolean shouldBeContinued = true;

            @Override
            public void run() {
                try {
                    this.shouldBeContinued = callback.call(ControlledCycle.this.myControlledAlarm);
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                catch (RuntimeException e) {
                    LOG.info((Throwable)e);
                }
                if (!this.shouldBeContinued) {
                    ControlledCycle.this.myActive.set(false);
                } else {
                    ControlledCycle.this.mySimpleAlarm.addRequest((Runnable)ControlledCycle.this, ControlledCycle.this.myRefreshInterval);
                }
            }
        };
        this.mySimpleAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project);
        this.myControlledAlarm = ControlledAlarmFactory.createOnApplicationPooledThread(project, name);
    }

    public void start() {
        boolean wasSet = this.myActive.compareAndSet(false, true);
        if (wasSet) {
            this.mySimpleAlarm.addRequest((Runnable)this, this.myRefreshInterval);
        }
    }

    @Override
    public void run() {
        try {
            this.myControlledAlarm.checkShouldExit();
            this.myControlledAlarm.addRequest(this.myRunnable);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public static interface MyCallback {
        public boolean call(AtomicSectionsAware var1);
    }
}

