/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.ui.SdkEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkConfigurable
extends ProjectStructureElementConfigurable<Sdk>
implements Place.Navigator {
    private final ProjectJdkImpl myProjectJdk;
    private final SdkEditor mySdkEditor;
    private SdkProjectStructureElement myProjectStructureElement;

    public JdkConfigurable(ProjectJdkImpl projectJdk, ProjectJdksModel configurable, Runnable updateTree, @NotNull History history, Project project) {
        if (history == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable.<init> must not be null");
        }
        super(true, updateTree);
        this.myProjectJdk = projectJdk;
        this.mySdkEditor = new SdkEditor(configurable, history, this.myProjectJdk);
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(project).getContext();
        this.myProjectStructureElement = new SdkProjectStructureElement(context, this.myProjectJdk);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    public void setDisplayName(String name) {
        this.myProjectJdk.setName(name);
    }

    public Sdk getEditableObject() {
        return this.myProjectJdk;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.jdk.banner.text", (Object[])new Object[]{this.myProjectJdk.getName()});
    }

    public String getDisplayName() {
        return this.myProjectJdk.getName();
    }

    public Icon getIcon() {
        return this.myProjectJdk.getSdkType().getIcon();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdks";
    }

    public JComponent createOptionsPanel() {
        return this.mySdkEditor.createComponent();
    }

    public boolean isModified() {
        return this.mySdkEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.mySdkEditor.apply();
    }

    public void reset() {
        this.mySdkEditor.reset();
    }

    public void disposeUIResources() {
        this.mySdkEditor.disposeUIResources();
    }

    public void setHistory(History history) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.mySdkEditor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/JdkConfigurable.queryPlace must not be null");
        }
        this.mySdkEditor.queryPlace(place);
    }
}

