/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.util.KeyedExtensionFactory;
import com.intellij.pom.java.LanguageLevel;

public interface OrderRootTypeUIFactory {
    public static final KeyedExtensionFactory<OrderRootTypeUIFactory, OrderRootType> FACTORY = new KeyedExtensionFactory<OrderRootTypeUIFactory, OrderRootType>(OrderRootTypeUIFactory.class, "com.intellij.OrderRootTypeUI"){

        public String getKey(OrderRootType key) {
            return key.name();
        }
    };

    public LibraryTableTreeContentElement createElement(LibraryElement var1);

    public PathEditor createPathEditor(Sdk var1);

    public static class MyPathsEditor
    extends PathEditor {
        private final boolean myShowUrl;
        private final OrderRootType myOrderRootType;
        private final FileChooserDescriptor myDescriptor;
        private final String myDisplayName;
        private final Sdk mySdk;

        public MyPathsEditor(String displayName, OrderRootType orderRootType, FileChooserDescriptor descriptor, boolean showUrl, Sdk sdk) {
            this.myShowUrl = showUrl;
            this.myOrderRootType = orderRootType;
            this.myDescriptor = descriptor;
            this.myDisplayName = displayName;
            this.mySdk = sdk;
        }

        @Override
        protected boolean isShowUrlButton() {
            return this.myShowUrl;
        }

        @Override
        protected OrderRootType getRootType() {
            return this.myOrderRootType;
        }

        @Override
        protected FileChooserDescriptor createFileChooserDescriptor() {
            return this.myDescriptor;
        }

        @Override
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @Override
        protected String getInitialValue() {
            String versionString;
            if (this.mySdk != null && (versionString = this.mySdk.getVersionString()) != null) {
                LanguageLevel level = LanguageLevelUtil.getDefaultLanguageLevel((String)versionString);
                if (level == LanguageLevel.JDK_1_5) {
                    return "http://java.sun.com/j2se/1.5.0/docs/api/";
                }
                if (level == LanguageLevel.JDK_1_6) {
                    return "http://java.sun.com/j2se/6/docs/api/";
                }
            }
            return "";
        }
    }
}

