/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.graph.GraphGenerator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesConfigurator
implements ModulesProvider,
ModuleEditor.ChangeListener {
    private static final Logger LOG = Logger.getInstance((String)("#" + ModulesConfigurator.class.getName()));
    private final Project myProject;
    private final ProjectConfigurable myProjectConfigurable;
    private final List<ModuleEditor> myModuleEditors = new ArrayList<ModuleEditor>();
    private final Comparator<ModuleEditor> myModuleEditorComparator = new Comparator<ModuleEditor>(){
        final ModulesAlphaComparator myModulesComparator = new ModulesAlphaComparator();

        @Override
        public int compare(ModuleEditor editor1, ModuleEditor editor2) {
            return this.myModulesComparator.compare(editor1.getModule(), editor2.getModule());
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    };
    private boolean myModified = false;
    private ModifiableModuleModel myModuleModel;
    private ProjectFacetsConfigurator myFacetsConfigurator;
    private StructureConfigurableContext myContext;
    private List<ModuleEditor.ChangeListener> myAllModulesChangeListeners = new ArrayList<ModuleEditor.ChangeListener>();

    public ModulesConfigurator(Project project, ProjectJdksModel projectJdksModel) {
        this.myProject = project;
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
        this.myProjectConfigurable = new ProjectConfigurable(project, this, projectJdksModel);
    }

    public void setContext(StructureConfigurableContext context) {
        this.myContext = context;
        this.myFacetsConfigurator = this.createFacetsConfigurator();
    }

    public ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myFacetsConfigurator;
    }

    public void disposeUIResources() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                    Disposer.dispose((Disposable)moduleEditor);
                }
                ModulesConfigurator.this.myModuleEditors.clear();
                ModulesConfigurator.this.myModuleModel.dispose();
                ModulesConfigurator.this.myFacetsConfigurator.disposeEditors();
            }
        });
    }

    public ProjectConfigurable getModulesConfigurable() {
        return this.myProjectConfigurable;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.getModules must not return null");
        }
        return moduleArray;
    }

    @Nullable
    public Module getModule(String name) {
        Module moduleByName = this.myModuleModel.findModuleByName(name);
        if (moduleByName != null) {
            return moduleByName;
        }
        return this.myModuleModel.getModuleToBeRenamed(name);
    }

    @Nullable
    public ModuleEditor getModuleEditor(Module module) {
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            if (!module.equals(moduleEditor.getModule())) continue;
            return moduleEditor;
        }
        return null;
    }

    public ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.getRootModel must not be null");
        }
        return this.getEditor(module).getRootModel();
    }

    public ModuleEditor getEditor(Module module) {
        LOG.assertTrue(this.getModule(module.getName()) != null, (Object)"Module has been deleted");
        ModuleEditor editor = this.getModuleEditor(module);
        if (editor == null) {
            editor = this.createModuleEditor(module);
        }
        return editor;
    }

    public FacetModel getFacetModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.getFacetModel must not be null");
        }
        return this.myFacetsConfigurator.getOrCreateModifiableModel(module);
    }

    public void resetModuleEditors() {
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                assert (ModulesConfigurator.this.myModuleEditors.isEmpty());
                Module[] modules = ModulesConfigurator.this.myModuleModel.getModules();
                if (modules.length > 0) {
                    for (Module module : modules) {
                        ModulesConfigurator.this.createModuleEditor(module);
                    }
                    Collections.sort(ModulesConfigurator.this.myModuleEditors, ModulesConfigurator.this.myModuleEditorComparator);
                }
            }
        });
        this.myFacetsConfigurator.resetEditors();
        this.myModified = false;
    }

    public ModuleEditor createModuleEditor(Module module) {
        final ModuleEditor moduleEditor = new ModuleEditor(this.myProject, this, module){

            @Override
            public ProjectFacetsConfigurator getFacetsConfigurator() {
                return ModulesConfigurator.this.myFacetsConfigurator;
            }
        };
        final ProjectFacetsConfigurator configurator = this.myFacetsConfigurator;
        moduleEditor.addChangeListener(configurator);
        this.myModuleEditors.add(moduleEditor);
        moduleEditor.addChangeListener(this);
        Disposer.register((Disposable)moduleEditor, (Disposable)new Disposable(){

            public void dispose() {
                moduleEditor.removeChangeListener(ModulesConfigurator.this);
                moduleEditor.removeChangeListener(configurator);
            }
        });
        return moduleEditor;
    }

    @Override
    public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
        this.myProjectConfigurable.updateCircularDependencyWarning();
        for (ModuleEditor.ChangeListener listener : this.myAllModulesChangeListeners) {
            listener.moduleStateChanged(moduleRootModel);
        }
    }

    public void addAllModuleChangeListener(ModuleEditor.ChangeListener listener) {
        this.myAllModulesChangeListeners.add(listener);
    }

    public GraphGenerator<ModifiableRootModel> createGraphGenerator() {
        HashMap<Module, ModifiableRootModel> models = new HashMap<Module, ModifiableRootModel>();
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            models.put(moduleEditor.getModule(), moduleEditor.getModifiableRootModel());
        }
        return ModuleCompilerUtil.createGraphGenerator(models);
    }

    public void apply() throws ConfigurationException {
        com.intellij.util.containers.HashMap contentRootToModuleNameMap = new com.intellij.util.containers.HashMap();
        com.intellij.util.containers.HashMap srcRootsToContentRootMap = new com.intellij.util.containers.HashMap();
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            ContentEntry[] contents;
            ModifiableRootModel rootModel = moduleEditor.getModifiableRootModel();
            for (ContentEntry contentEntry : contents = rootModel.getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                String moduleName = moduleEditor.getName();
                String previousName = contentRootToModuleNameMap.put(contentRoot, moduleName);
                if (previousName != null && !previousName.equals(moduleName)) {
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.content.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), previousName, moduleName}));
                }
                for (VirtualFile srcRoot : contentEntry.getSourceFolderFiles()) {
                    String correctModule;
                    String problematicModule;
                    VirtualFile anotherContentRoot = srcRootsToContentRootMap.put(srcRoot, contentRoot);
                    if (anotherContentRoot == null) continue;
                    if (VfsUtil.isAncestor((VirtualFile)anotherContentRoot, (VirtualFile)contentRoot, (boolean)true)) {
                        problematicModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(contentRoot);
                    } else {
                        problematicModule = (String)contentRootToModuleNameMap.get(contentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.source.root.error", (Object[])new Object[]{problematicModule, srcRoot.getPresentableUrl(), correctModule}));
                }
            }
        }
        for (Map.Entry entry : srcRootsToContentRootMap.entrySet()) {
            VirtualFile srcRoot = (VirtualFile)entry.getKey();
            VirtualFile correspondingContent = (VirtualFile)entry.getValue();
            String expectedModuleName = (String)contentRootToModuleNameMap.get(correspondingContent);
            VirtualFile candidateContent = srcRoot;
            while (!candidateContent.equals(correspondingContent)) {
                String moduleName = (String)contentRootToModuleNameMap.get(candidateContent);
                if (moduleName != null && !moduleName.equals(expectedModuleName)) {
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.source.root.belongs.to.another.module.error", (Object[])new Object[]{srcRoot.getPresentableUrl(), expectedModuleName, moduleName}));
                }
                candidateContent = candidateContent.getParent();
            }
        }
        final ProjectRootManagerImpl projectRootManager = ProjectRootManagerImpl.getInstanceImpl(this.myProject);
        final ConfigurationException[] configurationExceptionArray = new ConfigurationException[1];
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ModulesConfigurator.this.myFacetsConfigurator.applyEditors();
                    ArrayList<ModifiableRootModel> models = new ArrayList<ModifiableRootModel>(ModulesConfigurator.this.myModuleEditors.size());
                    for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                        ModifiableRootModel model = moduleEditor.apply();
                        if (model == null) continue;
                        models.add(model);
                    }
                    ModifiableRootModel[] rootModels = models.toArray(new ModifiableRootModel[models.size()]);
                    projectRootManager.multiCommit(ModulesConfigurator.this.myModuleModel, rootModels);
                    ModulesConfigurator.this.myFacetsConfigurator.commitFacets();
                    ModuleStructureConfigurable.getInstance(ModulesConfigurator.this.myProject).getFacetEditorFacade().clearMaps(false);
                }
                catch (ConfigurationException e) {
                    try {
                        configurationExceptionArray[0] = e;
                        ModuleStructureConfigurable.getInstance(ModulesConfigurator.this.myProject).getFacetEditorFacade().clearMaps(false);
                    }
                    catch (Throwable throwable) {
                        ModuleStructureConfigurable.getInstance(ModulesConfigurator.this.myProject).getFacetEditorFacade().clearMaps(false);
                        for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                            moduleEditor.removeChangeListener(ModulesConfigurator.this.myFacetsConfigurator);
                        }
                        ModulesConfigurator.this.myFacetsConfigurator = ModulesConfigurator.this.createFacetsConfigurator();
                        ModulesConfigurator.this.myModuleModel = ModuleManager.getInstance((Project)ModulesConfigurator.this.myProject).getModifiableModel();
                        ProjectFacetsConfigurator configurator = ModulesConfigurator.this.myFacetsConfigurator;
                        for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                            moduleEditor.addChangeListener(configurator);
                            Disposer.register((Disposable)moduleEditor, (Disposable)new Disposable(moduleEditor, configurator){
                                final /* synthetic */ ModuleEditor val$moduleEditor;
                                final /* synthetic */ ProjectFacetsConfigurator val$configurator;
                                {
                                    this.val$moduleEditor = moduleEditor;
                                    this.val$configurator = projectFacetsConfigurator;
                                }

                                public void dispose() {
                                    this.val$moduleEditor.removeChangeListener(this.val$configurator);
                                }
                            });
                        }
                        throw throwable;
                    }
                    for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                        moduleEditor.removeChangeListener(ModulesConfigurator.this.myFacetsConfigurator);
                    }
                    ModulesConfigurator.this.myFacetsConfigurator = ModulesConfigurator.this.createFacetsConfigurator();
                    ModulesConfigurator.this.myModuleModel = ModuleManager.getInstance((Project)ModulesConfigurator.this.myProject).getModifiableModel();
                    ProjectFacetsConfigurator configurator = ModulesConfigurator.this.myFacetsConfigurator;
                    for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                        moduleEditor.addChangeListener(configurator);
                        Disposer.register((Disposable)moduleEditor, (Disposable)new /* invalid duplicate definition of identical inner class */);
                    }
                }
                for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                    moduleEditor.removeChangeListener(ModulesConfigurator.this.myFacetsConfigurator);
                }
                ModulesConfigurator.this.myFacetsConfigurator = ModulesConfigurator.this.createFacetsConfigurator();
                ModulesConfigurator.this.myModuleModel = ModuleManager.getInstance((Project)ModulesConfigurator.this.myProject).getModifiableModel();
                ProjectFacetsConfigurator configurator = ModulesConfigurator.this.myFacetsConfigurator;
                for (ModuleEditor moduleEditor : ModulesConfigurator.this.myModuleEditors) {
                    moduleEditor.addChangeListener(configurator);
                    Disposer.register((Disposable)moduleEditor, (Disposable)new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
        if (configurationExceptionArray[0] != null) {
            throw configurationExceptionArray[0];
        }
        this.myModified = false;
    }

    private ProjectFacetsConfigurator createFacetsConfigurator() {
        return new ProjectFacetsConfigurator(this.myContext, this.myFacetsConfigurator);
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public ModifiableModuleModel getModuleModel() {
        return this.myModuleModel;
    }

    public boolean deleteModule(Module module) {
        return this.doRemoveModule(this.getModuleEditor(module));
    }

    @Nullable
    public List<Module> addModule(Component parent) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ProjectBuilder builder = this.runModuleWizard(parent);
        if (builder != null) {
            List<Module> commitedModules;
            final ArrayList<Module> modules = new ArrayList<Module>();
            if (builder instanceof ProjectImportBuilder) {
                ModifiableArtifactModel artifactModel = ProjectStructureConfigurable.getInstance(this.myProject).getArtifactsStructureConfigurable().getModifiableArtifactModel();
                commitedModules = ((ProjectImportBuilder)builder).commit(this.myProject, this.myModuleModel, this, artifactModel);
            } else {
                commitedModules = builder.commit(this.myProject, this.myModuleModel, (ModulesProvider)this);
            }
            if (commitedModules != null) {
                modules.addAll(commitedModules);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (Module module : modules) {
                        ModulesConfigurator.this.createModuleEditor(module);
                    }
                }
            });
            return modules;
        }
        return null;
    }

    private Module createModule(final ModuleBuilder builder) {
        final Exception[] ex = new Exception[]{null};
        Module module = (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                try {
                    return builder.createModule(ModulesConfigurator.this.myModuleModel);
                }
                catch (Exception e) {
                    ex[0] = e;
                    return null;
                }
            }
        });
        if (ex[0] != null) {
            Messages.showErrorDialog((String)ProjectBundle.message((String)"module.add.error.message", (Object[])new Object[]{ex[0].getMessage()}), (String)ProjectBundle.message((String)"module.add.error.title", (Object[])new Object[0]));
        }
        return module;
    }

    @Nullable
    public Module addModule(ModuleBuilder moduleBuilder) {
        final Module module = this.createModule(moduleBuilder);
        if (module != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.this.createModuleEditor(module);
                    Collections.sort(ModulesConfigurator.this.myModuleEditors, ModulesConfigurator.this.myModuleEditorComparator);
                }
            });
            this.processModuleCountChanged();
        }
        return module;
    }

    @Nullable
    ProjectBuilder runModuleWizard(Component dialogParent) {
        AddModuleWizard wizard = new AddModuleWizard(dialogParent, this.myProject, this);
        wizard.show();
        if (wizard.isOK()) {
            ProjectBuilder builder = wizard.getProjectBuilder();
            if (builder instanceof ModuleBuilder) {
                ModuleBuilder moduleBuilder = (ModuleBuilder)builder;
                if (moduleBuilder.getName() == null) {
                    moduleBuilder.setName(wizard.getProjectName());
                }
                if (moduleBuilder.getModuleFilePath() == null) {
                    moduleBuilder.setModuleFilePath(wizard.getModuleFilePath());
                }
            }
            if (!builder.validate(this.myProject, this.myProject)) {
                return null;
            }
            return wizard.getProjectBuilder();
        }
        return null;
    }

    private boolean doRemoveModule(ModuleEditor selectedEditor) {
        String question = this.myModuleEditors.size() == 1 ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[0]) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{selectedEditor.getModule().getName()});
        int result = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (result != 0) {
            return false;
        }
        this.myModuleEditors.remove(selectedEditor);
        Module moduleToRemove = selectedEditor.getModule();
        ArrayList<ModifiableRootModel> modifiableRootModels = new ArrayList<ModifiableRootModel>();
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
            modifiableRootModels.add(modifiableRootModel);
        }
        ModuleDeleteProvider.removeModule(moduleToRemove, null, modifiableRootModels, this.myModuleModel);
        this.processModuleCountChanged();
        Disposer.dispose((Disposable)selectedEditor);
        return true;
    }

    private void processModuleCountChanged() {
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            moduleEditor.moduleCountChanged();
        }
    }

    public void processModuleCompilerOutputChanged(String baseUrl) {
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            moduleEditor.updateCompilerOutputPathChanged(baseUrl, moduleEditor.getName());
        }
    }

    public boolean isModified() {
        if (this.myModuleModel.isChanged()) {
            return true;
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            if (!moduleEditor.isModified()) continue;
            return true;
        }
        return this.myModified || this.myFacetsConfigurator.isModified();
    }

    public static boolean showSdkSettings(@NotNull Project project, final Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.showSdkSettings must not be null");
        }
        final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                configurable.select(sdk, true);
            }
        });
    }

    public static boolean showLibrarySettings(@NotNull Project project, final @NotNull LibraryOrderEntry library) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.showLibrarySettings must not be null");
        }
        if (library == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.showLibrarySettings must not be null");
        }
        final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                configurable.select(library, true);
            }
        });
    }

    public static boolean showArtifactSettings(@NotNull Project project, final @Nullable Artifact artifact) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.showArtifactSettings must not be null");
        }
        final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                configurable.select(artifact, true);
            }
        });
    }

    public static boolean showFacetSettingsDialog(final @NotNull Facet facet, final @Nullable String tabNameToSelect) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ModulesConfigurator.showFacetSettingsDialog must not be null");
        }
        Project project = facet.getModule().getProject();
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                final ModuleStructureConfigurable modulesConfig = config.getModulesConfig();
                config.select(facet, true).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        if (tabNameToSelect != null) {
                            FacetEditorImpl facetEditor = modulesConfig.getFacetConfigurator().getOrCreateEditor(facet);
                            facetEditor.setSelectedTabName(tabNameToSelect);
                        }
                    }
                });
            }
        });
    }

    public static boolean showDialog(Project project, final @Nullable String moduleToSelect, final String tabNameToSelect, final boolean showModuleWizard) {
        final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)config, new Runnable(){

            @Override
            public void run() {
                final ModuleStructureConfigurable modulesConfig = config.getModulesConfig();
                config.select(moduleToSelect, tabNameToSelect, true).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        modulesConfig.setStartModuleWizard(showModuleWizard);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                modulesConfig.setStartModuleWizard(false);
                            }
                        });
                    }
                });
            }
        });
    }

    public void moduleRenamed(Module module, String oldName, String name) {
        for (ModuleEditor moduleEditor : this.myModuleEditors) {
            if (module != moduleEditor.getModule() || !Comparing.strEqual((String)moduleEditor.getName(), (String)oldName)) continue;
            moduleEditor.setModuleName(name);
            moduleEditor.updateCompilerOutputPathChanged(ProjectStructureConfigurable.getInstance(this.myProject).getProjectConfig().getCompilerOutputUrl(), name);
            this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module), true, false);
            return;
        }
    }
}

