/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class ContentEntryEditor
implements ContentRootPanel.ActionCallback {
    private boolean myIsSelected;
    private ContentRootPanel myContentRootPanel;
    private JPanel myMainPanel;
    protected EventDispatcher<ContentEntryEditorListener> myEventDispatcher;
    private String myContentEntryUrl;
    protected final boolean myCanMarkSources;
    protected final boolean myCanMarkTestSources;

    public ContentEntryEditor(String contentEntryUrl, boolean canMarkSources, boolean canMarkTestSources) {
        this.myContentEntryUrl = contentEntryUrl;
        this.myCanMarkSources = canMarkSources;
        this.myCanMarkTestSources = canMarkTestSources;
    }

    public String getContentEntryUrl() {
        return this.myContentEntryUrl;
    }

    public void initUI() {
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.setOpaque(false);
        this.myMainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((ContentEntryEditorListener)ContentEntryEditor.this.myEventDispatcher.getMulticaster()).editingStarted(ContentEntryEditor.this);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ContentEntryEditor.this.myIsSelected) {
                    ContentEntryEditor.this.highlight(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ContentEntryEditor.this.myIsSelected) {
                    ContentEntryEditor.this.highlight(false);
                }
            }
        });
        this.myEventDispatcher = EventDispatcher.create(ContentEntryEditorListener.class);
        this.setSelected(false);
        this.update();
    }

    @Nullable
    protected ContentEntry getContentEntry() {
        ContentEntry[] entries;
        for (ContentEntry entry : entries = this.getModel().getContentEntries()) {
            if (!entry.getUrl().equals(this.myContentEntryUrl)) continue;
            return entry;
        }
        return null;
    }

    protected abstract ModifiableRootModel getModel();

    @Override
    public void deleteContentEntry() {
        int answer = Messages.showYesNoDialog((String)ProjectBundle.message((String)"module.paths.remove.content.prompt", (Object[])new Object[]{VirtualFileManager.extractPath((String)this.myContentEntryUrl).replace('/', File.separatorChar)}), (String)ProjectBundle.message((String)"module.paths.remove.content.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).beforeEntryDeleted(this);
        this.getModel().removeContentEntry(this.getContentEntry());
    }

    @Override
    public void deleteContentFolder(ContentEntry contentEntry, ContentFolder folder) {
        if (folder instanceof SourceFolder) {
            this.removeSourceFolder((SourceFolder)folder);
            this.update();
        } else if (folder instanceof ExcludeFolder) {
            this.removeExcludeFolder((ExcludeFolder)folder);
            this.update();
        }
    }

    @Override
    public void navigateFolder(ContentEntry contentEntry, ContentFolder contentFolder) {
        VirtualFile file = contentFolder.getFile();
        if (file != null) {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).navigationRequested(this, file);
        }
    }

    @Override
    public void setPackagePrefix(SourceFolder folder, String prefix) {
        folder.setPackagePrefix(prefix);
        this.update();
        ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).packagePrefixSet(this, folder);
    }

    public void addContentEntryEditorListener(ContentEntryEditorListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeContentEntryEditorListener(ContentEntryEditorListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public void setSelected(boolean isSelected) {
        if (this.myIsSelected != isSelected) {
            this.highlight(isSelected);
            this.myIsSelected = isSelected;
        }
    }

    private void highlight(boolean selected) {
        if (this.myContentRootPanel != null) {
            this.myContentRootPanel.setSelected(selected);
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void update() {
        if (this.myContentRootPanel != null) {
            this.myMainPanel.remove(this.myContentRootPanel);
        }
        this.myContentRootPanel = this.createContentRootPane();
        this.myContentRootPanel.initUI();
        this.myContentRootPanel.setSelected(this.myIsSelected);
        this.myMainPanel.add((Component)this.myContentRootPanel, "Center");
        this.myMainPanel.revalidate();
    }

    protected ContentRootPanel createContentRootPane() {
        return new ContentRootPanel(this, this.myCanMarkSources, this.myCanMarkTestSources){

            @Override
            protected ContentEntry getContentEntry() {
                return ContentEntryEditor.this.getContentEntry();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SourceFolder addSourceFolder(VirtualFile file, boolean isTestSource) {
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry != null) {
            SourceFolder sourceFolder = contentEntry.addSourceFolder(file, isTestSource);
            try {
                SourceFolder sourceFolder2 = sourceFolder;
                return sourceFolder2;
            }
            finally {
                ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).sourceFolderAdded(this, sourceFolder);
                this.update();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceFolder(SourceFolder sourceFolder) {
        VirtualFile file = sourceFolder.getFile();
        boolean isTestSource = sourceFolder.isTestSource();
        try {
            this.doRemoveSourceFolder(sourceFolder);
        }
        finally {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).sourceFolderRemoved(this, file, isTestSource);
            this.update();
        }
    }

    protected void doRemoveSourceFolder(SourceFolder sourceFolder) {
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry != null) {
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExcludeFolder addExcludeFolder(VirtualFile file) {
        try {
            ExcludeFolder excludeFolder = this.doAddExcludeFolder(file);
            return excludeFolder;
        }
        finally {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).folderExcluded(this, file);
            this.update();
        }
    }

    @Nullable
    protected ExcludeFolder doAddExcludeFolder(VirtualFile file) {
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry != null) {
            return contentEntry.addExcludeFolder(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExcludeFolder(ExcludeFolder excludeFolder) {
        VirtualFile file = excludeFolder.getFile();
        try {
            this.doRemoveExcludeFolder(excludeFolder, file);
        }
        finally {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).folderIncluded(this, file);
            this.update();
        }
    }

    protected void doRemoveExcludeFolder(ExcludeFolder excludeFolder, VirtualFile file) {
        ContentEntry contentEntry;
        if (!excludeFolder.isSynthetic() && (contentEntry = this.getContentEntry()) != null) {
            contentEntry.removeExcludeFolder(excludeFolder);
        }
    }

    public boolean isSource(VirtualFile file) {
        SourceFolder sourceFolder = this.getSourceFolder(file);
        return sourceFolder != null && !sourceFolder.isTestSource();
    }

    public boolean isTestSource(VirtualFile file) {
        SourceFolder sourceFolder = this.getSourceFolder(file);
        return sourceFolder != null && sourceFolder.isTestSource();
    }

    public boolean isExcluded(VirtualFile file) {
        return this.getExcludeFolder(file) != null;
    }

    public boolean isUnderExcludedDirectory(VirtualFile file) {
        ExcludeFolder[] excludeFolders;
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return false;
        }
        for (ExcludeFolder excludeFolder : excludeFolders = contentEntry.getExcludeFolders()) {
            VirtualFile excludedDir = excludeFolder.getFile();
            if (excludedDir == null || !VfsUtil.isAncestor((VirtualFile)excludedDir, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExcludeFolder getExcludeFolder(VirtualFile file) {
        ExcludeFolder[] excludeFolders;
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return null;
        }
        for (ExcludeFolder excludeFolder : excludeFolders = contentEntry.getExcludeFolders()) {
            VirtualFile f = excludeFolder.getFile();
            if (f == null || !f.equals(file)) continue;
            return excludeFolder;
        }
        return null;
    }

    @Nullable
    public SourceFolder getSourceFolder(VirtualFile file) {
        SourceFolder[] sourceFolders;
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return null;
        }
        for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
            VirtualFile f = sourceFolder.getFile();
            if (f == null || !f.equals(file)) continue;
            return sourceFolder;
        }
        return null;
    }

    public static interface ContentEntryEditorListener
    extends EventListener {
        public void editingStarted(ContentEntryEditor var1);

        public void beforeEntryDeleted(ContentEntryEditor var1);

        public void sourceFolderAdded(ContentEntryEditor var1, SourceFolder var2);

        public void sourceFolderRemoved(ContentEntryEditor var1, VirtualFile var2, boolean var3);

        public void folderExcluded(ContentEntryEditor var1, VirtualFile var2);

        public void folderIncluded(ContentEntryEditor var1, VirtualFile var2);

        public void navigationRequested(ContentEntryEditor var1, VirtualFile var2);

        public void packagePrefixSet(ContentEntryEditor var1, SourceFolder var2);
    }
}

