/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ActionsTree {
    private static final Icon EMPTY_ICON = new EmptyIcon(18, 18);
    private static final Icon QUICK_LIST_ICON = IconLoader.getIcon((String)"/actions/quickList.png");
    private static final Icon OPEN_ICON = new DefaultTreeCellRenderer().getOpenIcon();
    private static final Icon CLOSE_ICON = new DefaultTreeCellRenderer().getClosedIcon();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.keymap.impl.ui.ActionsTree");
    private final JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private final JScrollPane myComponent;
    private Keymap myKeymap;
    private Group myMainGroup = new Group("", null, null);
    @NonNls
    private static final String ROOT = "ROOT";
    private String myFilter = null;

    public ActionsTree() {
        this.myRoot = new DefaultMutableTreeNode(ROOT);
        this.myTree = new JTree(new MyModel(this.myRoot));
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Keymap originalKeymap = ActionsTree.this.myKeymap != null ? ActionsTree.this.myKeymap.getParent() : null;
                Icon icon = null;
                if (value instanceof DefaultMutableTreeNode) {
                    boolean changed;
                    String text;
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof Group) {
                        Group group = (Group)userObject;
                        text = group.getName();
                        changed = originalKeymap != null && ActionsTree.isGroupChanged(group, originalKeymap, ActionsTree.this.myKeymap);
                        Icon icon2 = icon = expanded ? group.getOpenIcon() : group.getIcon();
                        if (icon == null) {
                            icon = expanded ? OPEN_ICON : CLOSE_ICON;
                        }
                    } else if (userObject instanceof String) {
                        String actionId = (String)userObject;
                        AnAction action = ActionManager.getInstance().getActionOrStub(actionId);
                        if (action != null) {
                            Icon actionIcon;
                            text = action.getTemplatePresentation().getText();
                            if (text == null || text.length() == 0) {
                                text = actionId;
                            }
                            if ((actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                                icon = actionIcon;
                            }
                        } else {
                            text = actionId;
                        }
                        changed = originalKeymap != null && ActionsTree.isActionChanged(actionId, originalKeymap, ActionsTree.this.myKeymap);
                    } else if (userObject instanceof QuickList) {
                        QuickList list = (QuickList)userObject;
                        icon = QUICK_LIST_ICON;
                        text = list.getDisplayName();
                        changed = originalKeymap != null && ActionsTree.isActionChanged(list.getActionId(), originalKeymap, ActionsTree.this.myKeymap);
                    } else if (userObject instanceof Separator) {
                        changed = false;
                        text = "-------------";
                    } else {
                        throw new IllegalArgumentException("unknown userObject: " + userObject);
                    }
                    this.setIcon(ActionsTree.getEvenIcon(icon));
                    Color foreground = selected && hasFocus ? UIUtil.getTreeSelectionForeground() : (changed ? Color.BLUE : UIUtil.getTreeForeground());
                    SearchUtil.appendFragments(ActionsTree.this.myFilter, text, 0, foreground, selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground(), this);
                }
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(0);
        this.myComponent = ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.myTree.getSelectionModel().addTreeSelectionListener(l);
    }

    private Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
        return userObject;
    }

    public String getSelectedActionId() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof String) {
            return (String)userObject;
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getActionId();
        }
        return null;
    }

    public QuickList getSelectedQuickList() {
        Object userObject = this.getSelectedObject();
        if (!(userObject instanceof QuickList)) {
            return null;
        }
        return (QuickList)userObject;
    }

    public void reset(Keymap keymap, QuickList[] allQuickLists) {
        this.reset(keymap, allQuickLists, this.myFilter, null);
    }

    public Group getMainGroup() {
        return this.myMainGroup;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void filter(String filter, QuickList[] currentQuickListIds) {
        this.myFilter = filter;
        this.reset(this.myKeymap, currentQuickListIds, filter, null);
    }

    private void reset(Keymap keymap, QuickList[] allQuickLists, String filter, KeyboardShortcut shortcut) {
        this.myKeymap = keymap;
        PathsKeeper pathsKeeper = new PathsKeeper();
        pathsKeeper.storePaths();
        this.myRoot.removeAllChildren();
        ActionManager actionManager = ActionManager.getInstance();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        Group mainGroup = ActionsTreeUtil.createMainGroup(project, this.myKeymap, allQuickLists, filter, true, filter != null && filter.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter, true) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, this.myKeymap, shortcut) : null));
        if ((filter != null && filter.length() > 0 || shortcut != null) && mainGroup.initIds().isEmpty()) {
            mainGroup = ActionsTreeUtil.createMainGroup(project, this.myKeymap, allQuickLists, filter, false, filter != null && filter.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter, false) : ActionsTreeUtil.isActionFiltered(actionManager, this.myKeymap, shortcut));
        }
        this.myRoot = ActionsTreeUtil.createNode(mainGroup);
        this.myMainGroup = mainGroup;
        MyModel model = (MyModel)this.myTree.getModel();
        model.setRoot(this.myRoot);
        model.nodeStructureChanged(this.myRoot);
        pathsKeeper.restorePaths();
    }

    public void filterTree(KeyboardShortcut keyboardShortcut, QuickList[] currentQuickListIds) {
        this.reset(this.myKeymap, currentQuickListIds, this.myFilter, keyboardShortcut);
    }

    private static boolean isActionChanged(String actionId, Keymap oldKeymap, Keymap newKeymap) {
        Object[] newShortcuts;
        Object[] oldShortcuts = oldKeymap.getShortcuts(actionId);
        return !Comparing.equal((Object[])oldShortcuts, (Object[])(newShortcuts = newKeymap.getShortcuts(actionId)));
    }

    private static boolean isGroupChanged(Group group, Keymap oldKeymap, Keymap newKeymap) {
        ArrayList<Object> children = group.getChildren();
        for (Object child : children) {
            String actionId;
            if (!(child instanceof Group ? ActionsTree.isGroupChanged((Group)child, oldKeymap, newKeymap) : (child instanceof String ? ActionsTree.isActionChanged(actionId = (String)child, oldKeymap, newKeymap) : child instanceof QuickList && ActionsTree.isActionChanged(actionId = ((QuickList)child).getActionId(), oldKeymap, newKeymap)))) continue;
            return true;
        }
        return false;
    }

    public void selectAction(String actionId) {
        JTree tree = this.myTree;
        String path = this.myMainGroup.getActionQualifiedPath(actionId);
        if (path == null) {
            return;
        }
        final DefaultMutableTreeNode node = this.getNodeForPath(path);
        if (node == null) {
            return;
        }
        tree.expandPath(new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath()));
        Alarm alarm = new Alarm();
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                TreeUtil.selectPath((JTree)ActionsTree.this.myTree, (TreePath)new TreePath(node.getPath()));
            }
        }, 100);
    }

    private DefaultMutableTreeNode getNodeForPath(String path) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!Comparing.equal((String)this.getPath(node), (String)path)) continue;
            return node;
        }
        return null;
    }

    private ArrayList<DefaultMutableTreeNode> getNodesByPaths(ArrayList<String> paths) {
        ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            String path = this.getPath(node);
            if (!paths.contains(path)) continue;
            result.add(node);
        }
        return result;
    }

    @Nullable
    private String getPath(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof String) {
            String actionId = (String)userObject;
            return this.myMainGroup.getActionQualifiedPath(actionId);
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getQualifiedPath();
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getDisplayName();
        }
        return null;
    }

    public static Icon getEvenIcon(Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconHeight() <= EMPTY_ICON.getIconHeight() && icon.getIconWidth() <= EMPTY_ICON.getIconWidth()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        return layeredIcon;
    }

    private class PathsKeeper {
        private ArrayList<String> myPathsToExpand;
        private ArrayList<String> mySelectionPaths;

        private PathsKeeper() {
        }

        public void storePaths() {
            this.myPathsToExpand = new ArrayList();
            this.mySelectionPaths = new ArrayList();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ActionsTree.this.myTree.getModel().getRoot();
            TreePath path = new TreePath(root.getPath());
            if (ActionsTree.this.myTree.isPathSelected(path)) {
                this.mySelectionPaths.add(ActionsTree.this.getPath(root));
            }
            if (ActionsTree.this.myTree.isExpanded(path) || root.getChildCount() == 0) {
                this.myPathsToExpand.add(ActionsTree.this.getPath(root));
                this._storePaths(root);
            }
        }

        private void _storePaths(DefaultMutableTreeNode root) {
            ArrayList<TreeNode> childNodes = this.childrenToArray(root);
            for (TreeNode childNode1 : childNodes) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
                TreePath path = new TreePath(childNode.getPath());
                if (ActionsTree.this.myTree.isPathSelected(path)) {
                    this.mySelectionPaths.add(ActionsTree.this.getPath(childNode));
                }
                if (!ActionsTree.this.myTree.isExpanded(path) && childNode.getChildCount() != 0) continue;
                this.myPathsToExpand.add(ActionsTree.this.getPath(childNode));
                this._storePaths(childNode);
            }
        }

        public void restorePaths() {
            ArrayList nodesToExpand = ActionsTree.this.getNodesByPaths(this.myPathsToExpand);
            for (DefaultMutableTreeNode node : nodesToExpand) {
                ActionsTree.this.myTree.expandPath(new TreePath(node.getPath()));
            }
            Alarm alarm = new Alarm().setActivationComponent((JComponent)ActionsTree.this.myComponent);
            alarm.addComponentRequest(new Runnable(){

                @Override
                public void run() {
                    ArrayList nodesToSelect = ActionsTree.this.getNodesByPaths(PathsKeeper.this.mySelectionPaths);
                    for (DefaultMutableTreeNode node : nodesToSelect) {
                        TreeUtil.selectNode((JTree)ActionsTree.this.myTree, (TreeNode)node);
                    }
                }
            }, 100);
        }

        private ArrayList<TreeNode> childrenToArray(DefaultMutableTreeNode node) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (int i = 0; i < node.getChildCount(); ++i) {
                arrayList.add(node.getChildAt(i));
            }
            return arrayList;
        }
    }

    private class MyModel
    extends DefaultTreeModel
    implements TreeTableModel {
        protected MyModel(DefaultMutableTreeNode root) {
            super(root);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return KeyMapBundle.message((String)"action.column.name", (Object[])new Object[0]);
                }
                case 1: {
                    return KeyMapBundle.message((String)"shortcuts.column.name", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public Object getValueAt(Object value, int column) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return "???";
            }
            if (column == 0) {
                return value;
            }
            if (column == 1) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof QuickList) {
                    userObject = ((QuickList)userObject).getActionId();
                }
                if (userObject instanceof String) {
                    Shortcut[] shortcuts = ActionsTree.this.myKeymap.getShortcuts((String)userObject);
                    return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
                }
                return "";
            }
            return "???";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((TreeNode)parent).getChildCount();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }
}

