/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.impl.FileComparator;
import com.intellij.openapi.fileChooser.impl.FileTreeBuilder;
import com.intellij.openapi.fileChooser.impl.FileTreeStructure;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.treeStructure.SimpleNodeRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ConvertingIterator;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class FileSystemTreeImpl
implements FileSystemTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.chooser.FileSystemTreeImpl");
    private final Tree myTree;
    private final FileTreeStructure myTreeStructure;
    private final AbstractTreeBuilder myTreeBuilder;
    private final Project myProject;
    private final ArrayList<Runnable> myOkActions = new ArrayList(2);
    private final FileChooserDescriptor myDescriptor;
    private final List<FileSystemTree.Listener> myListeners = new ArrayList<FileSystemTree.Listener>();
    private final MyExpansionListener myExpansionListener = new MyExpansionListener();

    public FileSystemTreeImpl(@Nullable Project project, FileChooserDescriptor descriptor) {
        this(project, descriptor, new Tree(), null, null);
        this.myTree.setRootVisible(descriptor.isTreeRootVisible());
        this.myTree.setShowsRootHandles(true);
    }

    public FileSystemTreeImpl(@Nullable Project project, FileChooserDescriptor descriptor, Tree tree, TreeCellRenderer renderer, final Runnable onInitialized) {
        this.myProject = project;
        this.myTreeStructure = new FileTreeStructure(project, descriptor);
        this.myDescriptor = descriptor;
        this.myTree = tree;
        final DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree.setModel((TreeModel)treeModel);
        this.myTree.addTreeExpansionListener((TreeExpansionListener)this.myExpansionListener);
        this.myTreeBuilder = this.createTreeBuilder((JTree)this.myTree, treeModel, this.myTreeStructure, FileComparator.getInstance(), descriptor, new Runnable(){

            @Override
            public void run() {
                FileSystemTreeImpl.this.myTree.expandPath(new TreePath(treeModel.getRoot()));
                if (onInitialized != null) {
                    onInitialized.run();
                }
            }
        });
        Disposer.register((Disposable)this.myTreeBuilder, (Disposable)new Disposable(){

            public void dispose() {
                FileSystemTreeImpl.this.myTree.removeTreeExpansionListener((TreeExpansionListener)FileSystemTreeImpl.this.myExpansionListener);
            }
        });
        if (project != null) {
            Disposer.register((Disposable)project, (Disposable)this.myTreeBuilder);
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileSystemTreeImpl.this.processSelectionChange();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTree.setLineStyleAngled();
        TreeToolTipHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(this.myTreeStructure.getChooserDescriptor().getChooseMultiple() ? 4 : 1);
        this.registerTreeActions();
        if (renderer == null) {
            renderer = new SimpleNodeRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    String comment;
                    super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof FileNodeDescriptor && (comment = ((FileNodeDescriptor)((Object)userObject)).getComment()) != null) {
                        this.append(comment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            };
        }
        this.myTree.setCellRenderer(renderer);
    }

    protected AbstractTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, FileChooserDescriptor descriptor, @Nullable Runnable onInitialized) {
        return new FileTreeBuilder(tree, treeModel, treeStructure, comparator, descriptor, onInitialized);
    }

    private void registerTreeActions() {
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSystemTreeImpl.this.performEnterAction(true);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileSystemTreeImpl.this.performEnterAction(false);
                }
            }
        });
    }

    private void performEnterAction(boolean toggleNodeState) {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node != null && node.isLeaf()) {
                this.fireOkAction();
            } else if (toggleNodeState) {
                if (this.myTree.isExpanded(path)) {
                    this.myTree.collapsePath(path);
                } else {
                    this.myTree.expandPath(path);
                }
            }
        }
    }

    public void addOkAction(Runnable action) {
        this.myOkActions.add(action);
    }

    private void fireOkAction() {
        for (Runnable action : this.myOkActions) {
            action.run();
        }
    }

    public void registerMouseListener(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)this.myTree, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public boolean areHiddensShown() {
        return this.myTreeStructure.areHiddensShown();
    }

    public void showHiddens(boolean showHiddens) {
        this.myTreeStructure.showHiddens(showHiddens);
        this.updateTree();
    }

    public void updateTree() {
        this.myTreeBuilder.updateFromRoot();
    }

    public void dispose() {
        if (this.myTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myTreeBuilder);
        }
    }

    public boolean select(VirtualFile file) {
        DefaultMutableTreeNode node = this.getNodeForFile(file);
        if (node == null) {
            return false;
        }
        TreeUtil.selectPath((JTree)this.myTree, (TreePath)new TreePath(node.getPath()));
        return true;
    }

    public void select(VirtualFile file, @Nullable Runnable onDone) {
        this.select(new VirtualFile[]{file}, onDone);
    }

    public void select(VirtualFile[] file, @Nullable Runnable onDone) {
        Object[] elements = new Object[file.length];
        for (int i = 0; i < file.length; ++i) {
            VirtualFile eachFile = file[i];
            elements[i] = FileSystemTreeImpl.getFileElementFor(eachFile);
        }
        this.myTreeBuilder.select(elements, onDone);
    }

    public void expand(VirtualFile file, @Nullable Runnable onDone) {
        this.myTreeBuilder.expand((Object)FileSystemTreeImpl.getFileElementFor(file), onDone);
    }

    @Nullable
    private static FileElement getFileElementFor(VirtualFile file) {
        VirtualFile selectFile;
        if (file.getFileSystem() instanceof JarFileSystem && file.getParent() == null) {
            selectFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (selectFile == null) {
                return null;
            }
        } else {
            selectFile = file;
        }
        return new FileElement(selectFile, selectFile.getName());
    }

    public boolean expand(VirtualFile directory) {
        if (!directory.isDirectory()) {
            return false;
        }
        DefaultMutableTreeNode node = this.getNodeForFile(directory);
        if (node == null) {
            return false;
        }
        this.myTree.expandPath(new TreePath(node.getPath()));
        return true;
    }

    @Nullable
    private DefaultMutableTreeNode getNodeForFile(VirtualFile file) {
        FileElement descriptor = FileSystemTreeImpl.getFileElementFor(file);
        if (descriptor == null) {
            return null;
        }
        this.myTreeBuilder.buildNodeForElement((Object)descriptor);
        return this.myTreeBuilder.getNodeForElement((Object)descriptor);
    }

    public Exception createNewFolder(final VirtualFile parentDirectory, final String newFolderName) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtualFile parent = parentDirectory;
                            for (String name : StringUtil.tokenize((String)newFolderName, (String)"\\/")) {
                                VirtualFile folder = parent.createChildDirectory((Object)this, name);
                                FileSystemTreeImpl.this.updateTree();
                                FileSystemTreeImpl.this.select(folder, null);
                                parent = folder;
                            }
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message((String)"file.chooser.create.new.folder.command.name", (Object[])new Object[0]), null);
        return failReason[0];
    }

    public Exception createNewFile(final VirtualFile parentDirectory, final String newFileName, final FileType fileType, final String initialContent) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String newFileNameWithExtension = newFileName.endsWith('.' + fileType.getDefaultExtension()) ? newFileName : newFileName + '.' + fileType.getDefaultExtension();
                            VirtualFile file = parentDirectory.createChildData((Object)this, newFileNameWithExtension);
                            VfsUtil.saveText((VirtualFile)file, (String)(initialContent != null ? initialContent : ""));
                            FileSystemTreeImpl.this.updateTree();
                            FileSystemTreeImpl.this.select(file, null);
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message((String)"file.chooser.create.new.file.command.name", (Object[])new Object[0]), null);
        return failReason[0];
    }

    public JTree getTree() {
        return this.myTree;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(node.getUserObject() instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)node.getUserObject());
        return descriptor.getElement().getFile();
    }

    public VirtualFile[] getSelectedFiles() {
        return this.collectSelectedFiles((Convertor<VirtualFile, VirtualFile>)new ConvertingIterator.IdConvertor());
    }

    public VirtualFile[] getChoosenFiles() {
        return this.collectSelectedFiles(new Convertor<VirtualFile, VirtualFile>(){

            @Nullable
            public VirtualFile convert(VirtualFile file) {
                if (file == null || !file.isValid()) {
                    return null;
                }
                return FileSystemTreeImpl.this.myTreeStructure.getChooserDescriptor().getFileToSelect(file);
            }
        });
    }

    private VirtualFile[] collectSelectedFiles(Convertor<VirtualFile, VirtualFile> fileConvertor) {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof FileNodeDescriptor)) {
                return VirtualFile.EMPTY_ARRAY;
            }
            FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)node.getUserObject());
            VirtualFile file = (VirtualFile)fileConvertor.convert((Object)descriptor.getElement().getFile());
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return VfsUtil.toVirtualFileArray(files);
    }

    public boolean selectionExists() {
        TreePath[] selectedPaths = this.myTree.getSelectionPaths();
        return selectedPaths != null && selectedPaths.length != 0;
    }

    public boolean isUnderRoots(VirtualFile file) {
        List roots = this.myDescriptor.getRoots();
        if (roots.size() == 0) {
            return true;
        }
        for (VirtualFile root : roots) {
            if (root == null || !VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void addListener(final FileSystemTree.Listener listener, Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FileSystemTreeImpl.this.myListeners.remove(listener);
            }
        });
    }

    private void fireSelection(List<VirtualFile> selection) {
        for (FileSystemTree.Listener each : this.myListeners) {
            each.selectionChanged(selection);
        }
    }

    private void processSelectionChange() {
        if (this.myListeners.size() == 0) {
            return;
        }
        ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                FileElement element;
                VirtualFile file;
                Object object;
                Object last = each.getLastPathComponent();
                if (!(last instanceof DefaultMutableTreeNode) || !((object = ((DefaultMutableTreeNode)last).getUserObject()) instanceof FileNodeDescriptor) || (file = (element = ((FileNodeDescriptor)((Object)object)).getElement()).getFile()) == null) continue;
                selection.add(file);
            }
        }
        this.fireSelection(selection);
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            FileNodeDescriptor nodeDescriptor;
            FileElement fileDescriptor;
            VirtualFile virtualFile;
            if (FileSystemTreeImpl.this.myTreeBuilder == null || !FileSystemTreeImpl.this.myTreeBuilder.isNodeBeingBuilt(event.getPath())) {
                return;
            }
            TreePath path = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof FileNodeDescriptor && (virtualFile = (fileDescriptor = (nodeDescriptor = (FileNodeDescriptor)((Object)node.getUserObject())).getElement()).getFile()) != null) {
                virtualFile.refresh(false, false);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

