/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.RangeMarkerImpl");
    protected final DocumentEx myDocument;
    protected volatile int myStart;
    protected volatile int myEnd;
    private volatile boolean isValid;
    private boolean isExpandToLeft;
    private boolean isExpandToRight;
    private static final AtomicLong counter = new AtomicLong();
    private final long myId;
    private volatile int modCount;

    protected RangeMarkerImpl(@NotNull DocumentEx document, int start, int end) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeMarkerImpl.<init> must not be null");
        }
        this.isValid = true;
        this.isExpandToLeft = false;
        this.isExpandToRight = false;
        if (start < 0) {
            throw new IllegalArgumentException("Wrong start: " + start + "; end=" + end);
        }
        if (end > document.getTextLength()) {
            throw new IllegalArgumentException("Wrong end: " + end + "; document length=" + document.getTextLength() + "; start=" + start);
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end: start=" + start + "; end=" + end);
        }
        this.myDocument = document;
        this.myStart = start;
        this.myEnd = end;
        this.myId = counter.getAndIncrement();
        this.registerInDocument();
    }

    protected void registerInDocument() {
        this.myDocument.addRangeMarker(this);
    }

    @Override
    public long getId() {
        return this.myId;
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/RangeMarkerImpl.getDocument must not return null");
        }
        return documentEx;
    }

    public void setGreedyToLeft(boolean greedy) {
        this.isExpandToLeft = greedy;
    }

    public void setGreedyToRight(boolean greedy) {
        this.isExpandToRight = greedy;
    }

    public boolean isGreedyToLeft() {
        return this.isExpandToLeft;
    }

    public boolean isGreedyToRight() {
        return this.isExpandToRight;
    }

    @Override
    public final void documentChanged(DocumentEvent e) {
        int modCount = ++this.modCount;
        int oldStart = this.myStart;
        int oldEnd = this.myEnd;
        int docLength = this.myDocument.getTextLength();
        if (!this.isValid) {
            LOG.error("Invalid range marker " + (this.isExpandToLeft ? "[" : "(") + oldStart + ", " + oldEnd + (this.isExpandToRight ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (this.myStart > this.myEnd || this.myStart < 0 || this.myEnd > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isExpandToLeft ? "[" : "(") + oldStart + ", " + oldEnd + (this.isExpandToRight ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.isValid = false;
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid && (this.myStart > this.myEnd || this.myStart < 0 || this.myEnd > docLength)) {
            String markerBefore = this.toString();
            LOG.error("Update failed. Event = " + e + ". " + "old doc length=" + docLength + "; real doc length = " + this.myDocument.getTextLength() + "; old mod count=" + modCount + "; mod count=" + this.modCount + "; " + this.getClass() + "." + " Before update: '" + markerBefore + "'; After update: '" + this + "'");
            this.isValid = false;
        }
    }

    protected void changedUpdateImpl(DocumentEvent e) {
        if (!this.isValid) {
            return;
        }
        if (this.myStart == this.myEnd) {
            this.processIfOnePoint(e);
            return;
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (this.myEnd < offset || !this.isExpandToRight && this.myEnd == offset) {
            return;
        }
        if (this.myStart > offset + oldLength || !this.isExpandToLeft && this.myStart == offset + oldLength) {
            this.myStart += newLength - oldLength;
            this.myEnd += newLength - oldLength;
            return;
        }
        if (this.myStart <= offset && this.myEnd >= offset + oldLength) {
            this.myEnd += newLength - oldLength;
            return;
        }
        if (this.myStart >= offset && this.myStart <= offset + oldLength && this.myEnd > offset + oldLength) {
            this.myEnd += newLength - oldLength;
            this.myStart = offset + newLength;
            return;
        }
        if (this.myEnd >= offset && this.myEnd <= offset + oldLength && this.myStart < offset) {
            this.myEnd = offset;
            return;
        }
        this.invalidate();
    }

    private void processIfOnePoint(DocumentEvent e) {
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < this.myStart && this.myStart < oldEnd) {
            this.invalidate();
            return;
        }
        if (offset == this.myStart && oldLength == 0 && this.isExpandToRight) {
            this.myEnd += e.getNewLength();
            return;
        }
        if (this.myStart > oldEnd || this.myStart == oldEnd && oldLength > 0) {
            this.myStart += e.getNewLength() - oldLength;
            this.myEnd += e.getNewLength() - oldLength;
        }
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")");
    }
}

