/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class TabAction
extends EditorAction {
    public TabAction() {
        super((EditorActionHandler)new Handler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertTabAtCaret(Editor editor, Project project) {
        int columnNumber = editor.getCaretModel().getLogicalPosition().column;
        CodeStyleFacade settings = CodeStyleFacade.getInstance((Project)project);
        Document doc = editor.getDocument();
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(doc);
        FileType fileType = vFile == null ? null : FileTypeManager.getInstance().getFileTypeByFile(vFile);
        int tabSize = settings.getIndentSize(fileType);
        int spacesToAddCount = tabSize - columnNumber % tabSize;
        boolean useTab = editor.getSettings().isUseTabCharacter(project);
        CharSequence chars = doc.getCharsSequence();
        if (useTab && settings.isSmartTabs(fileType)) {
            int offset = editor.getCaretModel().getOffset();
            while (offset > 0) {
                if (chars.charAt(--offset) == '\t') continue;
                if (chars.charAt(offset) == '\n') break;
                useTab = false;
                break;
            }
        }
        doc.startGuardedBlockChecking();
        try {
            if (useTab) {
                EditorModificationUtil.typeInStringAtCaretHonorBlockSelection((Editor)editor, (String)"\t", (boolean)false);
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < spacesToAddCount; ++i) {
                    buffer.append(' ');
                }
                EditorModificationUtil.typeInStringAtCaretHonorBlockSelection((Editor)editor, (String)buffer.toString(), (boolean)false);
            }
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
        }
        finally {
            doc.stopGuardedBlockChecking();
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.EDIT_COMMAND_GROUP);
            CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.command.name", (Object[])new Object[0]));
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            TabAction.insertTabAtCaret(editor, project);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return !editor.isOneLineMode() && !((EditorEx)editor).isEmbeddedIntoDialogWrapper();
        }
    }
}

