/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.DeleteLineAtCaretAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class CutLineEndAction
extends EditorAction {
    public CutLineEndAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            int lineNumber;
            int lineEndOffset;
            Document doc = editor.getDocument();
            if (doc.getLineCount() == 0) {
                return;
            }
            int caretOffset = editor.getCaretModel().getOffset();
            if (caretOffset >= (lineEndOffset = doc.getLineEndOffset(lineNumber = doc.getLineNumber(caretOffset)))) {
                DeleteLineAtCaretAction.deleteLineAtCaret(editor);
                return;
            }
            Handler.copyToClipboard(doc, caretOffset, lineEndOffset, dataContext, editor);
            int lineStartOffset = doc.getLineStartOffset(lineNumber);
            if (StringUtil.isEmptyOrSpaces((String)((Object)doc.getCharsSequence().subSequence(lineStartOffset, lineEndOffset)).toString())) {
                DeleteLineAtCaretAction.deleteLineAtCaret(editor);
            } else {
                doc.deleteString(caretOffset, lineEndOffset);
            }
        }

        private static void copyToClipboard(Document doc, int caretOffset, int lineEndOffset, DataContext dataContext, Editor editor) {
            String s = ((Object)doc.getCharsSequence().subSequence(caretOffset, lineEndOffset)).toString();
            s = StringUtil.convertLineSeparators((String)s);
            StringSelection contents = new StringSelection(s);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                Clipboard clipboard = editor.getComponent().getToolkit().getSystemClipboard();
                clipboard.setContents(contents, (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
            } else {
                CopyPasteManager.getInstance().setContents((Transferable)contents);
            }
        }
    }
}

