/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.actions.NextDiffAction;
import com.intellij.openapi.diff.actions.PreviousDiffAction;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeCounter;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.ApplyNonConflicts;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.EditorPlace;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.OpenPartialDiffAction;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.util.DiffDivider;
import com.intellij.openapi.diff.impl.util.DiffPanelOutterComponent;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.FontSizeSynchronizer;
import com.intellij.openapi.diff.impl.util.SyncScrollSupport;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.ThreePanels;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntHashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MergePanel2
implements DiffViewer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2");
    private final DiffPanelOutterComponent myPanel;
    private DiffRequest myData;
    private MergeList myMergeList;
    private boolean myDuringCreation = false;
    private final SyncScrollSupport myScrollSupport = new SyncScrollSupport();
    private final DiffDivider[] myDividers = new DiffDivider[]{new DiffDivider(FragmentSide.SIDE2), new DiffDivider(FragmentSide.SIDE1)};
    private boolean myScrollToFirstDiff = true;
    private final LabeledComponent[] myEditorsPanels = new LabeledComponent[3];
    public static final int EDITORS_COUNT = 3;
    private final DividersRepainter myDividersRepainter = new DividersRepainter();
    private StatusUpdater myStatusUpdater;
    private final DialogBuilder myBuilder;
    private MyDataProvider myProvider;
    private static final EditorPlace.ViewProperty<EditorColorsScheme> EDITOR_SCHEME = new EditorPlace.ViewProperty<EditorColorsScheme>(null){

        @Override
        public void doUpdateEditor(EditorEx editorEx, EditorColorsScheme scheme, EditorPlace.ComponentState state) {
            if (scheme != null) {
                editorEx.setColorsScheme(scheme);
            }
        }
    };
    public static final EditorPlace.ViewProperty<Boolean> LINE_NUMBERS = new EditorPlace.ViewProperty<Boolean>(Boolean.TRUE){

        @Override
        public void doUpdateEditor(EditorEx editorEx, Boolean aBoolean, EditorPlace.ComponentState state) {
            editorEx.getSettings().setLineNumbersShown(aBoolean.booleanValue());
        }
    };
    public static final EditorPlace.ViewProperty<Boolean> LINE_MARKERS_AREA = new EditorPlace.ViewProperty<Boolean>(Boolean.TRUE){

        @Override
        public void doUpdateEditor(EditorEx editorEx, Boolean aBoolean, EditorPlace.ComponentState state) {
            editorEx.getSettings().setLineMarkerAreaShown(aBoolean.booleanValue());
        }
    };
    public static final EditorPlace.ViewProperty<Integer> ADDITIONAL_LINES = new EditorPlace.ViewProperty<Integer>(null){

        @Override
        public void doUpdateEditor(EditorEx editorEx, Integer integer, EditorPlace.ComponentState state) {
            if (integer != null) {
                editorEx.getSettings().setAdditionalLinesCount(integer.intValue());
            }
        }
    };
    public static final EditorPlace.ViewProperty<Integer> ADDITIONAL_COLUMNS = new EditorPlace.ViewProperty<Integer>(null){

        @Override
        public void doUpdateEditor(EditorEx editorEx, Integer integer, EditorPlace.ComponentState state) {
            if (integer != null) {
                editorEx.getSettings().setAdditionalColumnsCount(integer.intValue());
            }
        }
    };
    public static final EditorPlace.ViewProperty<EditorColorsScheme> HIGHLIGHTER_SETTINGS = new EditorPlace.ViewProperty<EditorColorsScheme>(null){

        @Override
        public void doUpdateEditor(EditorEx editorEx, EditorColorsScheme settings, EditorPlace.ComponentState state) {
            if (settings == null) {
                settings = EditorColorsManager.getInstance().getGlobalScheme();
            }
            DiffEditorState editorState = (DiffEditorState)state;
            editorEx.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(editorState.getFileType(), settings, editorState.getProject()));
        }
    };
    private static final Collection<EditorPlace.ViewProperty> ALL_PROPERTIES = Arrays.asList(ADDITIONAL_COLUMNS, ADDITIONAL_LINES, EDITOR_SCHEME, HIGHLIGHTER_SETTINGS, LINE_MARKERS_AREA, LINE_NUMBERS);
    private static final DiffRequest.ToolbarAddons TOOLBAR = new DiffRequest.ToolbarAddons(){

        public void customize(DiffToolbar toolbar) {
            ActionManager actionManager = ActionManager.getInstance();
            toolbar.addAction(actionManager.getAction("$Copy"));
            toolbar.addAction(actionManager.getAction("Find"));
            toolbar.addAction(PreviousDiffAction.find());
            toolbar.addAction(NextDiffAction.find());
            toolbar.addSeparator();
            toolbar.addAction((AnAction)new OpenPartialDiffAction(1, 0, IconLoader.getIcon((String)"/diff/leftDiff.png")));
            toolbar.addAction((AnAction)new OpenPartialDiffAction(1, 2, IconLoader.getIcon((String)"/diff/rightDiff.png")));
            toolbar.addAction((AnAction)new OpenPartialDiffAction(0, 2, IconLoader.getIcon((String)"/diff/branchDiff.png")));
            toolbar.addSeparator();
            toolbar.addAction((AnAction)new ApplyNonConflicts());
        }
    };

    public MergePanel2(DialogBuilder builder, Disposable parent) {
        ArrayList<EditorPlace> editorPlaces = new ArrayList<EditorPlace>();
        EditorPlace.EditorListener placeListener = new EditorPlace.EditorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEditorCreated(EditorPlace place) {
                if (MergePanel2.this.myDuringCreation) {
                    return;
                }
                MergePanel2.this.disposeMergeList();
                MergePanel2.this.myDuringCreation = true;
                try {
                    MergePanel2.this.tryInitView();
                }
                finally {
                    MergePanel2.this.myDuringCreation = false;
                }
            }

            @Override
            public void onEditorReleased(Editor releasedEditor) {
                LOG.assertTrue(!MergePanel2.this.myDuringCreation);
                MergePanel2.this.disposeMergeList();
            }
        };
        for (int i = 0; i < 3; ++i) {
            EditorPlace editorPlace = new EditorPlace(new DiffEditorState(i));
            Disposer.register((Disposable)parent, (Disposable)editorPlace);
            editorPlaces.add(editorPlace);
            editorPlace.addListener(placeListener);
            this.myEditorsPanels[i] = new LabeledComponent();
            this.myEditorsPanels[i].setLabelLocation("North");
            this.myEditorsPanels[i].setComponent((JComponent)editorPlace);
        }
        FontSizeSynchronizer.attachTo(editorPlaces);
        this.myPanel = new DiffPanelOutterComponent(TextDiffType.MERGE_TYPES, TOOLBAR);
        this.myPanel.insertDiffComponent(new ThreePanels((JComponent[])this.myEditorsPanels, this.myDividers), new MyScrollingPanel());
        this.myProvider = new MyDataProvider();
        this.myPanel.setDataProvider(this.myProvider);
        this.myBuilder = builder;
    }

    public void setScrollToFirstDiff(boolean scrollToFirstDiff) {
        this.myScrollToFirstDiff = scrollToFirstDiff;
    }

    public Editor getEditor(int index) {
        return this.getEditorPlace(index).getEditor();
    }

    public FileType getContentType() {
        return this.myData == null ? FileTypes.PLAIN_TEXT : MergePanel2.getContentType(this.myData);
    }

    public String getVersionTitle(int index) {
        return this.myEditorsPanels[index].getRawText();
    }

    public EditorPlace getEditorPlace(int index) {
        return (EditorPlace)this.myEditorsPanels[index].getComponent();
    }

    private void createMergeList() {
        if (this.myData == null) {
            return;
        }
        DiffContent[] contents = this.myData.getContents();
        for (int i = 0; i < 3; ++i) {
            this.getEditorPlace(i).setDocument(contents[i].getDocument());
        }
        this.tryInitView();
    }

    private void tryInitView() {
        if (!this.hasAllEditors()) {
            return;
        }
        if (this.myMergeList != null) {
            return;
        }
        this.myMergeList = MergeList.create(this.myData);
        this.myMergeList.addListener(this.myDividersRepainter);
        this.myStatusUpdater = StatusUpdater.install(this.myMergeList, this.myPanel);
        Editor left = this.getEditor(0);
        Editor base = this.getEditor(1);
        Editor right = this.getEditor(2);
        this.myMergeList.setMarkups(left, base, right);
        EditingSides[] sides = new EditingSides[]{new MyEditingSides(FragmentSide.SIDE1), new MyEditingSides(FragmentSide.SIDE2)};
        this.myScrollSupport.install(sides);
        for (int i = 0; i < this.myDividers.length; ++i) {
            this.myDividers[i].listenEditors(sides[i]);
        }
        if (this.myScrollToFirstDiff) {
            this.myPanel.requestScrollEditors();
        }
    }

    private void disposeMergeList() {
        if (this.myMergeList == null) {
            return;
        }
        if (this.myStatusUpdater != null) {
            this.myStatusUpdater.dispose(this.myMergeList);
            this.myStatusUpdater = null;
        }
        this.myMergeList.removeListener(this.myDividersRepainter);
        this.myMergeList = null;
        for (DiffDivider myDivider : this.myDividers) {
            myDivider.stopListenEditors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiffRequest(DiffRequest data) {
        this.setTitle(data.getWindowTitle());
        this.disposeMergeList();
        for (int i = 0; i < 3; ++i) {
            this.getEditorPlace(i).setDocument(null);
        }
        LOG.assertTrue(!this.myDuringCreation);
        this.myDuringCreation = true;
        this.myProvider.putData(data.getGenericData());
        try {
            this.myData = data;
            String[] titles = this.myData.getContentTitles();
            for (int i = 0; i < this.myEditorsPanels.length; ++i) {
                LabeledComponent editorsPanel = this.myEditorsPanels[i];
                editorsPanel.getLabel().setText(titles[i]);
            }
            this.createMergeList();
            data.customizeToolbar(this.myPanel.resetToolbar());
            this.myPanel.registerToolbarActions();
            if (data instanceof MergeRequestImpl && this.myBuilder != null) {
                ((MergeRequestImpl)data).setActions(this.myBuilder, this);
            }
        }
        finally {
            this.myDuringCreation = false;
        }
    }

    private void setTitle(String windowTitle) {
        JDialog parent = this.getDialogWrapperParent();
        if (parent == null) {
            return;
        }
        parent.setTitle(windowTitle);
    }

    private JDialog getDialogWrapperParent() {
        for (Container panel = this.myPanel; panel != null; panel = panel.getParent()) {
            if (!(panel instanceof JDialog)) continue;
            return (JDialog)panel;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getEditorPlace(1).getContentComponent();
    }

    public int getContentsNumber() {
        return 3;
    }

    private boolean hasAllEditors() {
        for (int i = 0; i < 3; ++i) {
            if (this.getEditor(i) != null) continue;
            return false;
        }
        return true;
    }

    public DialogBuilder getBuilder() {
        return this.myBuilder;
    }

    public MergeRequestImpl getMergeRequest() {
        return (MergeRequestImpl)(this.myData instanceof MergeRequestImpl ? this.myData : null);
    }

    private static FileType getContentType(DiffRequest diffData) {
        FileType contentType = diffData.getContents()[1].getContentType();
        if (contentType == null) {
            contentType = FileTypes.PLAIN_TEXT;
        }
        return contentType;
    }

    public static MergePanel2 fromDataContext(DataContext dataContext) {
        DiffViewer diffComponent = (DiffViewer)PlatformDataKeys.DIFF_VIEWER.getData(dataContext);
        return diffComponent instanceof MergePanel2 ? (MergePanel2)diffComponent : null;
    }

    public MergeList getMergeList() {
        return this.myMergeList;
    }

    public <T> void setEditorProperty(EditorPlace.ViewProperty<T> property, T value) {
        for (int i = 0; i < 3; ++i) {
            EditorPlace editorPlace = this.getEditorPlace(i);
            editorPlace.getState().updateValue(editorPlace.getEditor(), property, value);
        }
    }

    public void setColorScheme(EditorColorsScheme scheme) {
        this.setEditorProperty(EDITOR_SCHEME, scheme);
        this.myPanel.setColorScheme(scheme);
    }

    public static class AsComponent
    extends JPanel {
        private final MergePanel2 myMergePanel;

        public AsComponent(Disposable parent) {
            super(new BorderLayout());
            this.myMergePanel = new MergePanel2(null, parent);
            this.add((Component)this.myMergePanel.getComponent(), "Center");
        }

        public MergePanel2 getMergePanel() {
            return this.myMergePanel;
        }

        public boolean isToolbarEnabled() {
            return this.myMergePanel.myPanel.isToolbarEnabled();
        }

        public void setToolbarEnabled(boolean enabled) {
            this.myMergePanel.myPanel.disableToolbar(!enabled);
        }
    }

    private static class StatusUpdater
    implements ChangeCounter.Listener {
        private final DiffPanelOutterComponent myPanel;

        private StatusUpdater(DiffPanelOutterComponent panel) {
            this.myPanel = panel;
        }

        @Override
        public void onCountersChanged(ChangeCounter counter) {
            int changes = counter.getChangeCounter();
            int conflicts = counter.getConflictCounter();
            String text = changes == 0 && conflicts == 0 ? DiffBundle.message((String)"merge.dialog.all.conflicts.resolved.message.text", (Object[])new Object[0]) : DiffBundle.message((String)"merge.statistics.message", (Object[])new Object[]{changes, conflicts});
            this.myPanel.setStatusBarText(text);
        }

        public void dispose(@NotNull MergeList mergeList) {
            if (mergeList == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$StatusUpdater.dispose must not be null");
            }
            ChangeCounter.getOrCreate(mergeList).removeListener(this);
        }

        public static StatusUpdater install(MergeList mergeList, DiffPanelOutterComponent panel) {
            ChangeCounter counters = ChangeCounter.getOrCreate(mergeList);
            StatusUpdater updater = new StatusUpdater(panel);
            counters.addListener(updater);
            updater.onCountersChanged(counters);
            return updater;
        }
    }

    private class DividersRepainter
    implements ChangeList.Listener {
        private DividersRepainter() {
        }

        @Override
        public void onChangeRemoved(ChangeList source) {
            FragmentSide side = MergePanel2.this.myMergeList.getSideOf(source);
            MergePanel2.this.myDividers[side.getIndex()].repaint();
        }
    }

    private class MergeFocusedSide
    implements FocusDiffSide {
        private MergeFocusedSide() {
        }

        @Override
        public Editor getEditor() {
            return MergePanel2.this.getEditor(1);
        }

        @Override
        public int[] getFragmentStartingLines() {
            TIntHashSet beginnings = new TIntHashSet();
            for (int i = 0; i < 2; ++i) {
                FragmentSide branchSide = FragmentSide.fromIndex((int)i);
                beginnings.addAll(MergePanel2.this.myMergeList.getChanges(branchSide).getLineBlocks().getBegginings(MergeList.BASE_SIDE));
            }
            int[] result = beginnings.toArray();
            Arrays.sort(result);
            return result;
        }
    }

    private class BranchFocusedSide
    implements FocusDiffSide {
        private final FragmentSide mySide;

        private BranchFocusedSide(FragmentSide side) {
            this.mySide = side;
        }

        @Override
        public Editor getEditor() {
            return MergePanel2.this.getEditor(this.mySide.getMergeIndex());
        }

        @Override
        public int[] getFragmentStartingLines() {
            return MergePanel2.this.myMergeList.getChanges(this.mySide).getLineBlocks().getBegginings(MergeList.BRANCH_SIDE);
        }
    }

    private class MyDataProvider
    extends GenericDataProvider {
        private MyDataProvider() {
        }

        @Override
        public Object getData(String dataId) {
            if (FocusDiffSide.DATA_KEY.is(dataId)) {
                int index = this.getFocusedEditorIndex();
                if (index < 0) {
                    return null;
                }
                switch (index) {
                    case 0: {
                        return new BranchFocusedSide(FragmentSide.SIDE1);
                    }
                    case 1: {
                        return new MergeFocusedSide();
                    }
                    case 2: {
                        return new BranchFocusedSide(FragmentSide.SIDE2);
                    }
                }
            } else if (PlatformDataKeys.DIFF_VIEWER.is(dataId)) {
                return MergePanel2.this;
            }
            return super.getData(dataId);
        }

        private int getFocusedEditorIndex() {
            for (int i = 0; i < 3; ++i) {
                Editor editor = MergePanel2.this.getEditor(i);
                if (editor == null || !editor.getContentComponent().isFocusOwner()) continue;
                return i;
            }
            return -1;
        }
    }

    private class DiffEditorState
    extends EditorPlace.ComponentState {
        private final HashMap<EditorPlace.ViewProperty, Object> myProperties = new HashMap();
        private final int myIndex;

        private DiffEditorState(int index) {
            this.myIndex = index;
        }

        @Override
        public Editor createEditor() {
            Document document = this.getDocument();
            if (document == null) {
                return null;
            }
            Project project = MergePanel2.this.myData.getProject();
            EditorEx editor = DiffUtil.createEditor(document, project, this.myIndex != 1);
            if (editor == null) {
                return editor;
            }
            if (this.myIndex == 0) {
                editor.setVerticalScrollbarOrientation(0);
            }
            if (this.myIndex != 1) {
                ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
            }
            editor.getSettings().setFoldingOutlineShown(false);
            ((FoldingModelEx)editor.getFoldingModel()).setFoldingEnabled(false);
            HashSet notProcessedDefaults = new HashSet(ALL_PROPERTIES);
            for (EditorPlace.ViewProperty viewProperty : this.myProperties.keySet()) {
                notProcessedDefaults.remove((Object)viewProperty);
                viewProperty.updateEditor(editor, this.myProperties.get((Object)viewProperty), this);
            }
            for (EditorPlace.ViewProperty viewProperty : notProcessedDefaults) {
                viewProperty.updateEditor(editor, null, this);
            }
            return editor;
        }

        @Override
        public <T> void updateValue(Editor editor, EditorPlace.ViewProperty<T> property, T value) {
            this.myProperties.put(property, value);
            property.updateEditor(editor, value, this);
        }

        public FileType getFileType() {
            return MergePanel2.this.getContentType();
        }

        public Project getProject() {
            return MergePanel2.this.myData == null ? null : MergePanel2.this.myData.getProject();
        }
    }

    private class MyScrollingPanel
    implements DiffPanelOutterComponent.ScrollingPanel {
        private MyScrollingPanel() {
        }

        @Override
        public void scrollEditors() {
            int line;
            Editor centerEditor = MergePanel2.this.getEditor(1);
            JComponent centerComponent = centerEditor.getContentComponent();
            if (centerComponent.isShowing()) {
                centerComponent.requestFocus();
            }
            int[] toLeft = this.getPrimaryBegginings(MergePanel2.this.myDividers[0].getPaint());
            int[] toRight = this.getPrimaryBegginings(MergePanel2.this.myDividers[1].getPaint());
            if (toLeft.length > 0 && toRight.length > 0) {
                line = Math.min(toLeft[0], toRight[0]);
            } else if (toLeft.length > 0) {
                line = toLeft[0];
            } else if (toRight.length > 0) {
                line = toRight[0];
            } else {
                return;
            }
            SyncScrollSupport.scrollEditor(centerEditor, line);
        }

        private int[] getPrimaryBegginings(DiffDividerPaint paint) {
            FragmentSide primarySide = paint.getLeftSide();
            LOG.assertTrue(MergePanel2.this.getEditor(1) == paint.getSides().getEditor(primarySide));
            return paint.getSides().getLineBlocks().getBegginings(primarySide);
        }
    }

    private class MyEditingSides
    implements EditingSides {
        private final FragmentSide mySide;

        private MyEditingSides(FragmentSide side) {
            this.mySide = side;
        }

        @Override
        public Editor getEditor(FragmentSide side) {
            return MergePanel2.this.getEditor(this.mySide.getIndex() + side.getIndex());
        }

        @Override
        public LineBlocks getLineBlocks() {
            return MergePanel2.this.myMergeList.getChanges(this.mySide).getLineBlocks();
        }
    }
}

