/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PsiElementsValidityState
implements ValidityState {
    private final Map<String, Long> myDependencies = new HashMap<String, Long>();

    public void addDependency(String key, Long value) {
        this.myDependencies.put(key, value);
    }

    public boolean equalsTo(ValidityState otherState) {
        return otherState instanceof PsiElementsValidityState && ((Object)this.myDependencies).equals(((PsiElementsValidityState)otherState).myDependencies);
    }

    public void save(DataOutput out) throws IOException {
        Set<Map.Entry<String, Long>> entries = this.myDependencies.entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<String, Long> entry : entries) {
            IOUtil.writeString((String)entry.getKey(), (DataOutput)out);
            out.writeLong(entry.getValue());
        }
    }

    public static PsiElementsValidityState load(DataInput input) throws IOException {
        int size = input.readInt();
        PsiElementsValidityState state = new PsiElementsValidityState();
        while (size-- > 0) {
            String s = CompilerIOUtil.readString(input);
            long timestamp = input.readLong();
            state.addDependency(s, timestamp);
        }
        return state;
    }

    public void addDependency(PsiElement element) {
        VirtualFile file;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (file = psiFile.getVirtualFile()) != null) {
            this.addDependency(file.getUrl(), file.getTimeStamp());
        }
    }
}

