/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationModel;
import com.intellij.notification.impl.NotificationModelListener;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfiguration;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsManagerImpl
extends NotificationsManager
implements Notifications,
ApplicationComponent {
    private NotificationModel myModel = new NotificationModel();
    private static final PairFunction<Notification, Project, Boolean> ALL = new PairFunction<Notification, Project, Boolean>(){

        @NotNull
        public Boolean fun(Notification notification, Project project) {
            Boolean bl = true;
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationsManagerImpl$1.fun must not return null");
            }
            return bl;
        }
    };
    private static final PairFunction<Notification, Project, Boolean> APPLICATION = new PairFunction<Notification, Project, Boolean>(){

        @NotNull
        public Boolean fun(Notification notification, Project project) {
            Boolean bl = project == null;
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationsManagerImpl$2.fun must not return null");
            }
            return bl;
        }
    };

    @NotNull
    public String getComponentName() {
        if ("NotificationsManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationsManagerImpl.getComponentName must not return null");
        }
        return "NotificationsManager";
    }

    public void initComponent() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TOPIC, (Object)this);
    }

    public static NotificationsManagerImpl getNotificationsManagerImpl() {
        return (NotificationsManagerImpl)((Object)ApplicationManager.getApplication().getComponent(NotificationsManager.class));
    }

    public void notify(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.notify must not be null");
        }
        this.doNotify(notification, NotificationDisplayType.BALLOON);
    }

    public void notify(@NotNull Notification notification, @NotNull NotificationDisplayType defaultDisplayType) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.notify must not be null");
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.notify must not be null");
        }
        this.doNotify(notification, defaultDisplayType);
    }

    public void expire(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.expire must not be null");
        }
        this.remove(notification);
    }

    public <T extends Notification> T[] getNotificationsOfType(Class<T> klass, @Nullable Project project) {
        List<Notification> notifications = this.getModel().getByType(null, NotificationsManagerImpl.createFilter(project, false));
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification notification : notifications) {
            if (!klass.isInstance(notification)) continue;
            result.add(notification);
        }
        return (Notification[])ArrayUtil.toObjectArray(result, klass);
    }

    public void clear(@Nullable Project project) {
        this.myModel.clear(NotificationsManagerImpl.createFilter(project, true));
    }

    public void markRead() {
        this.myModel.markRead();
    }

    public NotificationModel getModel() {
        return this.myModel;
    }

    public void disposeComponent() {
        this.myModel.clear(ALL);
    }

    protected void doNotify(@NotNull Notification notification, @Nullable NotificationDisplayType displayType) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.doNotify must not be null");
        }
        this.doNotify(notification, displayType, null);
    }

    public void doNotify(@NotNull Notification notification, @Nullable NotificationDisplayType displayType, @Nullable Project project) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.doNotify must not be null");
        }
        NotificationsConfiguration configuration = NotificationsConfiguration.getNotificationsConfiguration();
        if (!configuration.isRegistered(notification.getGroupId())) {
            configuration.register(notification.getGroupId(), displayType == null ? NotificationDisplayType.BALLOON : displayType);
        }
        this.myModel.add(notification, project);
        NotificationsManagerImpl.showNotification(notification, project);
    }

    public static void showNotification(Notification notification, @Nullable Project project) {
        NotificationSettings settings = NotificationsConfiguration.getSettings(notification.getGroupId());
        switch (settings.getDisplayType()) {
            case NONE: {
                return;
            }
        }
        NotificationsManagerImpl.notifyByBalloon(notification, settings.getDisplayType(), project);
    }

    private static void notifyByBalloon(final Notification notification, NotificationDisplayType displayType, final @Nullable Project project) {
        JEditorPane text = new JEditorPane();
        text.setEditorKit(UIUtil.getHTMLEditorKit());
        HyperlinkListener listener = NotificationsUtil.wrapListener(notification);
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        text.setText(NotificationsUtil.buildHtml(notification));
        JLabel label = new JLabel(text.getText());
        Dimension size = label.getPreferredSize();
        text.setEditable(false);
        text.setOpaque(false);
        text.setBorder(null);
        text.setPreferredSize(size);
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        textWrapper.add((Component)text);
        content.add((Component)textWrapper, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(NotificationsUtil.getIcon(notification)), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content);
        builder.setFillColor(NotificationsUtil.getBackground(notification)).setCloseButtonEnabled(true).setShowCallout(false).setHideOnClickOutside(NotificationDisplayType.BALLOON == displayType).setHideOnKeyOutside(NotificationDisplayType.BALLOON == displayType).setHideOnFrameResize(false);
        if (NotificationDisplayType.BALLOON == displayType) {
            builder.setFadeoutTime(3000L);
        }
        final Balloon balloon = builder.createBalloon();
        balloon.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                notification.setBalloon(null);
            }
        });
        notification.setBalloon(balloon);
        final Runnable show = new Runnable(){

            @Override
            public void run() {
                Frame window = null;
                if (project != null) {
                    window = WindowManager.getInstance().getFrame(project);
                }
                if (window == null) {
                    window = JOptionPane.getRootFrame();
                }
                if (window instanceof IdeFrameImpl) {
                    BalloonLayout balloonLayout = ((IdeFrameImpl)window).getBalloonLayout();
                    balloonLayout.add(balloon);
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                show.run();
            }
        });
    }

    private static void notifyByExternal(Notification notification) {
        SystemNotifications service = (SystemNotifications)ServiceManager.getService(SystemNotifications.class);
        if (service != null) {
            service.notify(notification.getGroupId(), notification.getTitle(), notification.getContent());
        }
    }

    private static PairFunction<Notification, Project, Boolean> createFilter(@Nullable Project project, boolean strict) {
        return project == null ? APPLICATION : new ProjectFilter(project, strict);
    }

    public boolean hasNotifications(@Nullable Project project) {
        return this.myModel.getCount(NotificationsManagerImpl.createFilter(project, false)) > 0;
    }

    public void removeListener(@NotNull NotificationModelListener notificationListener) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.removeListener must not be null");
        }
        this.myModel.removeListener(notificationListener);
    }

    public void addListener(@NotNull NotificationModelListener notificationListener) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.addListener must not be null");
        }
        this.myModel.addListener(notificationListener);
    }

    public int count(@Nullable Project project) {
        return this.myModel.getCount(NotificationsManagerImpl.createFilter(project, false));
    }

    @Nullable
    public Notification remove(Notification notification) {
        return this.myModel.remove(notification);
    }

    public void remove(@NotNull Notification[] notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.remove must not be null");
        }
        this.myModel.remove(notification);
    }

    public Collection<Notification> getByType(@Nullable NotificationType type, @Nullable Project project) {
        return this.myModel.getByType(type, NotificationsManagerImpl.createFilter(project, false));
    }

    @Nullable
    public NotificationType getMaximumType(@Nullable Project project) {
        return this.myModel.getMaximumType(NotificationsManagerImpl.createFilter(project, false));
    }

    public boolean hasUnread(@Nullable Project project) {
        return this.myModel.hasUnread(NotificationsManagerImpl.createFilter(project, false));
    }

    public boolean hasRead(@Nullable Project project) {
        return this.myModel.hasRead(NotificationsManagerImpl.createFilter(project, false));
    }

    public boolean wasRead(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl.wasRead must not be null");
        }
        return this.myModel.wasRead(notification);
    }

    private static class ProjectFilter
    implements PairFunction<Notification, Project, Boolean> {
        private Project myProject;
        private boolean myStrict;

        private ProjectFilter(@NotNull Project project, boolean strict) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsManagerImpl$ProjectFilter.<init> must not be null");
            }
            this.myProject = project;
            this.myStrict = strict;
        }

        @NotNull
        public Boolean fun(Notification notification, Project project) {
            Boolean bl = this.myStrict ? project == this.myProject : project == null || project == this.myProject;
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationsManagerImpl$ProjectFilter.fun must not return null");
            }
            return bl;
        }
    }
}

