/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.reporter.ConnectionException;
import com.intellij.idea.CommandLineApplication;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.ui.Splash;
import com.intellij.util.messages.MessageBus;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IdeaApplication {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.IdeaApplication");
    protected final String[] myArgs;
    private boolean myPerformProjectLoad = true;
    private static IdeaApplication ourInstance;
    private ApplicationStarter myStarter;
    @NonNls
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";

    public IdeaApplication(String[] args) {
        LOG.assertTrue(ourInstance == null);
        ourInstance = this;
        this.myArgs = args;
        boolean isInternal = Boolean.valueOf(System.getProperty(IDEA_IS_INTERNAL_PROPERTY));
        if (Main.isCommandLine((String[])args)) {
            new CommandLineApplication(isInternal, false, Main.isHeadless((String[])args));
        } else {
            System.setProperty("sun.awt.noerasebackground", "true");
            ApplicationManagerEx.createApplication(isInternal, false, false, false, "idea");
        }
        this.myStarter = this.getStarter();
        this.myStarter.premain(args);
    }

    protected ApplicationStarter getStarter() {
        if (this.myArgs.length > 0) {
            Application app = ApplicationManager.getApplication();
            app.getPlugins();
            ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.appStarter");
            ApplicationStarter[] starters = (ApplicationStarter[])point.getExtensions();
            String key = this.myArgs[0];
            for (ApplicationStarter o : starters) {
                if (!Comparing.equal((String)o.getCommandName(), (String)key)) continue;
                return o;
            }
        }
        return new IdeStarter();
    }

    public static IdeaApplication getInstance() {
        return ourInstance;
    }

    public void run() {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        try {
            app.load(PathManager.getOptionsPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidDataException e) {
            e.printStackTrace();
        }
        this.myStarter.main(this.myArgs);
        this.myStarter = null;
    }

    private static void initLAF() {
        if (SystemInfo.isMac) {
            UIManager.put("Panel.opaque", Boolean.TRUE);
            UIManager.installLookAndFeel("Quaqua", "ch.randelshofer.quaqua.QuaquaLookAndFeel");
        } else {
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Windows L&F", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        }
    }

    private void loadProject() {
        Project project = null;
        if (this.myArgs != null && this.myArgs.length > 0 && this.myArgs[0] != null) {
            project = ProjectUtil.openOrImport(this.myArgs[0], null, false);
        }
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        ((AppLifecycleListener)bus.syncPublisher(AppLifecycleListener.TOPIC)).appStarting(project);
    }

    public String[] getCommandLineArguments() {
        return this.myArgs;
    }

    public void setPerformProjectLoad(boolean performProjectLoad) {
        this.myPerformProjectLoad = performProjectLoad;
    }

    protected class IdeStarter
    implements ApplicationStarter {
        private Splash mySplash;

        protected IdeStarter() {
        }

        public String getCommandName() {
            return null;
        }

        public void premain(String[] args) {
            if (StartupUtil.shouldShowSplash(args)) {
                ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
                Object splashScreen = this.getSplashScreen();
                if (splashScreen == null) {
                    final Splash splash = new Splash(appInfo.getLogoUrl(), appInfo.getLogoTextColor());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            splash.show();
                        }
                    });
                    this.mySplash = splash;
                } else {
                    this.updateSplashScreen(appInfo, splashScreen);
                }
            }
            IdeaApplication.initLAF();
        }

        private void updateSplashScreen(ApplicationInfoEx appInfo, Object splashScreen) {
            try {
                Class<?> aClass = splashScreen.getClass();
                Graphics2D graphics = (Graphics2D)aClass.getMethod("createGraphics", new Class[0]).invoke(splashScreen, new Object[0]);
                Dimension size = (Dimension)aClass.getMethod("getSize", new Class[0]).invoke(splashScreen, new Object[0]);
                if (Splash.showLicenseeInfo(graphics, 0, 0, size.height, appInfo.getLogoTextColor())) {
                    aClass.getMethod("update", new Class[0]).invoke(splashScreen, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }

        @Nullable
        private Object getSplashScreen() {
            try {
                Class<?> aClass = Class.forName("java.awt.SplashScreen");
                return aClass.getMethod("getSplashScreen", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void main(String[] args) {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            ((WindowManagerImpl)WindowManager.getInstance()).showFrame(args);
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (IdeStarter.this.mySplash != null) {
                        IdeStarter.this.mySplash.dispose();
                        IdeStarter.this.mySplash = null;
                    }
                }
            }, ModalityState.NON_MODAL);
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (UpdateChecker.isMyVeryFirstOpening() && UpdateChecker.checkNeeded()) {
                        try {
                            UpdateChecker.setMyVeryFirstOpening(false);
                            UpdateChannel newVersion = UpdateChecker.checkForUpdates();
                            List<PluginDownloader> updatedPlugins = UpdateChecker.updatePlugins(false);
                            if (newVersion != null) {
                                UpdateChecker.showUpdateInfoDialog(true, newVersion, updatedPlugins);
                            } else if (updatedPlugins != null) {
                                UpdateChecker.showNoUpdatesDialog(true, updatedPlugins);
                            }
                        }
                        catch (ConnectionException connectionException) {
                            // empty catch block
                        }
                    }
                    if (IdeaApplication.this.myPerformProjectLoad) {
                        IdeaApplication.this.loadProject();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginManager.reportPluginError();
                        }
                    });
                }
            }, ModalityState.NON_MODAL);
        }
    }
}

