/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkForModuleStep
extends ModuleWizardStep {
    private static final Icon NEW_PROJECT_ICON = IconLoader.getIcon((String)"/newprojectwizard.png");
    private final JdkChooserPanel myJdkChooser;
    private final JPanel myPanel;
    private final WizardContext myContext;
    private final SdkType myType;
    private boolean myInitialized = false;

    public ProjectJdkForModuleStep(final WizardContext context, final SdkType type) {
        this.myContext = context;
        this.myType = type;
        this.myJdkChooser = new JdkChooserPanel(ProjectJdkForModuleStep.getProject(context, type));
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel label = new JLabel(IdeBundle.message((String)"prompt.please.select.module.jdk", (Object[])new Object[]{type.getPresentableName()}));
        label.setUI((LabelUI)new MultiLineLabelUI());
        this.myPanel.add((Component)label, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 8, 10), 0, 0));
        JLabel jdklabel = new JLabel(IdeBundle.message((String)"label.project.jdk", (Object[])new Object[0]));
        jdklabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.myPanel.add((Component)jdklabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, new Insets(8, 10, 0, 10), 0, 0));
        this.myPanel.add((Component)this.myJdkChooser, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 10, 10, 5), 0, 0));
        JButton configureButton = new JButton(IdeBundle.message((String)"button.configure", (Object[])new Object[0]));
        this.myPanel.add((Component)configureButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 0, new Insets(2, 0, 10, 5), 0, 0));
        configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = ProjectJdkForModuleStep.getProject(context, type);
                ProjectStructureConfigurable projectConfig = ProjectStructureConfigurable.getInstance(project);
                final JdkListConfigurable jdkConfig = JdkListConfigurable.getInstance(project);
                ProjectJdksModel projectJdksModel = projectConfig.getProjectJdksModel();
                final boolean[] successfullyAdded = new boolean[1];
                projectJdksModel.doAdd(type, ProjectJdkForModuleStep.this.myPanel, new Consumer<Sdk>(){

                    public void consume(Sdk jdk) {
                        successfullyAdded[0] = jdkConfig.addJdkNode(jdk, false);
                        ProjectJdkForModuleStep.this.myJdkChooser.updateList(jdk, type);
                    }
                });
                if (!successfullyAdded[0]) {
                    try {
                        projectJdksModel.apply(jdkConfig);
                    }
                    catch (ConfigurationException e1) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Nullable
    private static Project getProject(WizardContext context, SdkType type) {
        Project project = context.getProject();
        if (type != null && project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return project;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkChooser.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "project.new.page2";
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        this.myContext.setProjectJdk(this.getJdk());
    }

    public void updateStep() {
        if (!this.myInitialized) {
            this.myJdkChooser.fillList(this.myType);
            Sdk defaultJdk = ProjectJdkForModuleStep.getDefaultJdk();
            if (defaultJdk != null) {
                this.myJdkChooser.selectJdk(defaultJdk);
            }
            this.myInitialized = true;
        }
    }

    public Sdk getJdk() {
        return this.myJdkChooser.getChosenJdk();
    }

    public Icon getIcon() {
        return NEW_PROJECT_ICON;
    }

    @Nullable
    private static Sdk getDefaultJdk() {
        Project defaultProject = ProjectManagerEx.getInstanceEx().getDefaultProject();
        return ProjectRootManagerEx.getInstanceEx(defaultProject).getProjectJdk();
    }

    public boolean validate() {
        int result;
        Sdk jdk = this.myJdkChooser.getChosenJdk();
        return jdk != null || (result = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }
}

