/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@Deprecated
public class ModuleTypeStep
extends ModuleWizardStep {
    private final JPanel myPanel;
    private final JRadioButton myRbCreateNewModule;
    private final JRadioButton myRbImportModule;
    private final FieldPanel myModulePathFieldPanel;
    private final JList myTypesList;
    private final JEditorPane myModuleDescriptionPane;
    private ModuleType myModuleType = StdModuleTypes.JAVA;
    private Runnable myDoubleClickAction = null;
    final EventDispatcher<UpdateListener> myEventDispatcher = EventDispatcher.create(UpdateListener.class);
    private final ButtonGroup myButtonGroup;

    public ModuleTypeStep(boolean createNewProject) {
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        this.myModuleDescriptionPane = new JEditorPane();
        this.myModuleDescriptionPane.setContentType("text/html");
        this.myModuleDescriptionPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserUtil.launchBrowser((String)e.getURL().toString());
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
            }
        });
        this.myModuleDescriptionPane.setEditable(false);
        ModuleType[] allModuleTypes = ModuleTypeManager.getInstance().getRegisteredTypes();
        this.myTypesList = new JList<ModuleType>(allModuleTypes);
        this.myTypesList.setSelectionModel(new PermanentSingleSelectionModel());
        this.myTypesList.setCellRenderer(new ModuleTypesListCellRenderer());
        this.myTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ModuleType typeSelected = (ModuleType)ModuleTypeStep.this.myTypesList.getSelectedValue();
                ModuleTypeStep.this.myModuleType = typeSelected;
                ModuleTypeStep.this.myModuleDescriptionPane.setText("<html><body><font face=\"verdana\" size=\"-1\">" + typeSelected.getDescription() + "</font></body></html>");
                ((UpdateListener)ModuleTypeStep.this.myEventDispatcher.getMulticaster()).moduleTypeSelected(typeSelected);
            }
        });
        this.myTypesList.setSelectedIndex(0);
        this.myTypesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ModuleTypeStep.this.myDoubleClickAction != null && ModuleTypeStep.this.myTypesList.getSelectedValue() != null) {
                    ModuleTypeStep.this.myDoubleClickAction.run();
                }
            }
        });
        this.myRbCreateNewModule = new JRadioButton(IdeBundle.message((String)"radio.create.new.module", (Object[])new Object[0]), true);
        this.myRbImportModule = new JRadioButton(IdeBundle.message((String)"radio.import.existing.module", (Object[])new Object[0]));
        this.myButtonGroup = new ButtonGroup();
        this.myButtonGroup.add(this.myRbCreateNewModule);
        this.myButtonGroup.add(this.myRbImportModule);
        ModulesRbListener listener = new ModulesRbListener();
        this.myRbCreateNewModule.addItemListener(listener);
        this.myRbImportModule.addItemListener(listener);
        JTextField tfModuleFilePath = new JTextField();
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        this.myModulePathFieldPanel = ModuleTypeStep.createFieldPanel((JTextField)tfModuleFilePath, (String)IdeBundle.message((String)"label.path.to.module.file", (Object[])new Object[]{productName}), (BrowseFilesListener)new BrowseFilesListener(tfModuleFilePath, IdeBundle.message((String)"prompt.select.module.file.to.import", (Object[])new Object[]{productName}), null, (FileChooserDescriptor)new ModuleFileChooserDescriptor()));
        this.myModulePathFieldPanel.setEnabled(false);
        if (createNewProject) {
            JLabel moduleTypeLabel = new JLabel(IdeBundle.message((String)"label.select.module.type", (Object[])new Object[0]));
            moduleTypeLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
            this.myPanel.add((Component)moduleTypeLabel, LABEL_CONSTRAINT);
        } else {
            this.myPanel.add((Component)this.myRbCreateNewModule, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 10, 8, 10), 0, 0));
        }
        JLabel descriptionLabel = new JLabel(IdeBundle.message((String)"label.description", (Object[])new Object[0]));
        descriptionLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.myPanel.add((Component)descriptionLabel, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane typesListScrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTypesList);
        Dimension preferredSize = this.calcTypeListPreferredSize(allModuleTypes);
        typesListScrollPane.setPreferredSize(preferredSize);
        typesListScrollPane.setMinimumSize(preferredSize);
        this.myPanel.add((Component)typesListScrollPane, new GridBagConstraints(0, -1, 1, 1, 0.2, createNewProject ? 1.0 : 0.0, 18, 1, new Insets(0, createNewProject ? 10 : 30, 0, 10), 0, 0));
        JScrollPane descriptionScrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myModuleDescriptionPane);
        descriptionScrollPane.setPreferredSize(new Dimension(preferredSize.width * 3, preferredSize.height));
        this.myPanel.add((Component)descriptionScrollPane, new GridBagConstraints(1, -1, 1, 1, 0.8, createNewProject ? 1.0 : 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        if (!createNewProject) {
            this.myPanel.add((Component)this.myRbImportModule, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, new Insets(16, 10, 0, 10), 0, 0));
            this.myPanel.add((Component)this.myModulePathFieldPanel, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 2, new Insets(8, 30, 0, 10), 0, 0));
        }
    }

    private Dimension calcTypeListPreferredSize(ModuleType[] allModuleTypes) {
        int width = 0;
        int height = 0;
        FontMetrics fontMetrics = this.myTypesList.getFontMetrics(this.myTypesList.getFont());
        int fontHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        for (ModuleType type : allModuleTypes) {
            Icon icon = type.getBigIcon();
            int iconHeight = icon != null ? icon.getIconHeight() : 0;
            int iconWidth = icon != null ? icon.getIconWidth() : 0;
            height += Math.max(iconHeight, fontHeight) + 6;
            width = Math.max(width, iconWidth + fontMetrics.stringWidth(type.getName()) + 10);
        }
        return new Dimension(width, height);
    }

    public String getHelpId() {
        return "project.creatingModules.page1";
    }

    public void setModuleListDoubleClickAction(Runnable runnable) {
        this.myDoubleClickAction = runnable;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public Icon getIcon() {
        return ICON;
    }

    public boolean validate() {
        if (this.myRbImportModule.isSelected()) {
            String path = this.myModulePathFieldPanel.getText().trim();
            if (path.length() == 0) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.please.specify.path.to.module.file", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.module.file.path.not.specified", (Object[])new Object[0]));
                this.myModulePathFieldPanel.getTextField().requestFocus();
                return false;
            }
            File file = new File(path);
            if (!file.exists()) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.module.file.does.not.exist", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.module.file.does.not.exist", (Object[])new Object[0]));
                this.myModulePathFieldPanel.getTextField().requestFocus();
                return false;
            }
            if (!StdFileTypes.IDEA_MODULE.equals(FileTypeManager.getInstance().getFileTypeByFileName(file.getName()))) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.module.not.iml", (Object[])new Object[]{path, ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.incorrect.file.type", (Object[])new Object[0]));
                this.myModulePathFieldPanel.getTextField().requestFocus();
                return false;
            }
        }
        return true;
    }

    public boolean isNextButtonEnabled() {
        return !this.myRbImportModule.isSelected();
    }

    public boolean isCreateNewModule() {
        return this.myRbCreateNewModule.isSelected();
    }

    public boolean isImportExistingModule() {
        return this.myRbImportModule.isSelected();
    }

    public String getModuleFilePath() {
        return this.myModulePathFieldPanel.getText().trim().replace(File.separatorChar, '/');
    }

    public ModuleType getModuleType() {
        return this.myModuleType;
    }

    public void addUpdateListener(UpdateListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeUpdateListener(UpdateListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public void updateDataModel() {
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTypesList;
    }

    private void setControlsEnabled(ButtonModel selection) {
        boolean newModuleEnabled = selection == this.myRbCreateNewModule.getModel();
        this.myTypesList.setEnabled(newModuleEnabled);
        this.myModuleDescriptionPane.setEnabled(newModuleEnabled);
        boolean importModuleEnabled = selection == this.myRbImportModule.getModel();
        this.myModulePathFieldPanel.setEnabled(importModuleEnabled);
    }

    private static class PermanentSingleSelectionModel
    extends DefaultListSelectionModel {
        public PermanentSingleSelectionModel() {
            super.setSelectionMode(0);
        }

        @Override
        public final void setSelectionMode(int selectionMode) {
        }

        @Override
        public final void removeSelectionInterval(int index0, int index1) {
        }
    }

    private static class ModuleTypesListCellRenderer
    extends DefaultListCellRenderer {
        private ModuleTypesListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ModuleType moduleType = (ModuleType)value;
            this.setIcon(moduleType.getBigIcon());
            this.setDisabledIcon(moduleType.getBigIcon());
            this.setText(moduleType.getName());
            return rendererComponent;
        }
    }

    private static class ModuleFileChooserDescriptor
    extends FileChooserDescriptor {
        public ModuleFileChooserDescriptor() {
            super(true, false, false, false, false, false);
            this.setHideIgnored(false);
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            boolean isVisible = super.isFileVisible(file, showHiddenFiles);
            if (!isVisible || file.isDirectory()) {
                return isVisible;
            }
            return StdFileTypes.IDEA_MODULE.equals(FileTypeManager.getInstance().getFileTypeByFile(file));
        }
    }

    private class ModulesRbListener
    implements ItemListener {
        private ModulesRbListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JComponent toFocus;
            ButtonModel selection = ModuleTypeStep.this.myButtonGroup.getSelection();
            ModuleTypeStep.this.setControlsEnabled(selection);
            if (selection == ModuleTypeStep.this.myRbCreateNewModule.getModel()) {
                toFocus = ModuleTypeStep.this.myTypesList;
                ((UpdateListener)ModuleTypeStep.this.myEventDispatcher.getMulticaster()).importModuleOptionSelected(false);
            } else if (selection == ModuleTypeStep.this.myRbImportModule.getModel()) {
                toFocus = ModuleTypeStep.this.myModulePathFieldPanel.getTextField();
                ((UpdateListener)ModuleTypeStep.this.myEventDispatcher.getMulticaster()).importModuleOptionSelected(true);
            } else {
                toFocus = null;
            }
            if (toFocus != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        toFocus.requestFocus();
                    }
                });
            }
        }
    }

    public static interface UpdateListener
    extends EventListener {
        public void moduleTypeSelected(ModuleType var1);

        public void importModuleOptionSelected(boolean var1);
    }
}

