/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeFileChooserDialog
extends DialogWrapper
implements TreeFileChooser {
    private Tree myTree;
    private PsiFile mySelectedFile = null;
    private final Project myProject;
    private BaseProjectTreeBuilder myBuilder;
    private TabbedPaneWrapper myTabbedPane;
    private ChooseByNamePanel myGotoByNamePanel;
    @Nullable
    private final PsiFile myInitialFile;
    @Nullable
    private final TreeFileChooser.PsiFileFilter myFilter;
    @Nullable
    private final FileType myFileType;
    private final boolean myDisableStructureProviders;
    private final boolean myShowLibraryContents;

    public TreeFileChooserDialog(Project project, String title, final @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders, boolean showLibraryContents) {
        super(project, true);
        this.myInitialFile = initialFile;
        this.myFilter = filter;
        this.myFileType = fileType;
        this.myDisableStructureProviders = disableStructureProviders;
        this.myShowLibraryContents = showLibraryContents;
        this.setTitle(title);
        this.myProject = project;
        this.init();
        if (initialFile != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeFileChooserDialog.this.selectFile(initialFile);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
    }

    protected JComponent createCenterPanel() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isFlattenPackages() {
                return false;
            }

            @Override
            public boolean isShowMembers() {
                return false;
            }

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            @Override
            public Object[] getChildElements(Object element) {
                return TreeFileChooserDialog.this.filterFiles(super.getChildElements(element));
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return TreeFileChooserDialog.this.myShowLibraryContents;
            }

            public boolean isShowModules() {
                return false;
            }

            @Override
            public List<TreeStructureProvider> getProviders() {
                return TreeFileChooserDialog.this.myDisableStructureProviders ? null : super.getProviders();
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model, AlphaComparator.INSTANCE, treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize(new Dimension(500, 300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TreeFileChooserDialog.this.doOKAction();
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = TreeFileChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && TreeFileChooserDialog.this.myTree.isPathSelected(path)) {
                    TreeFileChooserDialog.this.doOKAction();
                }
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        if (this.myInitialFile != null) {
            name = this.myInitialFile.getName();
        }
        PsiFile context = this.myInitialFile == null ? null : this.myInitialFile;
        this.myGotoByNamePanel = new ChooseByNamePanel(this.myProject, new MyGotoFileModel(), name, true, (PsiElement)context){

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    TreeFileChooserDialog.this.doOKAction();
                } else {
                    TreeFileChooserDialog.this.doCancelAction();
                }
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)TreeFileChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
            }

            @Override
            protected void choosenElementMightChange() {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        };
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), scrollPane);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), dummyPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeFileChooserDialog.this.myGotoByNamePanel.invoke(new MyCallback(), ModalityState.stateForComponent((Component)TreeFileChooserDialog.this.getRootPane()), false);
            }
        });
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    private void handleSelectionChanged() {
        PsiFile selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    protected void doOKAction() {
        this.mySelectedFile = this.calcSelectedClass();
        if (this.mySelectedFile == null) {
            return;
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        this.mySelectedFile = null;
        super.doCancelAction();
    }

    public PsiFile getSelectedFile() {
        return this.mySelectedFile;
    }

    public void selectFile(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeFileChooserDialog.selectFile must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TreeFileChooserDialog.this.myBuilder != null) {
                    TreeFileChooserDialog.this.myBuilder.select(file, file.getVirtualFile(), true);
                }
            }
        }, ModalityState.stateForComponent((Component)this.getWindow()));
    }

    public void showDialog() {
        this.show();
    }

    private PsiFile calcSelectedClass() {
        if (this.myTabbedPane.getSelectedIndex() == 1) {
            return (PsiFile)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ProjectViewNode)) {
            return null;
        }
        ProjectViewNode pvNode = (ProjectViewNode)userObject;
        VirtualFile vFile = pvNode.getVirtualFile();
        if (vFile != null && !vFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        }
        return null;
    }

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeFileChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private Object[] filterFiles(Object[] list) {
        Condition<PsiFile> condition = new Condition<PsiFile>(){

            public boolean value(PsiFile psiFile) {
                if (TreeFileChooserDialog.this.myFilter != null && !TreeFileChooserDialog.this.myFilter.accept(psiFile)) {
                    return false;
                }
                return TreeFileChooserDialog.this.myFileType == null || psiFile.getFileType() == TreeFileChooserDialog.this.myFileType;
            }
        };
        ArrayList<Object> result = new ArrayList<Object>(list.length);
        for (Object o : list) {
            ProjectViewNode projectViewNode;
            Object psiFile = o instanceof PsiFile ? (PsiFile)o : (o instanceof PsiFileNode ? (PsiFile)((PsiFileNode)((Object)o)).getValue() : null);
            if (psiFile != null && !condition.value(psiFile) || o instanceof ProjectViewNode && !(projectViewNode = (ProjectViewNode)o).canHaveChildrenMatching((Condition)condition)) continue;
            result.add(o);
        }
        return ArrayUtil.toObjectArray(result);
    }

    private final class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            TreeFileChooserDialog.this.mySelectedFile = (PsiFile)element;
            TreeFileChooserDialog.this.close(0);
        }
    }

    private final class MyGotoFileModel
    implements ChooseByNameModel {
        private final int myMaxSize;

        private MyGotoFileModel() {
            this.myMaxSize = WindowManagerEx.getInstanceEx().getFrame((Project)((TreeFileChooserDialog)TreeFileChooserDialog.this).myProject).getSize().width;
        }

        public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
            Object[] psiFiles = FilenameIndex.getFilesByName(TreeFileChooserDialog.this.myProject, name, GlobalSearchScope.projectScope((Project)TreeFileChooserDialog.this.myProject));
            return TreeFileChooserDialog.this.filterFiles(psiFiles);
        }

        public String getPromptText() {
            return IdeBundle.message((String)"prompt.filechooser.enter.file.name", (Object[])new Object[0]);
        }

        public String getCheckBoxName() {
            return null;
        }

        public char getCheckBoxMnemonic() {
            return '\u0000';
        }

        public String getNotInMessage() {
            return "";
        }

        public String getNotFoundMessage() {
            return "";
        }

        public boolean loadInitialCheckBoxState() {
            return true;
        }

        public void saveInitialCheckBoxState(boolean state) {
        }

        public PsiElementListCellRenderer getListCellRenderer() {
            return new GotoFileCellRenderer(this.myMaxSize);
        }

        public String[] getNames(boolean checkBoxState) {
            String[] fileNames = FilenameIndex.getAllFilenames(TreeFileChooserDialog.this.myProject);
            THashSet array = new THashSet();
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (String fileName : fileNames) {
                if (TreeFileChooserDialog.this.myFileType != null && fileTypeManager.getFileTypeByFileName(fileName) != TreeFileChooserDialog.this.myFileType || array.contains(fileName)) continue;
                array.add(fileName);
            }
            Object[] result = ArrayUtil.toStringArray((Collection)array);
            Arrays.sort(result);
            return result;
        }

        public String getElementName(Object element) {
            if (!(element instanceof PsiFile)) {
                return null;
            }
            return ((PsiFile)element).getName();
        }

        @Nullable
        public String getFullName(Object element) {
            if (element instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
                return virtualFile != null ? virtualFile.getPath() : null;
            }
            return this.getElementName(element);
        }

        public String getHelpId() {
            return null;
        }

        @NotNull
        public String[] getSeparators() {
            String[] stringArray = new String[]{"/", "\\"};
            if (stringArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeFileChooserDialog$MyGotoFileModel.getSeparators must not return null");
            }
            return stringArray;
        }
    }
}

