/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneWrapper;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class StructureViewComposite
implements StructureView {
    @NotNull
    private final StructureViewDescriptor[] myStructureViews;
    @NotNull
    private StructureViewDescriptor mySelectedViewDescriptor;
    @NotNull
    private final TabbedPaneWrapper myTabbedPaneWrapper;

    public StructureViewComposite(StructureViewDescriptor ... views) {
        if (views == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/impl/StructureViewComposite.<init> must not be null");
        }
        this.myStructureViews = views;
        for (StructureViewDescriptor descriptor : views) {
            Disposer.register((Disposable)this, (Disposable)descriptor.structureView);
        }
        this.mySelectedViewDescriptor = views[0];
        this.myTabbedPaneWrapper = new TabbedPaneWrapper((Disposable)this);
        for (StructureViewDescriptor descriptor : views) {
            this.myTabbedPaneWrapper.addTab(descriptor.title, descriptor.icon, descriptor.structureView.getComponent(), null);
        }
        this.myTabbedPaneWrapper.setSelectedIndex(0);
        this.myTabbedPaneWrapper.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = StructureViewComposite.this.myTabbedPaneWrapper.getSelectedIndex();
                StructureViewComposite.this.mySelectedViewDescriptor = StructureViewComposite.this.myStructureViews[index];
            }
        });
    }

    public StructureView getSelectedStructureView() {
        return this.mySelectedViewDescriptor.structureView;
    }

    public void setStructureView(int index, StructureViewDescriptor view) {
        this.myStructureViews[index] = view;
        Disposer.register((Disposable)this, (Disposable)view.structureView);
    }

    public FileEditor getFileEditor() {
        return this.getSelectedStructureView().getFileEditor();
    }

    public boolean navigateToSelectedElement(boolean requestFocus) {
        return this.getSelectedStructureView().navigateToSelectedElement(requestFocus);
    }

    public JComponent getComponent() {
        return this.myTabbedPaneWrapper.getComponent();
    }

    public void dispose() {
    }

    public void centerSelectedRow() {
        this.getSelectedStructureView().centerSelectedRow();
    }

    public void restoreState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.restoreState();
        }
    }

    public void storeState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.storeState();
        }
    }

    @NotNull
    public StructureViewDescriptor[] getStructureViews() {
        if (this.myStructureViews == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/StructureViewComposite.getStructureViews must not return null");
        }
        return this.myStructureViews;
    }

    public StructureViewModel getTreeModel() {
        return this.getSelectedStructureView().getTreeModel();
    }

    public static class StructureViewDescriptor {
        public final String title;
        public final StructureView structureView;
        public final Icon icon;

        public StructureViewDescriptor(String title, @NotNull StructureView structureView, Icon icon) {
            if (structureView == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/structureView/impl/StructureViewComposite$StructureViewDescriptor.<init> must not be null");
            }
            this.title = title;
            this.structureView = structureView;
            this.icon = icon;
        }
    }
}

