/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class SelectInNavBarTarget
extends SelectInTargetPsiWrapper
implements DumbAware {
    public SelectInNavBarTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.NAV_BAR;
    }

    @NonNls
    public String getToolWindowId() {
        return "NavBar";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 8.0f;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file) {
        return UISettings.getInstance().SHOW_NAVIGATION_BAR;
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(this.myProject);
        SelectInNavBarTarget.navBar(frame).select();
    }

    private static NavBarPanel navBar(IdeFrameImpl frame) {
        return (NavBarPanel)SelectInNavBarTarget.navBarComponent(frame).getClientProperty("NavBarPanel");
    }

    private static JComponent navBarComponent(IdeFrameImpl frame) {
        return ((IdeRootPane)frame.getRootPane()).findByName("NavBar").getComponent();
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    @Override
    protected void select(PsiElement element, boolean requestFocus) {
        IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(this.myProject);
        SelectInNavBarTarget.navBar(frame).select();
    }
}

