/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DropTargetHighlighter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Highlighters
implements DnDEvent.DropTargetHighlightingType {
    private static final List<Accessible> ourHightlighters = new ArrayList<Accessible>();
    private static final List<DropTargetHighlighter> ourCurrentHighlighters = new ArrayList<DropTargetHighlighter>();

    static void show(int aType, JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
        ArrayList<DropTargetHighlighter> toShow = new ArrayList<DropTargetHighlighter>();
        for (Accessible ourHightlighter : ourHightlighters) {
            DropTargetHighlighter each = (DropTargetHighlighter)((Object)ourHightlighter);
            if ((each.getMask() & aType) == 0) continue;
            toShow.add(each);
        }
        for (int i = 0; i < toShow.size(); ++i) {
            DropTargetHighlighter each = (DropTargetHighlighter)toShow.get(i);
            each.show(aPane, aRectangle, aEvent);
        }
        ourCurrentHighlighters.addAll(toShow);
    }

    static void hideAllBut(int aType) {
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            DropTargetHighlighter each = ourCurrentHighlighters.get(i);
            if ((each.getMask() & aType) != 0) continue;
            each.vanish();
            ourCurrentHighlighters.remove(each);
        }
    }

    static void hide() {
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            ourCurrentHighlighters.get(i).vanish();
        }
        ourCurrentHighlighters.clear();
    }

    static void hide(int aType) {
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            DropTargetHighlighter each = ourCurrentHighlighters.get(i);
            if ((each.getMask() & aType) == 0) continue;
            each.vanish();
            ourCurrentHighlighters.remove(each);
        }
    }

    static boolean isVisibleExcept(int type) {
        int resultType = type;
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            DropTargetHighlighter each = ourCurrentHighlighters.get(i);
            resultType |= each.getMask();
        }
        return type != resultType;
    }

    static boolean isVisible() {
        return ourCurrentHighlighters.size() > 0;
    }

    static {
        ourHightlighters.add(new RectangleHighlighter());
        ourHightlighters.add(new FilledRectangleHighlighter());
        ourHightlighters.add(new HorizontalLinesHighlighter());
        ourHightlighters.add(new TextHighlighter());
        ourHightlighters.add(new ErrorTextHighlighter());
        ourHightlighters.add(new VerticalLinesHighlighter());
    }

    private static class VerticalLinesHighlighter
    extends AbstractComponentHighlighter {
        private final Icon myTop = IconLoader.getIcon((String)"/ide/dnd/top.png");
        private final Icon myBottom = IconLoader.getIcon((String)"/ide/dnd/bottom.png");

        private VerticalLinesHighlighter() {
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            Rectangle rectangle = new Rectangle(aRectangle.x, aRectangle.y - this.myTop.getIconHeight(), aRectangle.width, aRectangle.height + this.myTop.getIconHeight() + this.myBottom.getIconHeight());
            this.setBounds(rectangle);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myTop.paintIcon(this, g, (this.getWidth() - this.myTop.getIconWidth()) / 2, 0);
            this.myBottom.paintIcon(this, g, (this.getWidth() - this.myBottom.getIconWidth()) / 2, this.getHeight() - this.myBottom.getIconHeight());
        }

        @Override
        public int getMask() {
            return 8;
        }
    }

    private static class HorizontalLinesHighlighter
    extends AbstractComponentHighlighter {
        private final Icon myLeft = IconLoader.getIcon((String)"/ide/dnd/left.png");
        private final Icon myRight = IconLoader.getIcon((String)"/ide/dnd/right.png");

        private HorizontalLinesHighlighter() {
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            Rectangle rectangle = new Rectangle(aRectangle.x - this.myLeft.getIconWidth(), aRectangle.y - this.myLeft.getIconHeight(), aRectangle.width + this.myLeft.getIconWidth() + this.myRight.getIconWidth(), aRectangle.height + this.myLeft.getIconHeight());
            this.setBounds(rectangle);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myLeft.paintIcon(this, g, 0, this.getHeight() / 2);
            this.myRight.paintIcon(this, g, this.getWidth() - this.myRight.getIconWidth(), this.getHeight() / 2);
        }

        @Override
        public int getMask() {
            return 4;
        }
    }

    private static class RectangleHighlighter
    extends AbstractComponentHighlighter {
        public RectangleHighlighter() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createLineBorder(Color.red));
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            this.setBounds(aRectangle);
        }

        @Override
        public int getMask() {
            return 1;
        }
    }

    private static class FilledRectangleHighlighter
    extends AbstractComponentHighlighter {
        public FilledRectangleHighlighter() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(Color.red));
            this.setBackground(Color.red);
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            this.setBounds(aRectangle);
        }

        @Override
        public int getMask() {
            return 2;
        }
    }

    private static class ErrorTextHighlighter
    extends BaseTextHighlighter {
        public ErrorTextHighlighter() {
            this.myLabel.setIcon(IconLoader.getIcon((String)"/ide/dnd/error.png"));
        }

        @Override
        public int getMask() {
            return 32;
        }
    }

    private static class TextHighlighter
    extends BaseTextHighlighter {
        private TextHighlighter() {
        }

        @Override
        public int getMask() {
            return 16;
        }
    }

    private static abstract class BaseTextHighlighter
    extends JWindow
    implements DropTargetHighlighter {
        protected JLabel myLabel = new JLabel("", 0){

            @Override
            protected void paintComponent(Graphics g) {
                BaseTextHighlighter.this.paintComponent(g);
                super.paintComponent(g);
            }
        };

        public BaseTextHighlighter() {
            this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
            this.myLabel.setForeground(UIManager.getColor("ToolTip.foreground"));
            this.setFocusable(false);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.myLabel, "Center");
        }

        @Override
        public void show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            this.myLabel.setText(aEvent.getExpectedDropResult());
            Dimension prefSize = this.getPreferredSize();
            prefSize.width += 10;
            prefSize.height += 4;
            int centerX = aRectangle.x + aRectangle.width / 2;
            Rectangle newBounds = new Rectangle(centerX - prefSize.width / 2, aRectangle.y - prefSize.height - 5, prefSize.width, prefSize.height);
            newBounds.y = newBounds.y < 0 ? 0 : newBounds.y;
            Point location = newBounds.getLocation();
            SwingUtilities.convertPointToScreen(location, aPane);
            newBounds.setLocation(location);
            this.setBounds(newBounds);
            this.show();
            if (SystemInfo.isUnix) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseTextHighlighter.this.toFront();
                    }
                });
            }
        }

        @Override
        public void vanish() {
            this.hide();
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Object old = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(UIManager.getColor("ToolTip.background"));
            g.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, 6, 6);
            g.setColor(UIManager.getColor("ToolTip.foreground"));
            g.drawRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, 6, 6);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }

        protected Integer getLayer() {
            return JLayeredPane.POPUP_LAYER;
        }
    }

    private static abstract class AbstractComponentHighlighter
    extends JPanel
    implements DropTargetHighlighter {
        protected AbstractComponentHighlighter() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
        }

        @Override
        public final void show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            if (this.getParent() != aPane) {
                this.vanish();
                aPane.add((Component)this, this.getLayer());
            }
            this._show(aPane, aRectangle, aEvent);
        }

        protected Integer getLayer() {
            return JLayeredPane.MODAL_LAYER;
        }

        @Override
        public void vanish() {
            Container parent = this.getParent();
            Rectangle bounds = this.getBounds();
            if (parent != null) {
                parent.remove(this);
                parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }

        protected abstract void _show(JLayeredPane var1, Rectangle var2, DnDEvent var3);
    }
}

