/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.firefox;

import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.firefox.FirefoxProfile;
import com.intellij.ide.browsers.firefox.FirefoxSettingsConfigurable;
import com.intellij.ide.browsers.firefox.FirefoxUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirefoxSettings
extends BrowserSpecificSettings {
    private String myProfilesIniPath;
    private String myProfile;

    public FirefoxSettings() {
    }

    public FirefoxSettings(String profilesIniPath, String profile) {
        this.myProfilesIniPath = profilesIniPath;
        this.myProfile = profile;
    }

    @Tag(value="profiles-ini-path")
    @Nullable
    public String getProfilesIniPath() {
        return this.myProfilesIniPath;
    }

    public void setProfilesIniPath(String profilesIniPath) {
        this.myProfilesIniPath = profilesIniPath;
    }

    @Tag(value="profile")
    @Nullable
    public String getProfile() {
        return this.myProfile;
    }

    public void setProfile(String profile) {
        this.myProfile = profile;
    }

    @Override
    public Configurable createConfigurable() {
        return new FirefoxSettingsConfigurable(this);
    }

    @Nullable
    public File getProfilesIniFile() {
        if (this.myProfilesIniPath != null) {
            return new File(FileUtil.toSystemDependentName((String)this.myProfilesIniPath));
        }
        return FirefoxUtil.getDefaultProfileIniPath();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String[] getAdditionalParameters() {
        String[] stringArray;
        FirefoxProfile profile;
        List<FirefoxProfile> profiles = FirefoxUtil.computeProfiles(this.getProfilesIniFile());
        if (profiles.size() >= 2 && (profile = FirefoxUtil.findProfileByNameOrDefault(this.myProfile, profiles)) != null) {
            stringArray = new String[]{"-P", profile.getName()};
            if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/browsers/firefox/FirefoxSettings.getAdditionalParameters must not return null");
            return stringArray;
        }
        stringArray = super.getAdditionalParameters();
        if (stringArray != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/browsers/firefox/FirefoxSettings.getAdditionalParameters must not return null");
    }
}

