/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public abstract class ToggleNumberedBookmarkActionBase
extends AnAction
implements DumbAware {
    private int myNumber;

    public ToggleNumberedBookmarkActionBase(int n) {
        this.myNumber = n;
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project;
        DataContext dataContext = e.getDataContext();
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(dataContext, project = (Project)PlatformDataKeys.PROJECT.getData(dataContext)).invoke();
        if (info.getFile() == null) {
            return;
        }
        Bookmark oldBookmark = info.getBookmarkAtPlace();
        BookmarkManager manager = BookmarkManager.getInstance(project);
        if (oldBookmark != null) {
            manager.removeBookmark(oldBookmark);
        }
        if (oldBookmark == null || oldBookmark.getMnemonic() != 48 + this.myNumber) {
            Bookmark bookmark = manager.addTextBookmark(info.getFile(), info.getLine(), "");
            manager.setMnemonic(bookmark, (char)(48 + this.myNumber));
        }
    }
}

