/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.io.FileTypeFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class OpenFileAction
extends AnAction
implements DumbAware {
    private static String getLastFilePath(Project project) {
        return PropertiesComponent.getInstance((Project)project).getValue("last_opened_file_path");
    }

    private static void setLastFilePath(Project project, String path) {
        PropertiesComponent.getInstance((Project)project).setValue("last_opened_file_path", path);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null && PlatformProjectOpenProcessor.getInstanceIfItExists() == null) {
            return;
        }
        String lastFilePath = project != null ? OpenFileAction.getLastFilePath(project) : "";
        JFileChooser fileChooser = new JFileChooser(lastFilePath);
        FileView fileView = new FileView(){

            @Override
            public Icon getIcon(File f) {
                if (f.isDirectory()) {
                    return super.getIcon(f);
                }
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(f.getName());
                if (fileType == UnknownFileType.INSTANCE || fileType == NativeFileType.INSTANCE) {
                    return super.getIcon(f);
                }
                return fileType.getIcon();
            }
        };
        fileChooser.setFileView(fileView);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(IdeBundle.message((String)"title.open.file", (Object[])new Object[0]));
        FileFilter allFilesFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return IdeBundle.message((String)"filter.all.file.types", (Object[])new Object[0]);
            }
        };
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        ArrayList<FileType> list = new ArrayList<FileType>();
        for (FileType ft : fileTypeManager.getRegisteredFileTypes()) {
            if (fileTypeManager.getAssociatedExtensions(ft).length <= 0 || !(ft instanceof ProjectFileType) && ft.isReadOnly()) continue;
            list.add(ft);
        }
        Collections.sort(list, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (FileType ft : list) {
            fileChooser.addChoosableFileFilter(new FileTypeFilter(ft));
        }
        fileChooser.addChoosableFileFilter(allFilesFilter);
        fileChooser.setFileFilter(allFilesFilter);
        if (fileChooser.showOpenDialog(WindowManager.getInstance().suggestParentWindow(project)) != 0) {
            return;
        }
        File[] files = fileChooser.getSelectedFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            int answer;
            if (project != null) {
                OpenFileAction.setLastFilePath(project, file.getParent());
            }
            if (OpenFileAction.isProjectFile(file) && (answer = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"message.open.file.is.project", (Object[])new Object[]{file.getName(), ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
                ProjectUtil.openProject(file.getAbsolutePath(), project, false);
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file.getName());
            if (type == null) {
                return;
            }
            String absolutePath = file.getAbsolutePath();
            if (project != null) {
                OpenFileAction.openFile(absolutePath, project);
                continue;
            }
            VirtualFile vfile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vfile == null) continue;
            PlatformProjectOpenProcessor.getInstance().doOpenProject(vfile, null, false);
        }
    }

    public static void openFile(String absolutePath, Project project) {
        final String correctPath = absolutePath.replace(File.separatorChar, '/');
        final VirtualFile[] virtualFiles = new VirtualFile[1];
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                virtualFiles[0] = LocalFileSystem.getInstance().refreshAndFindFileByPath(correctPath);
            }
        });
        if (virtualFiles[0] == null) {
            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.file.does.not.exist", (Object[])new Object[]{absolutePath}), (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]));
            return;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        if (editorProviderManager.getProviders(project, virtualFiles[0]).length == 0) {
            Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"error.files.of.this.type.cannot.be.opened", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFiles[0]);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    public static boolean isProjectFile(File file) {
        return FileTypeManager.getInstance().getFileTypeByFileName(file.getName()) instanceof ProjectFileType;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        presentation.setEnabled(project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null);
    }
}

