/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;

public class GotoClassAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        assert (project != null);
        if (DumbService.getInstance((Project)project).isDumb()) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Goto Class action is not available until indices are built, using Goto File instead");
            myInAction = null;
            new GotoFileAction().gotoActionPerformed(e);
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.class");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup(project, new GotoClassModel2(project), GotoClassAction.getPsiContext(e));
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                if (GotoClassAction.class.equals((Object)GotoActionBase.myInAction)) {
                    GotoActionBase.myInAction = null;
                }
            }

            public void elementChosen(Object element) {
                if (element instanceof PsiElement) {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)element);
                } else {
                    ((NavigationItem)element).navigate(true);
                }
            }
        }, ModalityState.current(), true);
    }

    @Override
    protected boolean hasContributors(DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }
}

