/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.storage;

import com.intellij.history.core.storage.BrokenStorageException;
import com.intellij.history.core.storage.IContentStorage;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class CompressingContentStorage
implements IContentStorage {
    private final IContentStorage mySubject;
    private final Deflater myDeflater = new Deflater(1);
    private final Inflater myInflater = new Inflater();

    public CompressingContentStorage(IContentStorage s) {
        this.mySubject = s;
    }

    @Override
    public void save() {
        this.mySubject.save();
    }

    @Override
    public void close() {
        this.mySubject.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int store(byte[] content) throws BrokenStorageException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.myDeflater.reset();
            OutputStream s = this.createDeflaterOutputStream(output);
            try {
                s.write(content);
            }
            finally {
                s.close();
                this.myDeflater.reset();
            }
            return this.mySubject.store(output.toByteArray());
        }
        catch (IOException e) {
            throw new BrokenStorageException(e);
        }
    }

    @Override
    public byte[] load(int id) throws BrokenStorageException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] content = this.mySubject.load(id);
            this.myInflater.reset();
            InputStream s = this.createInflaterOutputStream(content);
            try {
                FileUtil.copy((InputStream)s, (OutputStream)output);
            }
            catch (IOException e) {
                String m = "Failed to copy content. id = " + id + " length=" + content.length;
                IOException newEx = new IOException(m);
                newEx.initCause(e);
                throw newEx;
            }
            finally {
                s.close();
                this.myInflater.reset();
            }
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new BrokenStorageException(e);
        }
    }

    protected OutputStream createDeflaterOutputStream(OutputStream output) {
        return new DeflaterOutputStream(output, this.myDeflater);
    }

    protected InputStream createInflaterOutputStream(byte[] content) {
        return new InflaterInputStream(new ByteArrayInputStream(content), this.myInflater);
    }

    @Override
    public void remove(int id) {
        this.mySubject.remove(id);
    }

    @Override
    public void setVersion(int version) {
        this.mySubject.setVersion(version);
    }

    @Override
    public int getVersion() {
        return this.mySubject.getVersion();
    }
}

