/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.CreateEntryChangeNonAppliedState;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.changes.StructuralChangeAppliedState;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;

public abstract class CreateEntryChange<NON_APPLIED_STATE_TYPE extends CreateEntryChangeNonAppliedState>
extends StructuralChange<NON_APPLIED_STATE_TYPE, StructuralChangeAppliedState> {
    public CreateEntryChange(int id, String path) {
        super(path);
        ((CreateEntryChangeNonAppliedState)this.getNonAppliedState()).myId = id;
    }

    public CreateEntryChange(Stream s) throws IOException {
        super(s);
    }

    @Override
    protected NON_APPLIED_STATE_TYPE createNonAppliedState() {
        return (NON_APPLIED_STATE_TYPE)new CreateEntryChangeNonAppliedState();
    }

    @Override
    protected StructuralChangeAppliedState createAppliedState() {
        return new StructuralChangeAppliedState();
    }

    protected String getEntryParentPath() {
        return Paths.getParentOf(this.getPath());
    }

    protected String getEntryName() {
        return new String(Paths.getNameOf(this.getPath()));
    }

    protected IdPath addEntry(Entry r, String parentPath, Entry e) {
        Entry parent = parentPath == null ? r : r.getEntry(parentPath);
        parent.addChild(e);
        return e.getIdPath();
    }

    @Override
    public void doRevertOn(Entry root) {
        Entry e = root.getEntry(this.getAffectedIdPath());
        this.removeEntry(e);
    }

    @Override
    public boolean isCreationalFor(Entry e) {
        return this.isCreationalFor(e.getIdPath());
    }

    public boolean isCreationalFor(IdPath p) {
        return p.getId() == this.getAffectedIdPath().getId();
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

