/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.core.ChangeSetsProcessor;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.storage.Content;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ByteContentRetriever
extends ChangeSetsProcessor {
    private final FileRevisionTimestampComparator myComparator;
    private long myCurrentFileTimestamp;
    private Content myCurrentFileContent;

    public ByteContentRetriever(LocalVcs vcs, String path, FileRevisionTimestampComparator c) {
        super(vcs, path);
        this.myComparator = c;
        this.myCurrentFileContent = this.myEntry.getContent();
        this.myCurrentFileTimestamp = this.myEntry.getTimestamp();
    }

    public byte[] getResult() {
        try {
            this.process();
        }
        catch (ContentFoundException ignore) {
            return this.myCurrentFileContent.getBytesIfAvailable();
        }
        return null;
    }

    @Override
    protected List<Change> collectChanges() {
        try {
            final ArrayList<Change> result = new ArrayList<Change>();
            this.myVcs.acceptRead(new ChangeVisitor(){

                @Override
                public void begin(ChangeSet c) {
                    if (c.affects(ByteContentRetriever.this.myEntry)) {
                        result.add(c);
                    }
                }
            });
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void nothingToVisit() {
        this.doVisit();
    }

    @Override
    protected void visitLabel(Change c) {
    }

    @Override
    public void visitRegular(Change c) {
        this.doVisit();
        this.recordContentAndTimestamp(c);
    }

    @Override
    protected void visitFirstAvailableNonCreational(Change c) {
        this.doVisit();
    }

    void doVisit() {
        if (this.myComparator.isSuitable(this.myCurrentFileTimestamp)) {
            throw new ContentFoundException();
        }
    }

    private void recordContentAndTimestamp(Change c) {
        for (Change each : c.getChanges()) {
            if (!each.isFileContentChange() || !each.affectsOnlyInside(this.myEntry)) continue;
            ContentChange cc = (ContentChange)each;
            this.myCurrentFileTimestamp = cc.getOldTimestamp();
            this.myCurrentFileContent = cc.getOldContent();
        }
    }

    private static class ContentFoundException
    extends RuntimeException {
        private ContentFoundException() {
        }
    }
}

