/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.featureStatistics.ProductivityFeaturesRegistry");
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<Pair<String, ApplicabilityFilter>> myApplicabilityFilters = new ArrayList<Pair<String, ApplicabilityFilter>>();
    private boolean myLoadAdditionFeatures = false;
    @NonNls
    public static final String WELCOME = "features.welcome";
    @NonNls
    private static final String TAG_FILTER = "filter";
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";
    @NonNls
    private static final String TODO_HTML_MARKER = "todo.html";
    @NonNls
    private static final String CLASS_ATTR = "class";
    @NonNls
    private static final String PREFIX_ATTR = "prefix";

    public ProductivityFeaturesRegistryImpl() {
        try {
            Document document = JDOMUtil.loadResourceDocument((URL)new URL("file:///ProductivityFeaturesRegistry.xml"));
            Element root = document.getRootElement();
            this.readGroups(root);
            this.readFilters(root);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        this.loadFeaturesFromProviders((ProductivityFeaturesProvider[])ApplicationManager.getApplication().getComponents(ProductivityFeaturesProvider.class));
        this.loadFeaturesFromProviders((ProductivityFeaturesProvider[])Extensions.getExtensions((ExtensionPointName)ProductivityFeaturesProvider.EP_NAME));
        this.myLoadAdditionFeatures = true;
    }

    private void loadFeaturesFromProviders(ProductivityFeaturesProvider[] providers) {
        for (ProductivityFeaturesProvider provider : providers) {
            GroupDescriptor[] groupDescriptors = provider.getGroupDescriptors();
            for (int j = 0; groupDescriptors != null && j < groupDescriptors.length; ++j) {
                GroupDescriptor groupDescriptor = groupDescriptors[j];
                this.myGroups.put(groupDescriptor.getId(), groupDescriptor);
            }
            FeatureDescriptor[] featureDescriptors = provider.getFeatureDescriptors();
            for (int j = 0; featureDescriptors != null && j < featureDescriptors.length; ++j) {
                FeatureDescriptor featureDescriptor = featureDescriptors[j];
                FeatureDescriptor featureLoadedStatistics = this.myFeatures.get(featureDescriptor.getId());
                if (featureLoadedStatistics != null) {
                    featureDescriptor.copyStatistics(featureLoadedStatistics);
                }
                this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
            }
            ApplicabilityFilter[] applicabilityFilters = provider.getApplicabilityFilters();
            for (int j = 0; applicabilityFilters != null && j < applicabilityFilters.length; ++j) {
                ApplicabilityFilter applicabilityFilter = applicabilityFilters[j];
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)new Pair((Object)applicabilityFilter.getPrefix(), (Object)applicabilityFilter));
            }
        }
    }

    private void readFilters(Element element) {
        List filters = element.getChildren(TAG_FILTER);
        for (int i = 0; i < filters.size(); ++i) {
            Element filterElement = (Element)filters.get(i);
            String className = filterElement.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> klass = Class.forName(className);
                if (!ApplicabilityFilter.class.isAssignableFrom(klass)) {
                    LOG.error("filter class must implement com.intellij.featureSatistics.ApplicabilityFilter");
                    continue;
                }
                ApplicabilityFilter filter = (ApplicabilityFilter)klass.newInstance();
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)new Pair((Object)filterElement.getAttributeValue(PREFIX_ATTR), (Object)filter));
                continue;
            }
            catch (Exception e) {
                LOG.error("Cannot instantiate filter " + className, (Throwable)e);
            }
        }
    }

    private void readGroups(Element element) {
        List groups = element.getChildren(TAG_GROUP);
        for (int i = 0; i < groups.size(); ++i) {
            Element groupElement = (Element)groups.get(i);
            this.readGroup(groupElement);
        }
    }

    private void readGroup(Element groupElement) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId = groupDescriptor.getId();
        this.myGroups.put(groupId, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor) {
        List features = groupElement.getChildren(TAG_FEATURE);
        for (int i = 0; i < features.size(); ++i) {
            Element featureElement = (Element)features.get(i);
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor);
            featureDescriptor.readExternal(featureElement);
            if (TODO_HTML_MARKER.equals(featureDescriptor.getTipFileName())) continue;
            this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
        }
    }

    public Set<String> getFeatureIds() {
        if (!this.myLoadAdditionFeatures) {
            this.lazyLoadFromPluginsFeaturesProviders();
        }
        return this.myFeatures.keySet();
    }

    public FeatureDescriptor getFeatureDescriptor(String id) {
        if (WELCOME.equals(id)) {
            FeatureDescriptor descriptor = new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message((String)"feature.statistics.welcome.tip.name", (Object[])new Object[0]));
            return descriptor;
        }
        if (!this.myLoadAdditionFeatures) {
            this.lazyLoadFromPluginsFeaturesProviders();
        }
        return this.myFeatures.get(id);
    }

    public FeatureDescriptor getFeatureDescriptorEx(String id) {
        if (WELCOME.equals(id)) {
            FeatureDescriptor descriptor = new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message((String)"feature.statistics.welcome.tip.name", (Object[])new Object[0]));
            return descriptor;
        }
        return this.myFeatures.get(id);
    }

    public GroupDescriptor getGroupDescriptor(String id) {
        return this.myGroups.get(id);
    }

    public ApplicabilityFilter[] getMatchingFilters(String featureId) {
        if (!this.myLoadAdditionFeatures) {
            this.lazyLoadFromPluginsFeaturesProviders();
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        for (int i = 0; i < this.myApplicabilityFilters.size(); ++i) {
            Pair<String, ApplicabilityFilter> pair = this.myApplicabilityFilters.get(i);
            if (!featureId.startsWith((String)pair.getFirst())) continue;
            filters.add(pair.getSecond());
        }
        return filters.toArray(new ApplicabilityFilter[filters.size()]);
    }

    public void addFeatureStatistics(FeatureDescriptor descriptor) {
        this.myFeatures.put(descriptor.getId(), descriptor);
    }
}

