/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.util.OrderEntryCellAppearanceUtils;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.Icons;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLibrariesDialog
extends DialogWrapper {
    private final LibraryElementChooser myChooser;

    public ChooseLibrariesDialog(Component parent, List<Library> libraries) {
        super(parent, true);
        this.setTitle(ProjectBundle.message((String)"dialog.title.select.libraries", (Object[])new Object[0]));
        this.setModal(true);
        this.myChooser = new LibraryElementChooser(libraries);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myChooser;
    }

    public void markElements(Collection<Library> elements) {
        this.myChooser.markElements(elements);
    }

    public List<Library> getMarkedLibraries() {
        return this.myChooser.getMarkedElements();
    }

    private static class LibraryElementChooser
    extends ElementsChooser<Library> {
        private LibraryElementChooser(List<Library> elements) {
            super(elements, false);
        }

        @Override
        protected Icon getItemIcon(Library value) {
            return Icons.LIBRARY_ICON;
        }

        @Override
        protected String getItemText(@NotNull Library value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/ChooseLibrariesDialog$LibraryElementChooser.getItemText must not be null");
            }
            return OrderEntryCellAppearanceUtils.forLibrary((Library)value).getText();
        }
    }
}

