/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.autodetecting.DetectedFacetPresentation;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.impl.autodetecting.DefaultDetectedFacetPresentation;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManagerImpl;
import com.intellij.facet.impl.autodetecting.FacetDetectorRegistryEx;
import com.intellij.facet.impl.autodetecting.facetsTree.DetectedFacetsDialog;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.FacetInfoBackedByFacet;
import com.intellij.facet.impl.autodetecting.model.ProjectFacetInfoSet;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DetectedFacetManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.autodetecting.DetectedFacetManager");
    @NonNls
    private static final String NOTIFICATION_ID = "Facet Detector";
    private static final int NOTIFICATION_DELAY = 200;
    private final Project myProject;
    private final FacetAutodetectingManagerImpl myAutodetectingManager;
    private final ProjectWideFacetListenersRegistry myProjectWideFacetListenersRegistry;
    private boolean myUIInitialized;
    private final Set<DetectedFacetInfo<Module>> myPendingNewFacets = new HashSet<DetectedFacetInfo<Module>>();
    private final Alarm myNotificationAlarm = new Alarm();
    private final ProjectFacetInfoSet myDetectedFacetSet;
    private final List<FacetDetectedNotification> myNotifications = new ArrayList<FacetDetectedNotification>();

    public DetectedFacetManager(Project project, FacetAutodetectingManagerImpl autodetectingManager, ProjectFacetInfoSet detectedFacetSet) {
        this.myDetectedFacetSet = detectedFacetSet;
        this.myProjectWideFacetListenersRegistry = ProjectWideFacetListenersRegistry.getInstance((Project)project);
        this.myProject = project;
        this.myAutodetectingManager = autodetectingManager;
        this.myDetectedFacetSet.addListener(new ProjectFacetInfoSet.DetectedFacetListener(){

            @Override
            public void facetDetected(DetectedFacetInfo<Module> info) {
                DetectedFacetManager.this.onDetectedFacetChanged(Collections.singletonList(info), Collections.<DetectedFacetInfo<Module>>emptyList());
            }

            @Override
            public void facetRemoved(DetectedFacetInfo<Module> info) {
                DetectedFacetManager.this.myAutodetectingManager.getFileIndex().removeFromIndex(info);
                DetectedFacetManager.this.onDetectedFacetChanged(Collections.<DetectedFacetInfo<Module>>emptyList(), Collections.singletonList(info));
            }
        });
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myProject.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleRemoved(Project project, Module module) {
                DetectedFacetManager.this.myDetectedFacetSet.removeDetectedFacets(module);
            }
        });
    }

    public <F extends Facet<C>, C extends FacetConfiguration> void registerListeners(FacetType<F, C> type) {
        this.myProjectWideFacetListenersRegistry.registerListener(type.getId(), new MyProjectWideFacetListener(), (Disposable)this);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void onDetectedFacetChanged(final @NotNull Collection<DetectedFacetInfo<Module>> added, final @NotNull Collection<DetectedFacetInfo<Module>> removed) {
        if (added == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager.onDetectedFacetChanged must not be null");
        }
        if (removed == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager.onDetectedFacetChanged must not be null");
        }
        if (!this.myUIInitialized) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (DetectedFacetManager.this.isDisposed()) {
                        return;
                    }
                    DetectedFacetManager.this.myPendingNewFacets.addAll(added);
                    for (FacetDetectedNotification notification : DetectedFacetManager.this.myNotifications) {
                        for (DetectedFacetInfo facetInfo : removed) {
                            notification.processFacetRemoved(facetInfo);
                        }
                    }
                    DetectedFacetManager.this.queueNotificationPopup();
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
        }
    }

    private void queueNotificationPopup() {
        this.myNotificationAlarm.cancelAllRequests();
        this.myNotificationAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                DetectedFacetManager.this.firePendingNotifications();
            }
        }, 200);
    }

    public boolean isDisposed() {
        return this.myProject.isDisposed() || !this.myUIInitialized;
    }

    private void firePendingNotifications() {
        if (this.myPendingNewFacets.isEmpty() || this.myProject.isDisposed()) {
            return;
        }
        ArrayList<DetectedFacetInfo<Module>> newFacets = new ArrayList<DetectedFacetInfo<Module>>();
        for (DetectedFacetInfo<Module> newFacet : this.myPendingNewFacets) {
            newFacets.add(newFacet);
        }
        this.myPendingNewFacets.clear();
        this.fireNotification(newFacets);
    }

    private void fireNotification(List<DetectedFacetInfo<Module>> newFacets) {
        if (newFacets.isEmpty()) {
            return;
        }
        boolean showNotification = true;
        HashMap<DetectedFacetInfo<Module>, List<VirtualFile>> filesMap = this.getFilesMap(newFacets);
        if (!filesMap.isEmpty() && showNotification) {
            FacetDetectedNotification notification;
            Set<DetectedFacetInfo<Module>> detectedFacetInfos = filesMap.keySet();
            if (filesMap.size() == 1) {
                DetectedFacetInfo<Module> facetInfo = detectedFacetInfos.iterator().next();
                List<VirtualFile> files = filesMap.get(facetInfo);
                notification = this.createSingleFacetDetectedNotification(facetInfo, VfsUtil.toVirtualFileArray(files));
            } else {
                notification = this.createSeveralFacetsDetectedNotification(filesMap.keySet());
            }
            this.myNotifications.add(notification);
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        } else {
            this.myPendingNewFacets.addAll(newFacets);
        }
    }

    public void dispose() {
    }

    public void initUI() {
        this.myUIInitialized = true;
        this.onDetectedFacetChanged(this.myDetectedFacetSet.getAllDetectedFacets(), Collections.<DetectedFacetInfo<Module>>emptyList());
    }

    public void disposeUI() {
        if (!this.myUIInitialized) {
            return;
        }
        this.myNotificationAlarm.cancelAllRequests();
    }

    public void disableDetectionInFile(DetectedFacetInfo<Module> detectedFacet) {
        Set<String> urls = this.myAutodetectingManager.getFileIndex().getFiles(detectedFacet.getId());
        if (urls != null && !urls.isEmpty()) {
            this.myAutodetectingManager.disableAutodetectionInFiles(detectedFacet.getFacetType(), (Module)detectedFacet.getModule(), ArrayUtil.toStringArray(urls));
        }
        this.myAutodetectingManager.getDetectedFacetSet().removeFacetInfo((FacetInfo2<Module>)detectedFacet);
    }

    public void disableDetectionInModule(DetectedFacetInfo<Module> detectedFacetInfo) {
        this.disableDetectionInModule(detectedFacetInfo.getFacetType(), (Module)detectedFacetInfo.getModule());
    }

    public void disableDetectionInModule(FacetType type, Module module) {
        this.myAutodetectingManager.disableAutodetectionInModule(type, module);
        this.myAutodetectingManager.getDetectedFacetSet().removeDetectedFacets(type.getId(), module);
    }

    public boolean showDetectedFacetsDialog() {
        boolean processed;
        ArrayList<DetectedFacetInfo<Module>> detectedFacets = new ArrayList<DetectedFacetInfo<Module>>(this.myDetectedFacetSet.getAllDetectedFacets());
        HashMap<DetectedFacetInfo<Module>, List<VirtualFile>> filesMap = this.getFilesMap(detectedFacets);
        if (detectedFacets.isEmpty()) {
            this.removeAllNotifications();
            return false;
        }
        DetectedFacetsDialog dialog = new DetectedFacetsDialog(this.myProject, this, detectedFacets, filesMap);
        dialog.show();
        boolean bl = processed = dialog.getExitCode() == 0;
        if (processed) {
            this.removeAllNotifications();
        }
        return processed;
    }

    private HashMap<DetectedFacetInfo<Module>, List<VirtualFile>> getFilesMap(List<DetectedFacetInfo<Module>> detectedFacets) {
        MultiValuesMap facet2Children = new MultiValuesMap();
        for (DetectedFacetInfo<Module> detected : detectedFacets) {
            FacetInfo2 underlying = detected.getUnderlyingFacetInfo();
            if (!(underlying instanceof DetectedFacetInfo)) continue;
            facet2Children.put((Object)((DetectedFacetInfo)underlying), detected);
        }
        HashMap<DetectedFacetInfo<Module>, List<VirtualFile>> filesMap = new HashMap<DetectedFacetInfo<Module>, List<VirtualFile>>();
        HashSet<DetectedFacetInfo<Module>> toRemove = new HashSet<DetectedFacetInfo<Module>>();
        for (DetectedFacetInfo<Module> detected : detectedFacets) {
            Set<String> urls = this.myAutodetectingManager.getFileIndex().getFiles(detected.getId());
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            if (urls != null) {
                for (String url : urls) {
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (file == null) continue;
                    files.add(file);
                }
            }
            if (!files.isEmpty()) {
                filesMap.put(detected, files);
                continue;
            }
            DetectedFacetManager.addWithChildren(detected, (MultiValuesMap<DetectedFacetInfo<Module>, DetectedFacetInfo<Module>>)facet2Children, toRemove);
        }
        detectedFacets.removeAll(toRemove);
        return filesMap;
    }

    private static void addWithChildren(DetectedFacetInfo<Module> detected, MultiValuesMap<DetectedFacetInfo<Module>, DetectedFacetInfo<Module>> facet2Children, Set<DetectedFacetInfo<Module>> result) {
        Collection children;
        if (result.add(detected) && (children = facet2Children.get(detected)) != null) {
            for (DetectedFacetInfo info : children) {
                DetectedFacetManager.addWithChildren(info, facet2Children, result);
            }
        }
    }

    public Facet createFacet(DetectedFacetInfo<Module> info, Facet underlyingFacet) {
        Module module = (Module)info.getModule();
        FacetType<?, ?> type = info.getFacetType();
        Facet facet = DetectedFacetManager.createFacet(info, module, underlyingFacet, type);
        ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        FacetDetector<?, ?> detector = this.myAutodetectingManager.findDetector(info.getDetectorId());
        if (detector != null) {
            detector.beforeFacetAdded(facet, (FacetModel)model, rootModel);
        }
        model.addFacet(facet);
        if (rootModel.isChanged()) {
            rootModel.commit();
        } else {
            rootModel.dispose();
        }
        model.commit();
        this.myAutodetectingManager.getFileIndex().updateIndexEntryForCreatedFacet(info, facet);
        this.myAutodetectingManager.getDetectedFacetSet().removeFacetInfo((FacetInfo2<Module>)info);
        if (detector != null) {
            detector.afterFacetAdded(facet);
        }
        return facet;
    }

    private static <C extends FacetConfiguration, F extends Facet> Facet createFacet(DetectedFacetInfo<Module> info, Module module, Facet underlyingFacet, FacetType<F, C> facetType) {
        return FacetManager.getInstance((Module)module).createFacet(facetType, info.getFacetName(), info.getConfiguration(), underlyingFacet);
    }

    private FacetDetectedNotification createSingleFacetDetectedNotification(final DetectedFacetInfo<Module> detectedFacetInfo, VirtualFile[] files) {
        DetectedFacetPresentation presentation = FacetDetectorRegistryEx.getDetectedFacetPresentation(detectedFacetInfo.getFacetType());
        String text = presentation.getAutodetectionPopupText((Module)detectedFacetInfo.getModule(), detectedFacetInfo.getFacetType(), detectedFacetInfo.getFacetName(), files);
        if (text == null) {
            text = DefaultDetectedFacetPresentation.INSTANCE.getAutodetectionPopupText((Module)detectedFacetInfo.getModule(), detectedFacetInfo.getFacetType(), detectedFacetInfo.getFacetName(), files);
        }
        String description = ProjectBundle.message((String)"facet.autodetected.info.text", (Object[])new Object[]{detectedFacetInfo.getFacetType().getPresentableName(), text, detectedFacetInfo.getFacetName()});
        String title = ProjectBundle.message((String)"notification.name.0.facet.detected", (Object[])new Object[]{detectedFacetInfo.getFacetType().getPresentableName()});
        return new FacetDetectedNotification(title, description, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager$5.hyperlinkUpdate must not be null");
                }
                if (event == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager$5.hyperlinkUpdate must not be null");
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    notification.expire();
                    if (DetectedFacetManager.this.isDisposed()) {
                        return;
                    }
                    String link = event.getDescription();
                    if ("create".equals(link)) {
                        FacetInfo2 underlyingInfo = detectedFacetInfo.getUnderlyingFacetInfo();
                        final Facet underlyingFacet = underlyingInfo != null ? ((FacetInfoBackedByFacet)underlyingInfo).getFacet() : null;
                        new WriteAction(){

                            protected void run(Result result) {
                                DetectedFacetManager.this.createFacet(detectedFacetInfo, underlyingFacet);
                            }
                        }.execute();
                    } else if ("disable".equals(link)) {
                        DetectedFacetManager.this.disableDetectionInModule(detectedFacetInfo);
                    } else {
                        LOG.error(link);
                    }
                }
            }
        }, Collections.singletonList(detectedFacetInfo));
    }

    private FacetDetectedNotification createSeveralFacetsDetectedNotification(Set<DetectedFacetInfo<Module>> facets) {
        String title = ProjectBundle.message((String)"notification.name.0.facets.detected", (Object[])new Object[]{facets.size()});
        String content = ProjectBundle.message((String)"facet.autodetection.several.facets.detected.text", (Object[])new Object[]{facets.size()});
        return new FacetDetectedNotification(title, content, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager$6.hyperlinkUpdate must not be null");
                }
                if (event == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager$6.hyperlinkUpdate must not be null");
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (DetectedFacetManager.this.isDisposed()) {
                        return;
                    }
                    if ("more".equals(event.getDescription())) {
                        DetectedFacetManager.this.showDetectedFacetsDialog();
                    }
                }
            }
        }, facets);
    }

    private void removeAllNotifications() {
        for (FacetDetectedNotification notification : this.myNotifications) {
            if (notification.isExpired()) continue;
            notification.expire();
        }
        this.myNotifications.clear();
    }

    private static class FacetDetectedNotification
    extends Notification {
        private List<DetectedFacetInfo<Module>> myFacets;

        private FacetDetectedNotification(@NotNull String title, @NotNull String content, NotificationListener listener, Collection<DetectedFacetInfo<Module>> facets) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager$FacetDetectedNotification.<init> must not be null");
            }
            if (content == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DetectedFacetManager$FacetDetectedNotification.<init> must not be null");
            }
            super(DetectedFacetManager.NOTIFICATION_ID, title, content, NotificationType.INFORMATION, listener);
            this.myFacets = new ArrayList<DetectedFacetInfo<Module>>();
            this.myFacets.addAll(facets);
        }

        public void processFacetRemoved(DetectedFacetInfo<Module> facetInfo) {
            this.myFacets.remove(facetInfo);
            if (this.myFacets.isEmpty() && !this.isExpired()) {
                this.expire();
            }
        }
    }

    private class MyProjectWideFacetListener<F extends Facet<C>, C extends FacetConfiguration>
    extends ProjectWideFacetAdapter<F> {
        private MyProjectWideFacetListener() {
        }

        public void facetAdded(F facet) {
            Map map = DetectedFacetManager.this.myDetectedFacetSet.getConfigurations(facet.getTypeId(), facet.getModule());
            Collection<FacetInfo2<Module>> infos = map.values();
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (FacetInfo2<Module> info : infos) {
                Set<String> urls;
                if (!(info instanceof DetectedFacetInfo) || (urls = DetectedFacetManager.this.myAutodetectingManager.getFileIndex().getFiles(((DetectedFacetInfo)info).getId())) == null) continue;
                for (String url : urls) {
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (file == null) continue;
                    files.add(file);
                }
            }
            for (VirtualFile file : files) {
                DetectedFacetManager.this.myAutodetectingManager.processFile(file);
            }
        }

        public void beforeFacetRemoved(F facet) {
            Set<String> files = DetectedFacetManager.this.myAutodetectingManager.getFiles((Facet)facet);
            if (files != null) {
                DetectedFacetManager.this.myAutodetectingManager.disableAutodetectionInFiles(facet.getType(), facet.getModule(), ArrayUtil.toStringArray(files));
            }
            DetectedFacetManager.this.myAutodetectingManager.removeFacetFromCache((Facet)facet);
        }
    }
}

