/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NotNull;

public abstract class MetadataPsiFileBase
extends PsiFileImpl {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ParserDefinition myParserDefinition;
    private PsiFile mySourceFile;

    public MetadataPsiFileBase(FileViewProvider provider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/MetadataPsiFileBase.<init> must not be null");
        }
        super(provider);
        this.myLanguage = language;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null.");
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        this.init((IElementType)nodeType, (IElementType)nodeType);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/MetadataPsiFileBase.accept must not be null");
        }
        visitor.visitFile((PsiFile)this);
    }

    @Override
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/MetadataPsiFileBase.getLanguage must not return null");
        }
        return language;
    }

    public final PsiFile getSourceFile() {
        return this.mySourceFile;
    }

    public final void setSourceFile(PsiFile sourceFile) {
        this.mySourceFile = sourceFile;
    }
}

