/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.SuiteInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.ui.PrintableTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestProxy
extends CompositePrintable
implements PrintableTestProxy {
    private static final Logger LOG = Logger.getInstance((String)SMTestProxy.class.getName());
    private List<SMTestProxy> myChildren;
    private SMTestProxy myParent;
    private AbstractState myState = NotRunState.getInstance();
    private final String myName;
    private Integer myDuration = null;
    @Nullable
    private final String myLocationUrl;
    private boolean myDurationIsCached = false;
    private boolean myHasErrors = false;
    private boolean myHasErrorsCached = false;
    private Printer myPrinter = Printer.DEAF;
    private final boolean myIsSuite;

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
    }

    @Override
    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    @Override
    public boolean isDefect() {
        return this.myState.isDefect();
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        if (this.myHasErrorsCached) {
            return this.myHasErrors;
        }
        boolean canCacheErrors = !this.myState.isInProgress();
        boolean hasErrors = this.calcHasErrors();
        if (canCacheErrors) {
            this.myHasErrors = hasErrors;
            this.myHasErrorsCached = true;
        }
        return hasErrors;
    }

    private boolean calcHasErrors() {
        if (this.myHasErrors) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasErrors()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    @Override
    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(SMTestProxy child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<SMTestProxy>();
        }
        this.myChildren.add(child);
        this.addLast(child);
        child.setParent(this);
        if (this.myPrinter != Printer.DEAF) {
            child.setPrintLinstener(this.myPrinter);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public Location getLocation(Project project) {
        if (this.myLocationUrl == null) {
            return null;
        }
        String protocolId = TestsLocationProviderUtil.extractProtocol(this.myLocationUrl);
        String path = TestsLocationProviderUtil.extractPath(this.myLocationUrl);
        if (protocolId != null && path != null) {
            for (TestLocationProvider provider : (TestLocationProvider[])Extensions.getExtensions(TestLocationProvider.EP_NAME)) {
                List<Location> locations = provider.getLocation(protocolId, path, project);
                if (locations.isEmpty()) continue;
                return locations.iterator().next();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Navigatable getDescriptor(Location location) {
        if (location != null) {
            return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
        }
        return null;
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    @Override
    public SMTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends SMTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<SMTestProxy> getAllTests() {
        ArrayList<SMTestProxy> allTests = new ArrayList<SMTestProxy>();
        allTests.add(this);
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            allTests.addAll(sMTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new SuiteInProgressState(this);
    }

    @Nullable
    public Integer getDuration() {
        if (this.myDurationIsCached || !this.isSuite()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    public void setDuration(int duration) {
        this.invalidateCachedDurationForContainerSuites();
        if (!this.isSuite()) {
            this.myDurationIsCached = true;
            this.myDuration = duration >= 0 ? Integer.valueOf(duration) : null;
            return;
        }
        LOG.warn("Unsupported operation");
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/SMTestProxy.setTestFailed must not be null");
        }
        this.myState = testError ? new TestErrorState(localizedMessage, stackTrace) : new TestFailedState(localizedMessage, stackTrace);
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestIgnored(@NotNull String ignoreComment, @Nullable String stackTrace) {
        if (ignoreComment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/SMTestProxy.setTestIgnored must not be null");
        }
        this.myState = new TestIgnoredState(ignoreComment, stackTrace);
        this.fireOnNewPrintable(this.myState);
    }

    public void setParent(@Nullable SMTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends SMTestProxy> getChildren(@Nullable Filter filter) {
        List<? extends SMTestProxy> allChildren = this.getChildren();
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<SMTestProxy> selectedChildren = new ArrayList<SMTestProxy>();
        for (SMTestProxy sMTestProxy : allChildren) {
            if (!filter.shouldAccept(sMTestProxy)) continue;
            selectedChildren.add(sMTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public void setPrintLinstener(Printer printer) {
        this.myPrinter = printer;
        if (this.myChildren == null) {
            return;
        }
        for (SMTestProxy child : this.myChildren) {
            child.setPrintLinstener(printer);
        }
    }

    @Override
    public void printOn(Printer printer) {
        super.printOn(printer);
        this.myState.printOn(printer);
    }

    @Override
    public void addLast(Printable printable) {
        super.addLast(printable);
        this.fireOnNewPrintable(printable);
    }

    public void addStdOutput(final String output, final Key outputType) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        });
    }

    public void addStdErr(final String output) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.ERROR_OUTPUT);
            }
        });
    }

    public void addError(final String output, final @Nullable String stackTrace) {
        this.myHasErrors = true;
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                String errorText = TestFailedState.buildErrorPresentationText(output, stackTrace);
                LOG.assertTrue(errorText != null);
                TestFailedState.printError(printer, errorText);
            }
        });
    }

    public void addSystemOutput(final String output) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    private void fireOnNewPrintable(Printable printable) {
        this.myPrinter.onNewAvailable(printable);
    }

    @NotNull
    public String getPresentableName() {
        String string = TestsPresentationUtil.getPresentableName(this);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/SMTestProxy.getPresentableName must not return null");
        }
        return string;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public void setTerminated() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = TerminatedState.INSTANCE;
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            sMTestProxy.setTerminated();
        }
        this.fireOnNewPrintable(this.myState);
    }

    public boolean wasTerminated() {
        return this.myState.wasTerminated();
    }

    @Nullable
    protected String getLocationUrl() {
        return this.myLocationUrl;
    }

    private boolean containsErrorTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    private AbstractState determineSuiteStateOnFinished() {
        SuiteFinishedState state = this.isLeaf() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE)) : SuiteFinishedState.PASSED_SUITE);
        return state;
    }

    @Nullable
    private Integer calcSuiteDuration() {
        int partialDuration = 0;
        boolean durationOfChildrenIsUnknown = true;
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            Integer duration = sMTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.intValue();
        }
        return durationOfChildrenIsUnknown ? null : Integer.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites() {
        this.myDuration = null;
        this.myDurationIsCached = false;
        SMTestProxy containerSuite = this.getParent();
        if (containerSuite != null) {
            containerSuite.invalidateCachedDurationForContainerSuites();
        }
    }
}

