/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConsoleHistoryModel {
    public static final int DEFAULT_MAX_SIZE = 20;
    private int myHistoryCursor;
    private int myMaxHistorySize = 20;
    private final LinkedList<String> myHistory = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistory(String statement) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.myHistoryCursor = -1;
            this.myHistory.remove(statement);
            if (this.myHistory.size() >= this.myMaxHistorySize) {
                this.myHistory.removeLast();
            }
            this.myHistory.addFirst(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHistory() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return new ArrayList<String>(this.myHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxHistorySize() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return this.myMaxHistorySize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxHistorySize(int maxHistorySize) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.myMaxHistorySize = maxHistorySize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getHistoryNext() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            if (this.myHistoryCursor < this.myHistory.size() - 1) {
                return this.myHistory.get(++this.myHistoryCursor);
            }
            if (this.myHistoryCursor == this.myHistory.size() - 1) {
                ++this.myHistoryCursor;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getHistoryPrev() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            if (this.myHistoryCursor > 0) {
                return this.myHistory.get(--this.myHistoryCursor);
            }
            if (this.myHistoryCursor == 0) {
                --this.myHistoryCursor;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHistory(boolean next) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return next ? this.myHistoryCursor <= this.myHistory.size() - 1 : this.myHistoryCursor >= 0;
        }
    }

    public static AnAction createHistoryAction(final ConsoleHistoryModel model, final boolean next, final PairProcessor<AnActionEvent, String> processor) {
        AnAction action = new AnAction(null, null, null){

            public void actionPerformed(AnActionEvent e) {
                processor.process((Object)e, (Object)(next ? model.getHistoryNext() : model.getHistoryPrev()));
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(model.hasHistory(next));
            }
        };
        EmptyAction.setupAction((AnAction)action, (String)(next ? "Console.History.Next" : "Console.History.Previous"), null);
        return action;
    }
}

